/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.nuxeo.onedrive.client.OneDriveAPIException;

public abstract class AbstractResponse<C>
implements Closeable {
    private static final int BUFFER_SIZE = 8192;
    private final HttpURLConnection connection;
    private int responseCode;
    private String errorString;
    private InputStream inputStream;
    private boolean closed;

    public AbstractResponse(HttpURLConnection connection) throws OneDriveAPIException {
        this.connection = connection;
        try {
            this.responseCode = connection.getResponseCode();
        }
        catch (IOException e) {
            throw new OneDriveAPIException("Couldn't connect to the OneDrive API due to a network error.", e);
        }
        if (!AbstractResponse.isSuccess(this.responseCode)) {
            throw new OneDriveAPIException("The API returned an error code: " + this.responseCode, this.responseCode, this.getErrorString());
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public abstract C getContent() throws OneDriveAPIException;

    protected InputStream getBody() throws OneDriveAPIException {
        if (this.inputStream == null) {
            try {
                this.inputStream = this.handleGZIPStream(this.connection.getInputStream());
            }
            catch (IOException e) {
                throw new OneDriveAPIException("Couldn't connect to the OneDrive API due to a network error.", e);
            }
        }
        return new ResponseInputStream();
    }

    protected String getErrorString() {
        if (this.errorString == null && !AbstractResponse.isSuccess(this.responseCode)) {
            this.errorString = this.readErrorStream();
        }
        return this.errorString;
    }

    private String readErrorStream() {
        try {
            return AbstractResponse.readStream(this.getErrorStream());
        }
        catch (OneDriveAPIException e) {
            return null;
        }
    }

    private InputStream getErrorStream() {
        InputStream errorStream = this.connection.getErrorStream();
        try {
            return this.handleGZIPStream(errorStream);
        }
        catch (IOException e) {
            return errorStream;
        }
    }

    private InputStream handleGZIPStream(InputStream stream) throws IOException {
        if (stream != null && "gzip".equalsIgnoreCase(this.connection.getContentEncoding())) {
            return new GZIPInputStream(stream);
        }
        return stream;
    }

    @Override
    public void close() throws OneDriveAPIException {
        if (this.closed) {
            return;
        }
        try {
            InputStream stream = this.connection.getInputStream();
            byte[] buffer = new byte[8192];
            int n = stream.read(buffer);
            while (n != -1) {
                n = stream.read(buffer);
            }
            stream.close();
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            this.closed = true;
        }
        catch (IOException e) {
            throw new OneDriveAPIException("Couldn't close the connection to OneDrive API due to a network error.", e);
        }
    }

    private static boolean isSuccess(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    protected static String readStream(InputStream stream) throws OneDriveAPIException {
        if (stream == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[8192];
        try {
            int read;
            while ((read = reader.read(buffer, 0, 8192)) != -1) {
                builder.append(buffer, 0, read);
            }
            stream.close();
        }
        catch (IOException e) {
            throw new OneDriveAPIException("Couldn't read the stream from OneDrive API.", e);
        }
        return builder.toString();
    }

    private class ResponseInputStream
    extends InputStream {
        private ResponseInputStream() {
        }

        @Override
        public int read() throws IOException {
            return AbstractResponse.this.inputStream.read();
        }

        @Override
        public void close() throws IOException {
            AbstractResponse.this.close();
        }
    }
}

