/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.PathRootError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class LookupError {
    public static final LookupError NOT_FOUND = new LookupError(Tag.NOT_FOUND, null, null);
    public static final LookupError NOT_FILE = new LookupError(Tag.NOT_FILE, null, null);
    public static final LookupError NOT_FOLDER = new LookupError(Tag.NOT_FOLDER, null, null);
    public static final LookupError RESTRICTED_CONTENT = new LookupError(Tag.RESTRICTED_CONTENT, null, null);
    public static final LookupError OTHER = new LookupError(Tag.OTHER, null, null);
    private final Tag _tag;
    private final String malformedPathValue;
    private final PathRootError invalidPathRootValue;

    private LookupError(Tag _tag, String malformedPathValue, PathRootError invalidPathRootValue) {
        this._tag = _tag;
        this.malformedPathValue = malformedPathValue;
        this.invalidPathRootValue = invalidPathRootValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isMalformedPath() {
        return this._tag == Tag.MALFORMED_PATH;
    }

    public static LookupError malformedPath(String value) {
        return new LookupError(Tag.MALFORMED_PATH, value, null);
    }

    public static LookupError malformedPath() {
        return LookupError.malformedPath(null);
    }

    public String getMalformedPathValue() {
        if (this._tag != Tag.MALFORMED_PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.MALFORMED_PATH, but was Tag." + this._tag.name());
        }
        return this.malformedPathValue;
    }

    public boolean isNotFound() {
        return this._tag == Tag.NOT_FOUND;
    }

    public boolean isNotFile() {
        return this._tag == Tag.NOT_FILE;
    }

    public boolean isNotFolder() {
        return this._tag == Tag.NOT_FOLDER;
    }

    public boolean isRestrictedContent() {
        return this._tag == Tag.RESTRICTED_CONTENT;
    }

    public boolean isInvalidPathRoot() {
        return this._tag == Tag.INVALID_PATH_ROOT;
    }

    public static LookupError invalidPathRoot(PathRootError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LookupError(Tag.INVALID_PATH_ROOT, null, value);
    }

    public PathRootError getInvalidPathRootValue() {
        if (this._tag != Tag.INVALID_PATH_ROOT) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_PATH_ROOT, but was Tag." + this._tag.name());
        }
        return this.invalidPathRootValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.malformedPathValue, this.invalidPathRootValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LookupError) {
            LookupError other = (LookupError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case MALFORMED_PATH: {
                    return this.malformedPathValue == other.malformedPathValue || this.malformedPathValue != null && this.malformedPathValue.equals(other.malformedPathValue);
                }
                case NOT_FOUND: {
                    return true;
                }
                case NOT_FILE: {
                    return true;
                }
                case NOT_FOLDER: {
                    return true;
                }
                case RESTRICTED_CONTENT: {
                    return true;
                }
                case INVALID_PATH_ROOT: {
                    return this.invalidPathRootValue == other.invalidPathRootValue || this.invalidPathRootValue.equals(other.invalidPathRootValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<LookupError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(LookupError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case MALFORMED_PATH: {
                    g.writeStartObject();
                    this.writeTag("malformed_path", g);
                    g.writeFieldName("malformed_path");
                    StoneSerializers.nullable(StoneSerializers.string()).serialize(value.malformedPathValue, g);
                    g.writeEndObject();
                    break;
                }
                case NOT_FOUND: {
                    g.writeString("not_found");
                    break;
                }
                case NOT_FILE: {
                    g.writeString("not_file");
                    break;
                }
                case NOT_FOLDER: {
                    g.writeString("not_folder");
                    break;
                }
                case RESTRICTED_CONTENT: {
                    g.writeString("restricted_content");
                    break;
                }
                case INVALID_PATH_ROOT: {
                    g.writeStartObject();
                    this.writeTag("invalid_path_root", g);
                    PathRootError.Serializer.INSTANCE.serialize(value.invalidPathRootValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public LookupError deserialize(JsonParser p) throws IOException, JsonParseException {
            LookupError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("malformed_path".equals(tag)) {
                String fieldValue = null;
                if (p.getCurrentToken() != JsonToken.END_OBJECT) {
                    Serializer.expectField("malformed_path", p);
                    fieldValue = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                }
                value = fieldValue == null ? LookupError.malformedPath() : LookupError.malformedPath(fieldValue);
            } else if ("not_found".equals(tag)) {
                value = NOT_FOUND;
            } else if ("not_file".equals(tag)) {
                value = NOT_FILE;
            } else if ("not_folder".equals(tag)) {
                value = NOT_FOLDER;
            } else if ("restricted_content".equals(tag)) {
                value = RESTRICTED_CONTENT;
            } else if ("invalid_path_root".equals(tag)) {
                PathRootError fieldValue = null;
                fieldValue = PathRootError.Serializer.INSTANCE.deserialize(p, true);
                value = LookupError.invalidPathRoot(fieldValue);
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        MALFORMED_PATH,
        NOT_FOUND,
        NOT_FILE,
        NOT_FOLDER,
        RESTRICTED_CONTENT,
        INVALID_PATH_ROOT,
        OTHER;

    }
}

