/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.nuxeo.onedrive.client.AbstractResponse;
import org.nuxeo.onedrive.client.OneDriveAPIException;

public class OneDriveJsonResponse
extends AbstractResponse<JsonObject> {
    private JsonObject json;

    public OneDriveJsonResponse(HttpURLConnection connection) throws OneDriveAPIException {
        super(connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonObject getContent() throws OneDriveAPIException {
        if (this.json != null) {
            return this.json;
        }
        try (InputStream body = this.getBody();){
            String jsonString = OneDriveJsonResponse.readStream(body);
            JsonObject jsonObject = this.json = JsonObject.readFrom((String)jsonString);
            return jsonObject;
        }
        catch (IOException e) {
            throw new OneDriveAPIException("Couldn't read the stream from OneDrive API.", e);
        }
    }
}

