/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.DbxApiException;
import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxWrappedException;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.async.LaunchEmptyResult;
import com.dropbox.core.v2.async.PollArg;
import com.dropbox.core.v2.async.PollError;
import com.dropbox.core.v2.async.PollErrorException;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.CopyBatchBuilder;
import com.dropbox.core.v2.files.CopyBuilder;
import com.dropbox.core.v2.files.CreateFolderArg;
import com.dropbox.core.v2.files.CreateFolderError;
import com.dropbox.core.v2.files.CreateFolderErrorException;
import com.dropbox.core.v2.files.DeleteArg;
import com.dropbox.core.v2.files.DeleteBatchArg;
import com.dropbox.core.v2.files.DeleteBatchJobStatus;
import com.dropbox.core.v2.files.DeleteError;
import com.dropbox.core.v2.files.DeleteErrorException;
import com.dropbox.core.v2.files.DownloadArg;
import com.dropbox.core.v2.files.DownloadBuilder;
import com.dropbox.core.v2.files.DownloadError;
import com.dropbox.core.v2.files.DownloadErrorException;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.GetCopyReferenceArg;
import com.dropbox.core.v2.files.GetCopyReferenceError;
import com.dropbox.core.v2.files.GetCopyReferenceErrorException;
import com.dropbox.core.v2.files.GetCopyReferenceResult;
import com.dropbox.core.v2.files.GetMetadataArg;
import com.dropbox.core.v2.files.GetMetadataBuilder;
import com.dropbox.core.v2.files.GetMetadataError;
import com.dropbox.core.v2.files.GetMetadataErrorException;
import com.dropbox.core.v2.files.GetPreviewBuilder;
import com.dropbox.core.v2.files.GetTemporaryLinkArg;
import com.dropbox.core.v2.files.GetTemporaryLinkError;
import com.dropbox.core.v2.files.GetTemporaryLinkErrorException;
import com.dropbox.core.v2.files.GetTemporaryLinkResult;
import com.dropbox.core.v2.files.GetThumbnailBuilder;
import com.dropbox.core.v2.files.ListFolderArg;
import com.dropbox.core.v2.files.ListFolderBuilder;
import com.dropbox.core.v2.files.ListFolderContinueArg;
import com.dropbox.core.v2.files.ListFolderContinueError;
import com.dropbox.core.v2.files.ListFolderContinueErrorException;
import com.dropbox.core.v2.files.ListFolderError;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.ListFolderGetLatestCursorBuilder;
import com.dropbox.core.v2.files.ListFolderGetLatestCursorResult;
import com.dropbox.core.v2.files.ListFolderLongpollArg;
import com.dropbox.core.v2.files.ListFolderLongpollError;
import com.dropbox.core.v2.files.ListFolderLongpollErrorException;
import com.dropbox.core.v2.files.ListFolderLongpollResult;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.ListRevisionsArg;
import com.dropbox.core.v2.files.ListRevisionsError;
import com.dropbox.core.v2.files.ListRevisionsErrorException;
import com.dropbox.core.v2.files.ListRevisionsResult;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.MoveBatchBuilder;
import com.dropbox.core.v2.files.MoveBuilder;
import com.dropbox.core.v2.files.PreviewArg;
import com.dropbox.core.v2.files.PreviewError;
import com.dropbox.core.v2.files.PreviewErrorException;
import com.dropbox.core.v2.files.RelocationArg;
import com.dropbox.core.v2.files.RelocationBatchArg;
import com.dropbox.core.v2.files.RelocationBatchJobStatus;
import com.dropbox.core.v2.files.RelocationError;
import com.dropbox.core.v2.files.RelocationErrorException;
import com.dropbox.core.v2.files.RelocationPath;
import com.dropbox.core.v2.files.RestoreArg;
import com.dropbox.core.v2.files.RestoreError;
import com.dropbox.core.v2.files.RestoreErrorException;
import com.dropbox.core.v2.files.SaveCopyReferenceArg;
import com.dropbox.core.v2.files.SaveCopyReferenceError;
import com.dropbox.core.v2.files.SaveCopyReferenceErrorException;
import com.dropbox.core.v2.files.SaveCopyReferenceResult;
import com.dropbox.core.v2.files.SaveUrlArg;
import com.dropbox.core.v2.files.SaveUrlError;
import com.dropbox.core.v2.files.SaveUrlErrorException;
import com.dropbox.core.v2.files.SaveUrlJobStatus;
import com.dropbox.core.v2.files.SaveUrlResult;
import com.dropbox.core.v2.files.SearchArg;
import com.dropbox.core.v2.files.SearchBuilder;
import com.dropbox.core.v2.files.SearchError;
import com.dropbox.core.v2.files.SearchErrorException;
import com.dropbox.core.v2.files.SearchResult;
import com.dropbox.core.v2.files.ThumbnailArg;
import com.dropbox.core.v2.files.ThumbnailError;
import com.dropbox.core.v2.files.ThumbnailErrorException;
import com.dropbox.core.v2.files.UploadBuilder;
import com.dropbox.core.v2.files.UploadSessionAppendArg;
import com.dropbox.core.v2.files.UploadSessionAppendUploader;
import com.dropbox.core.v2.files.UploadSessionAppendV2Uploader;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.dropbox.core.v2.files.UploadSessionFinishArg;
import com.dropbox.core.v2.files.UploadSessionFinishBatchArg;
import com.dropbox.core.v2.files.UploadSessionFinishBatchJobStatus;
import com.dropbox.core.v2.files.UploadSessionFinishUploader;
import com.dropbox.core.v2.files.UploadSessionStartArg;
import com.dropbox.core.v2.files.UploadSessionStartUploader;
import com.dropbox.core.v2.files.UploadUploader;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class DbxUserFilesRequests {
    private final DbxRawClientV2 client;

    public DbxUserFilesRequests(DbxRawClientV2 client) {
        this.client = client;
    }

    Metadata copy(RelocationArg arg) throws RelocationErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/copy", arg, false, RelocationArg.Serializer.INSTANCE, Metadata.Serializer.INSTANCE, RelocationError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new RelocationErrorException("2/files/copy", ex.getRequestId(), ex.getUserMessage(), (RelocationError)ex.getErrorValue());
        }
    }

    public Metadata copy(String fromPath, String toPath) throws RelocationErrorException, DbxException {
        RelocationArg _arg = new RelocationArg(fromPath, toPath);
        return this.copy(_arg);
    }

    public CopyBuilder copyBuilder(String fromPath, String toPath) {
        RelocationArg.Builder argBuilder_ = RelocationArg.newBuilder(fromPath, toPath);
        return new CopyBuilder(this, argBuilder_);
    }

    LaunchEmptyResult copyBatch(RelocationBatchArg arg) throws DbxApiException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/copy_batch", arg, false, RelocationBatchArg.Serializer.INSTANCE, LaunchEmptyResult.Serializer.INSTANCE, StoneSerializers.void_());
        }
        catch (DbxWrappedException ex) {
            throw new DbxApiException(ex.getRequestId(), ex.getUserMessage(), "Unexpected error response for \"copy_batch\":" + ex.getErrorValue());
        }
    }

    public LaunchEmptyResult copyBatch(List<RelocationPath> entries) throws DbxApiException, DbxException {
        RelocationBatchArg _arg = new RelocationBatchArg(entries);
        return this.copyBatch(_arg);
    }

    public CopyBatchBuilder copyBatchBuilder(List<RelocationPath> entries) {
        RelocationBatchArg.Builder argBuilder_ = RelocationBatchArg.newBuilder(entries);
        return new CopyBatchBuilder(this, argBuilder_);
    }

    RelocationBatchJobStatus copyBatchCheck(PollArg arg) throws PollErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/copy_batch/check", arg, false, PollArg.Serializer.INSTANCE, RelocationBatchJobStatus.Serializer.INSTANCE, PollError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new PollErrorException("2/files/copy_batch/check", ex.getRequestId(), ex.getUserMessage(), (PollError)((Object)ex.getErrorValue()));
        }
    }

    public RelocationBatchJobStatus copyBatchCheck(String asyncJobId) throws PollErrorException, DbxException {
        PollArg _arg = new PollArg(asyncJobId);
        return this.copyBatchCheck(_arg);
    }

    GetCopyReferenceResult copyReferenceGet(GetCopyReferenceArg arg) throws GetCopyReferenceErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/copy_reference/get", arg, false, GetCopyReferenceArg.Serializer.INSTANCE, GetCopyReferenceResult.Serializer.INSTANCE, GetCopyReferenceError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new GetCopyReferenceErrorException("2/files/copy_reference/get", ex.getRequestId(), ex.getUserMessage(), (GetCopyReferenceError)ex.getErrorValue());
        }
    }

    public GetCopyReferenceResult copyReferenceGet(String path) throws GetCopyReferenceErrorException, DbxException {
        GetCopyReferenceArg _arg = new GetCopyReferenceArg(path);
        return this.copyReferenceGet(_arg);
    }

    SaveCopyReferenceResult copyReferenceSave(SaveCopyReferenceArg arg) throws SaveCopyReferenceErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/copy_reference/save", arg, false, SaveCopyReferenceArg.Serializer.INSTANCE, SaveCopyReferenceResult.Serializer.INSTANCE, SaveCopyReferenceError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new SaveCopyReferenceErrorException("2/files/copy_reference/save", ex.getRequestId(), ex.getUserMessage(), (SaveCopyReferenceError)ex.getErrorValue());
        }
    }

    public SaveCopyReferenceResult copyReferenceSave(String copyReference, String path) throws SaveCopyReferenceErrorException, DbxException {
        SaveCopyReferenceArg _arg = new SaveCopyReferenceArg(copyReference, path);
        return this.copyReferenceSave(_arg);
    }

    FolderMetadata createFolder(CreateFolderArg arg) throws CreateFolderErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/create_folder", arg, false, CreateFolderArg.Serializer.INSTANCE, FolderMetadata.Serializer.INSTANCE, CreateFolderError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new CreateFolderErrorException("2/files/create_folder", ex.getRequestId(), ex.getUserMessage(), (CreateFolderError)ex.getErrorValue());
        }
    }

    public FolderMetadata createFolder(String path) throws CreateFolderErrorException, DbxException {
        CreateFolderArg _arg = new CreateFolderArg(path);
        return this.createFolder(_arg);
    }

    public FolderMetadata createFolder(String path, boolean autorename) throws CreateFolderErrorException, DbxException {
        CreateFolderArg _arg = new CreateFolderArg(path, autorename);
        return this.createFolder(_arg);
    }

    Metadata delete(DeleteArg arg) throws DeleteErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/delete", arg, false, DeleteArg.Serializer.INSTANCE, Metadata.Serializer.INSTANCE, DeleteError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DeleteErrorException("2/files/delete", ex.getRequestId(), ex.getUserMessage(), (DeleteError)ex.getErrorValue());
        }
    }

    public Metadata delete(String path) throws DeleteErrorException, DbxException {
        DeleteArg _arg = new DeleteArg(path);
        return this.delete(_arg);
    }

    LaunchEmptyResult deleteBatch(DeleteBatchArg arg) throws DbxApiException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/delete_batch", arg, false, DeleteBatchArg.Serializer.INSTANCE, LaunchEmptyResult.Serializer.INSTANCE, StoneSerializers.void_());
        }
        catch (DbxWrappedException ex) {
            throw new DbxApiException(ex.getRequestId(), ex.getUserMessage(), "Unexpected error response for \"delete_batch\":" + ex.getErrorValue());
        }
    }

    public LaunchEmptyResult deleteBatch(List<DeleteArg> entries) throws DbxApiException, DbxException {
        DeleteBatchArg _arg = new DeleteBatchArg(entries);
        return this.deleteBatch(_arg);
    }

    DeleteBatchJobStatus deleteBatchCheck(PollArg arg) throws PollErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/delete_batch/check", arg, false, PollArg.Serializer.INSTANCE, DeleteBatchJobStatus.Serializer.INSTANCE, PollError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new PollErrorException("2/files/delete_batch/check", ex.getRequestId(), ex.getUserMessage(), (PollError)((Object)ex.getErrorValue()));
        }
    }

    public DeleteBatchJobStatus deleteBatchCheck(String asyncJobId) throws PollErrorException, DbxException {
        PollArg _arg = new PollArg(asyncJobId);
        return this.deleteBatchCheck(_arg);
    }

    DbxDownloader<FileMetadata> download(DownloadArg arg, List<HttpRequestor.Header> _headers) throws DownloadErrorException, DbxException {
        try {
            return this.client.downloadStyle(this.client.getHost().getContent(), "2/files/download", arg, false, _headers, DownloadArg.Serializer.INSTANCE, FileMetadata.Serializer.INSTANCE, DownloadError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DownloadErrorException("2/files/download", ex.getRequestId(), ex.getUserMessage(), (DownloadError)ex.getErrorValue());
        }
    }

    public DbxDownloader<FileMetadata> download(String path) throws DownloadErrorException, DbxException {
        DownloadArg _arg = new DownloadArg(path);
        return this.download(_arg, Collections.<HttpRequestor.Header>emptyList());
    }

    public DbxDownloader<FileMetadata> download(String path, String rev) throws DownloadErrorException, DbxException {
        if (rev != null) {
            if (rev.length() < 9) {
                throw new IllegalArgumentException("String 'rev' is shorter than 9");
            }
            if (!Pattern.matches("[0-9a-f]+", rev)) {
                throw new IllegalArgumentException("String 'rev' does not match pattern");
            }
        }
        DownloadArg _arg = new DownloadArg(path, rev);
        return this.download(_arg, Collections.<HttpRequestor.Header>emptyList());
    }

    public DownloadBuilder downloadBuilder(String path) {
        return new DownloadBuilder(this, path);
    }

    Metadata getMetadata(GetMetadataArg arg) throws GetMetadataErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/get_metadata", arg, false, GetMetadataArg.Serializer.INSTANCE, Metadata.Serializer.INSTANCE, GetMetadataError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new GetMetadataErrorException("2/files/get_metadata", ex.getRequestId(), ex.getUserMessage(), (GetMetadataError)ex.getErrorValue());
        }
    }

    public Metadata getMetadata(String path) throws GetMetadataErrorException, DbxException {
        GetMetadataArg _arg = new GetMetadataArg(path);
        return this.getMetadata(_arg);
    }

    public GetMetadataBuilder getMetadataBuilder(String path) {
        GetMetadataArg.Builder argBuilder_ = GetMetadataArg.newBuilder(path);
        return new GetMetadataBuilder(this, argBuilder_);
    }

    DbxDownloader<FileMetadata> getPreview(PreviewArg arg, List<HttpRequestor.Header> _headers) throws PreviewErrorException, DbxException {
        try {
            return this.client.downloadStyle(this.client.getHost().getContent(), "2/files/get_preview", arg, false, _headers, PreviewArg.Serializer.INSTANCE, FileMetadata.Serializer.INSTANCE, PreviewError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new PreviewErrorException("2/files/get_preview", ex.getRequestId(), ex.getUserMessage(), (PreviewError)ex.getErrorValue());
        }
    }

    public DbxDownloader<FileMetadata> getPreview(String path) throws PreviewErrorException, DbxException {
        PreviewArg _arg = new PreviewArg(path);
        return this.getPreview(_arg, Collections.<HttpRequestor.Header>emptyList());
    }

    public DbxDownloader<FileMetadata> getPreview(String path, String rev) throws PreviewErrorException, DbxException {
        if (rev != null) {
            if (rev.length() < 9) {
                throw new IllegalArgumentException("String 'rev' is shorter than 9");
            }
            if (!Pattern.matches("[0-9a-f]+", rev)) {
                throw new IllegalArgumentException("String 'rev' does not match pattern");
            }
        }
        PreviewArg _arg = new PreviewArg(path, rev);
        return this.getPreview(_arg, Collections.<HttpRequestor.Header>emptyList());
    }

    public GetPreviewBuilder getPreviewBuilder(String path) {
        return new GetPreviewBuilder(this, path);
    }

    GetTemporaryLinkResult getTemporaryLink(GetTemporaryLinkArg arg) throws GetTemporaryLinkErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/get_temporary_link", arg, false, GetTemporaryLinkArg.Serializer.INSTANCE, GetTemporaryLinkResult.Serializer.INSTANCE, GetTemporaryLinkError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new GetTemporaryLinkErrorException("2/files/get_temporary_link", ex.getRequestId(), ex.getUserMessage(), (GetTemporaryLinkError)ex.getErrorValue());
        }
    }

    public GetTemporaryLinkResult getTemporaryLink(String path) throws GetTemporaryLinkErrorException, DbxException {
        GetTemporaryLinkArg _arg = new GetTemporaryLinkArg(path);
        return this.getTemporaryLink(_arg);
    }

    DbxDownloader<FileMetadata> getThumbnail(ThumbnailArg arg, List<HttpRequestor.Header> _headers) throws ThumbnailErrorException, DbxException {
        try {
            return this.client.downloadStyle(this.client.getHost().getContent(), "2/files/get_thumbnail", arg, false, _headers, ThumbnailArg.Serializer.INSTANCE, FileMetadata.Serializer.INSTANCE, ThumbnailError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ThumbnailErrorException("2/files/get_thumbnail", ex.getRequestId(), ex.getUserMessage(), (ThumbnailError)ex.getErrorValue());
        }
    }

    public DbxDownloader<FileMetadata> getThumbnail(String path) throws ThumbnailErrorException, DbxException {
        ThumbnailArg _arg = new ThumbnailArg(path);
        return this.getThumbnail(_arg, Collections.<HttpRequestor.Header>emptyList());
    }

    public GetThumbnailBuilder getThumbnailBuilder(String path) {
        ThumbnailArg.Builder argBuilder_ = ThumbnailArg.newBuilder(path);
        return new GetThumbnailBuilder(this, argBuilder_);
    }

    ListFolderResult listFolder(ListFolderArg arg) throws ListFolderErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/list_folder", arg, false, ListFolderArg.Serializer.INSTANCE, ListFolderResult.Serializer.INSTANCE, ListFolderError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ListFolderErrorException("2/files/list_folder", ex.getRequestId(), ex.getUserMessage(), (ListFolderError)ex.getErrorValue());
        }
    }

    public ListFolderResult listFolder(String path) throws ListFolderErrorException, DbxException {
        ListFolderArg _arg = new ListFolderArg(path);
        return this.listFolder(_arg);
    }

    public ListFolderBuilder listFolderBuilder(String path) {
        ListFolderArg.Builder argBuilder_ = ListFolderArg.newBuilder(path);
        return new ListFolderBuilder(this, argBuilder_);
    }

    ListFolderResult listFolderContinue(ListFolderContinueArg arg) throws ListFolderContinueErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/list_folder/continue", arg, false, ListFolderContinueArg.Serializer.INSTANCE, ListFolderResult.Serializer.INSTANCE, ListFolderContinueError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ListFolderContinueErrorException("2/files/list_folder/continue", ex.getRequestId(), ex.getUserMessage(), (ListFolderContinueError)ex.getErrorValue());
        }
    }

    public ListFolderResult listFolderContinue(String cursor) throws ListFolderContinueErrorException, DbxException {
        ListFolderContinueArg _arg = new ListFolderContinueArg(cursor);
        return this.listFolderContinue(_arg);
    }

    ListFolderGetLatestCursorResult listFolderGetLatestCursor(ListFolderArg arg) throws ListFolderErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/list_folder/get_latest_cursor", arg, false, ListFolderArg.Serializer.INSTANCE, ListFolderGetLatestCursorResult.Serializer.INSTANCE, ListFolderError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ListFolderErrorException("2/files/list_folder/get_latest_cursor", ex.getRequestId(), ex.getUserMessage(), (ListFolderError)ex.getErrorValue());
        }
    }

    public ListFolderGetLatestCursorResult listFolderGetLatestCursor(String path) throws ListFolderErrorException, DbxException {
        ListFolderArg _arg = new ListFolderArg(path);
        return this.listFolderGetLatestCursor(_arg);
    }

    public ListFolderGetLatestCursorBuilder listFolderGetLatestCursorBuilder(String path) {
        ListFolderArg.Builder argBuilder_ = ListFolderArg.newBuilder(path);
        return new ListFolderGetLatestCursorBuilder(this, argBuilder_);
    }

    ListFolderLongpollResult listFolderLongpoll(ListFolderLongpollArg arg) throws ListFolderLongpollErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getNotify(), "2/files/list_folder/longpoll", arg, true, ListFolderLongpollArg.Serializer.INSTANCE, ListFolderLongpollResult.Serializer.INSTANCE, ListFolderLongpollError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ListFolderLongpollErrorException("2/files/list_folder/longpoll", ex.getRequestId(), ex.getUserMessage(), (ListFolderLongpollError)((Object)ex.getErrorValue()));
        }
    }

    public ListFolderLongpollResult listFolderLongpoll(String cursor) throws ListFolderLongpollErrorException, DbxException {
        ListFolderLongpollArg _arg = new ListFolderLongpollArg(cursor);
        return this.listFolderLongpoll(_arg);
    }

    public ListFolderLongpollResult listFolderLongpoll(String cursor, long timeout) throws ListFolderLongpollErrorException, DbxException {
        if (timeout < 30L) {
            throw new IllegalArgumentException("Number 'timeout' is smaller than 30L");
        }
        if (timeout > 480L) {
            throw new IllegalArgumentException("Number 'timeout' is larger than 480L");
        }
        ListFolderLongpollArg _arg = new ListFolderLongpollArg(cursor, timeout);
        return this.listFolderLongpoll(_arg);
    }

    ListRevisionsResult listRevisions(ListRevisionsArg arg) throws ListRevisionsErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/list_revisions", arg, false, ListRevisionsArg.Serializer.INSTANCE, ListRevisionsResult.Serializer.INSTANCE, ListRevisionsError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ListRevisionsErrorException("2/files/list_revisions", ex.getRequestId(), ex.getUserMessage(), (ListRevisionsError)ex.getErrorValue());
        }
    }

    public ListRevisionsResult listRevisions(String path) throws ListRevisionsErrorException, DbxException {
        ListRevisionsArg _arg = new ListRevisionsArg(path);
        return this.listRevisions(_arg);
    }

    public ListRevisionsResult listRevisions(String path, long limit) throws ListRevisionsErrorException, DbxException {
        if (limit < 1L) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
        }
        if (limit > 100L) {
            throw new IllegalArgumentException("Number 'limit' is larger than 100L");
        }
        ListRevisionsArg _arg = new ListRevisionsArg(path, limit);
        return this.listRevisions(_arg);
    }

    Metadata move(RelocationArg arg) throws RelocationErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/move", arg, false, RelocationArg.Serializer.INSTANCE, Metadata.Serializer.INSTANCE, RelocationError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new RelocationErrorException("2/files/move", ex.getRequestId(), ex.getUserMessage(), (RelocationError)ex.getErrorValue());
        }
    }

    public Metadata move(String fromPath, String toPath) throws RelocationErrorException, DbxException {
        RelocationArg _arg = new RelocationArg(fromPath, toPath);
        return this.move(_arg);
    }

    public MoveBuilder moveBuilder(String fromPath, String toPath) {
        RelocationArg.Builder argBuilder_ = RelocationArg.newBuilder(fromPath, toPath);
        return new MoveBuilder(this, argBuilder_);
    }

    LaunchEmptyResult moveBatch(RelocationBatchArg arg) throws DbxApiException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/move_batch", arg, false, RelocationBatchArg.Serializer.INSTANCE, LaunchEmptyResult.Serializer.INSTANCE, StoneSerializers.void_());
        }
        catch (DbxWrappedException ex) {
            throw new DbxApiException(ex.getRequestId(), ex.getUserMessage(), "Unexpected error response for \"move_batch\":" + ex.getErrorValue());
        }
    }

    public LaunchEmptyResult moveBatch(List<RelocationPath> entries) throws DbxApiException, DbxException {
        RelocationBatchArg _arg = new RelocationBatchArg(entries);
        return this.moveBatch(_arg);
    }

    public MoveBatchBuilder moveBatchBuilder(List<RelocationPath> entries) {
        RelocationBatchArg.Builder argBuilder_ = RelocationBatchArg.newBuilder(entries);
        return new MoveBatchBuilder(this, argBuilder_);
    }

    RelocationBatchJobStatus moveBatchCheck(PollArg arg) throws PollErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/move_batch/check", arg, false, PollArg.Serializer.INSTANCE, RelocationBatchJobStatus.Serializer.INSTANCE, PollError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new PollErrorException("2/files/move_batch/check", ex.getRequestId(), ex.getUserMessage(), (PollError)((Object)ex.getErrorValue()));
        }
    }

    public RelocationBatchJobStatus moveBatchCheck(String asyncJobId) throws PollErrorException, DbxException {
        PollArg _arg = new PollArg(asyncJobId);
        return this.moveBatchCheck(_arg);
    }

    void permanentlyDelete(DeleteArg arg) throws DeleteErrorException, DbxException {
        try {
            this.client.rpcStyle(this.client.getHost().getApi(), "2/files/permanently_delete", arg, false, DeleteArg.Serializer.INSTANCE, StoneSerializers.void_(), DeleteError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new DeleteErrorException("2/files/permanently_delete", ex.getRequestId(), ex.getUserMessage(), (DeleteError)ex.getErrorValue());
        }
    }

    public void permanentlyDelete(String path) throws DeleteErrorException, DbxException {
        DeleteArg _arg = new DeleteArg(path);
        this.permanentlyDelete(_arg);
    }

    FileMetadata restore(RestoreArg arg) throws RestoreErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/restore", arg, false, RestoreArg.Serializer.INSTANCE, FileMetadata.Serializer.INSTANCE, RestoreError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new RestoreErrorException("2/files/restore", ex.getRequestId(), ex.getUserMessage(), (RestoreError)ex.getErrorValue());
        }
    }

    public FileMetadata restore(String path, String rev) throws RestoreErrorException, DbxException {
        RestoreArg _arg = new RestoreArg(path, rev);
        return this.restore(_arg);
    }

    SaveUrlResult saveUrl(SaveUrlArg arg) throws SaveUrlErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/save_url", arg, false, SaveUrlArg.Serializer.INSTANCE, SaveUrlResult.Serializer.INSTANCE, SaveUrlError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new SaveUrlErrorException("2/files/save_url", ex.getRequestId(), ex.getUserMessage(), (SaveUrlError)ex.getErrorValue());
        }
    }

    public SaveUrlResult saveUrl(String path, String url) throws SaveUrlErrorException, DbxException {
        SaveUrlArg _arg = new SaveUrlArg(path, url);
        return this.saveUrl(_arg);
    }

    SaveUrlJobStatus saveUrlCheckJobStatus(PollArg arg) throws PollErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/save_url/check_job_status", arg, false, PollArg.Serializer.INSTANCE, SaveUrlJobStatus.Serializer.INSTANCE, PollError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new PollErrorException("2/files/save_url/check_job_status", ex.getRequestId(), ex.getUserMessage(), (PollError)((Object)ex.getErrorValue()));
        }
    }

    public SaveUrlJobStatus saveUrlCheckJobStatus(String asyncJobId) throws PollErrorException, DbxException {
        PollArg _arg = new PollArg(asyncJobId);
        return this.saveUrlCheckJobStatus(_arg);
    }

    SearchResult search(SearchArg arg) throws SearchErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/search", arg, false, SearchArg.Serializer.INSTANCE, SearchResult.Serializer.INSTANCE, SearchError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new SearchErrorException("2/files/search", ex.getRequestId(), ex.getUserMessage(), (SearchError)ex.getErrorValue());
        }
    }

    public SearchResult search(String path, String query) throws SearchErrorException, DbxException {
        SearchArg _arg = new SearchArg(path, query);
        return this.search(_arg);
    }

    public SearchBuilder searchBuilder(String path, String query) {
        SearchArg.Builder argBuilder_ = SearchArg.newBuilder(path, query);
        return new SearchBuilder(this, argBuilder_);
    }

    UploadUploader upload(CommitInfo arg) throws DbxException {
        HttpRequestor.Uploader _uploader = this.client.uploadStyle(this.client.getHost().getContent(), "2/files/upload", arg, false, CommitInfo.Serializer.INSTANCE);
        return new UploadUploader(_uploader);
    }

    public UploadUploader upload(String path) throws DbxException {
        CommitInfo _arg = new CommitInfo(path);
        return this.upload(_arg);
    }

    public UploadBuilder uploadBuilder(String path) {
        CommitInfo.Builder argBuilder_ = CommitInfo.newBuilder(path);
        return new UploadBuilder(this, argBuilder_);
    }

    UploadSessionAppendUploader uploadSessionAppend(UploadSessionCursor arg) throws DbxException {
        HttpRequestor.Uploader _uploader = this.client.uploadStyle(this.client.getHost().getContent(), "2/files/upload_session/append", arg, false, UploadSessionCursor.Serializer.INSTANCE);
        return new UploadSessionAppendUploader(_uploader);
    }

    @Deprecated
    public UploadSessionAppendUploader uploadSessionAppend(String sessionId, long offset) throws DbxException {
        UploadSessionCursor _arg = new UploadSessionCursor(sessionId, offset);
        return this.uploadSessionAppend(_arg);
    }

    UploadSessionAppendV2Uploader uploadSessionAppendV2(UploadSessionAppendArg arg) throws DbxException {
        HttpRequestor.Uploader _uploader = this.client.uploadStyle(this.client.getHost().getContent(), "2/files/upload_session/append_v2", arg, false, UploadSessionAppendArg.Serializer.INSTANCE);
        return new UploadSessionAppendV2Uploader(_uploader);
    }

    public UploadSessionAppendV2Uploader uploadSessionAppendV2(UploadSessionCursor cursor) throws DbxException {
        UploadSessionAppendArg _arg = new UploadSessionAppendArg(cursor);
        return this.uploadSessionAppendV2(_arg);
    }

    public UploadSessionAppendV2Uploader uploadSessionAppendV2(UploadSessionCursor cursor, boolean close) throws DbxException {
        UploadSessionAppendArg _arg = new UploadSessionAppendArg(cursor, close);
        return this.uploadSessionAppendV2(_arg);
    }

    UploadSessionFinishUploader uploadSessionFinish(UploadSessionFinishArg arg) throws DbxException {
        HttpRequestor.Uploader _uploader = this.client.uploadStyle(this.client.getHost().getContent(), "2/files/upload_session/finish", arg, false, UploadSessionFinishArg.Serializer.INSTANCE);
        return new UploadSessionFinishUploader(_uploader);
    }

    public UploadSessionFinishUploader uploadSessionFinish(UploadSessionCursor cursor, CommitInfo commit) throws DbxException {
        UploadSessionFinishArg _arg = new UploadSessionFinishArg(cursor, commit);
        return this.uploadSessionFinish(_arg);
    }

    LaunchEmptyResult uploadSessionFinishBatch(UploadSessionFinishBatchArg arg) throws DbxApiException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/upload_session/finish_batch", arg, false, UploadSessionFinishBatchArg.Serializer.INSTANCE, LaunchEmptyResult.Serializer.INSTANCE, StoneSerializers.void_());
        }
        catch (DbxWrappedException ex) {
            throw new DbxApiException(ex.getRequestId(), ex.getUserMessage(), "Unexpected error response for \"upload_session/finish_batch\":" + ex.getErrorValue());
        }
    }

    public LaunchEmptyResult uploadSessionFinishBatch(List<UploadSessionFinishArg> entries) throws DbxApiException, DbxException {
        UploadSessionFinishBatchArg _arg = new UploadSessionFinishBatchArg(entries);
        return this.uploadSessionFinishBatch(_arg);
    }

    UploadSessionFinishBatchJobStatus uploadSessionFinishBatchCheck(PollArg arg) throws PollErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/upload_session/finish_batch/check", arg, false, PollArg.Serializer.INSTANCE, UploadSessionFinishBatchJobStatus.Serializer.INSTANCE, PollError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new PollErrorException("2/files/upload_session/finish_batch/check", ex.getRequestId(), ex.getUserMessage(), (PollError)((Object)ex.getErrorValue()));
        }
    }

    public UploadSessionFinishBatchJobStatus uploadSessionFinishBatchCheck(String asyncJobId) throws PollErrorException, DbxException {
        PollArg _arg = new PollArg(asyncJobId);
        return this.uploadSessionFinishBatchCheck(_arg);
    }

    UploadSessionStartUploader uploadSessionStart(UploadSessionStartArg arg) throws DbxException {
        HttpRequestor.Uploader _uploader = this.client.uploadStyle(this.client.getHost().getContent(), "2/files/upload_session/start", arg, false, UploadSessionStartArg.Serializer.INSTANCE);
        return new UploadSessionStartUploader(_uploader);
    }

    public UploadSessionStartUploader uploadSessionStart() throws DbxException {
        UploadSessionStartArg _arg = new UploadSessionStartArg();
        return this.uploadSessionStart(_arg);
    }

    public UploadSessionStartUploader uploadSessionStart(boolean close) throws DbxException {
        UploadSessionStartArg _arg = new UploadSessionStartArg(close);
        return this.uploadSessionStart(_arg);
    }
}

