/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.core;

import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.blob.AbstractBlobProvider;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.DocumentBlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.liveconnect.core.CredentialFactory;
import org.nuxeo.ecm.liveconnect.core.ErrorLiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.JSONLiveConnectBlobDecoder;
import org.nuxeo.ecm.liveconnect.core.LiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.core.OAuth2CredentialFactory;
import org.nuxeo.ecm.liveconnect.update.BatchUpdateBlobProvider;
import org.nuxeo.ecm.liveconnect.update.worker.BlobProviderDocumentsUpdateWork;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractLiveConnectBlobProvider<O extends OAuth2ServiceProvider>
extends AbstractBlobProvider
implements LiveConnectBlobProvider<O>,
BatchUpdateBlobProvider,
DocumentBlobProvider {
    private static final Log log = LogFactory.getLog(AbstractLiveConnectBlobProvider.class);
    private static final String FILE_CACHE_PREFIX = "liveconnect_file_";
    private static final char BLOB_KEY_SEPARATOR = ':';
    private Cache cache;

    public void close() {
    }

    public Blob readBlob(BlobInfo blobInfo) throws IOException {
        return this.toBlob(this.toFileInfo(blobInfo.key));
    }

    public String writeBlob(Blob blob) throws IOException {
        throw new UnsupportedOperationException("Writing a blob to live connect service is not supported");
    }

    public boolean performsExternalAccessControl(BlobInfo blobInfo) {
        return true;
    }

    public boolean isVersion(ManagedBlob blob) {
        return this.toFileInfo(blob).getRevisionId().isPresent();
    }

    @Override
    public List<DocumentModel> checkChangesAndUpdateBlob(List<DocumentModel> docs) {
        ArrayList<DocumentModel> changedDocuments = new ArrayList<DocumentModel>();
        for (DocumentModel doc : docs) {
            SimpleManagedBlob blob = (SimpleManagedBlob)doc.getProperty("content").getValue();
            if (blob == null || this.isVersion((ManagedBlob)blob)) continue;
            LiveConnectFileInfo fileInfo = this.toFileInfo((ManagedBlob)blob);
            try {
                LiveConnectFile file = this.retrieveFile(fileInfo);
                this.putFileInCache(file);
                if (!this.hasChanged(blob, file)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Updating blob=" + blob.key));
                }
                doc.setPropertyValue("content", (Serializable)this.toBlob(file));
                changedDocuments.add(doc);
            }
            catch (IOException e) {
                log.error((Object)("Could not update document=" + fileInfo), (Throwable)e);
            }
        }
        return changedDocuments;
    }

    @Override
    public void processDocumentsUpdate() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        block9: for (String repositoryName : repositoryManager.getRepositoryNames()) {
            CloseableCoreSession session = CoreInstance.openCoreSessionSystem((String)repositoryName);
            Throwable throwable = null;
            try {
                List nextDocumentsToBeUpdated;
                long offset = 0L;
                PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
                HashMap<String, Serializable> props = new HashMap<String, Serializable>();
                props.put("coreSession", (Serializable)session);
                PageProvider pp = ppService.getPageProvider(this.getPageProviderNameForUpdate(), null, null, null, props, new Object[0]);
                long maxResult = pp.getPageSize();
                do {
                    pp.setCurrentPageOffset(offset);
                    pp.refresh();
                    nextDocumentsToBeUpdated = pp.getCurrentPage();
                    if (nextDocumentsToBeUpdated.isEmpty()) continue block9;
                    List docIds = nextDocumentsToBeUpdated.stream().map(DocumentModel::getId).collect(Collectors.toList());
                    BlobProviderDocumentsUpdateWork work = new BlobProviderDocumentsUpdateWork(this.buildWorkId(repositoryName, offset), this.blobProviderId);
                    work.setDocuments(repositoryName, docIds);
                    workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
                    offset += maxResult;
                } while ((long)nextDocumentsToBeUpdated.size() == maxResult);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session == null) continue;
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                session.close();
            }
        }
    }

    private String buildWorkId(String repositoryName, long offset) {
        return this.blobProviderId + ':' + repositoryName + ':' + offset;
    }

    protected boolean hasChanged(SimpleManagedBlob blob, LiveConnectFile file) {
        return StringUtils.isBlank((CharSequence)blob.getDigest()) || !blob.getDigest().equals(file.getDigest());
    }

    @Override
    public O getOAuth2Provider() {
        return (O)((OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class)).getProvider(this.blobProviderId);
    }

    public SimpleManagedBlob toBlob(LiveConnectFileInfo fileInfo) throws IOException {
        LiveConnectFile file;
        try {
            file = this.getFile(fileInfo);
        }
        catch (IOException e) {
            log.error((Object)("Failed to access file: " + fileInfo), (Throwable)e);
            file = new ErrorLiveConnectFile(fileInfo);
        }
        return this.toBlob(file);
    }

    protected SimpleManagedBlob toBlob(LiveConnectFile file) {
        BlobInfo blobInfo = new BlobInfo();
        blobInfo.key = this.buildBlobKey(file.getInfo());
        blobInfo.mimeType = file.getMimeType();
        blobInfo.encoding = file.getEncoding();
        blobInfo.filename = file.getFilename().replace('/', '-');
        blobInfo.length = file.getFileSize();
        blobInfo.digest = file.getDigest();
        return new SimpleManagedBlob(blobInfo);
    }

    protected String buildBlobKey(LiveConnectFileInfo fileInfo) {
        StringBuilder key = new StringBuilder(this.blobProviderId);
        key.append(':');
        key.append(fileInfo.getUser());
        key.append(':');
        key.append(fileInfo.getFileId());
        Optional<String> revisionId = fileInfo.getRevisionId();
        if (revisionId.isPresent()) {
            key.append(':');
            key.append(revisionId.get());
        }
        return key.toString();
    }

    protected LiveConnectFileInfo toFileInfo(ManagedBlob blob) {
        return this.toFileInfo(blob.getKey());
    }

    protected LiveConnectFileInfo toFileInfo(String key) {
        List keyParts = Splitter.on((char)':').splitToList((CharSequence)key);
        if (keyParts.size() < 3 || keyParts.size() > 4) {
            throw new IllegalArgumentException("The key doesn't have a valid format=" + key);
        }
        return new LiveConnectFileInfo((String)keyParts.get(1), (String)keyParts.get(2), keyParts.size() == 4 ? (String)keyParts.get(3) : null);
    }

    protected LiveConnectFile getFile(LiveConnectFileInfo fileInfo) throws IOException {
        LiveConnectFile file = this.getFileFromCache(fileInfo);
        if (file == null) {
            file = this.retrieveFile(fileInfo);
            this.putFileInCache(file);
        }
        return file;
    }

    private Cache getCache() {
        if (this.cache == null) {
            this.cache = ((CacheService)Framework.getService(CacheService.class)).getCache(this.getCacheName());
        }
        return this.cache;
    }

    protected Credential getCredential(LiveConnectFileInfo fileInfo) throws IOException {
        return this.getCredential(fileInfo.getUser());
    }

    protected Credential getCredential(NuxeoOAuth2Token token) throws IOException {
        return this.getCredential(token.getServiceLogin());
    }

    public final synchronized Credential getCredential(String user) throws IOException {
        try {
            return (Credential)TransactionHelper.runInNewTransaction(() -> this.retrieveAndRefreshCredential(user));
        }
        catch (UncheckedIOException uioe) {
            throw uioe.getCause();
        }
    }

    private Credential retrieveAndRefreshCredential(String user) {
        try {
            Credential credential = this.getCredentialFactory().build(user);
            if (credential == null) {
                String message = "No credentials found for user " + user + " and service " + this.blobProviderId;
                log.error((Object)message);
                throw new IOException(message);
            }
            Long expiresInSeconds = credential.getExpiresInSeconds();
            if (expiresInSeconds != null && expiresInSeconds <= 0L) {
                credential.refreshToken();
            }
            return credential;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected CredentialFactory getCredentialFactory() {
        return new OAuth2CredentialFactory((OAuth2ServiceProvider)this.getOAuth2Provider());
    }

    protected final <T extends Serializable> T getFromCache(String key) {
        return (T)this.getCache().get(key);
    }

    protected final <T extends Serializable> void putInCache(String key, T object) {
        this.getCache().put(key, object);
    }

    protected final void invalidateInCache(LiveConnectFileInfo fileInfo) {
        this.getCache().invalidate(FILE_CACHE_PREFIX + this.buildBlobKey(fileInfo));
    }

    protected final LiveConnectFile getFileFromCache(LiveConnectFileInfo fileInfo) {
        return (LiveConnectFile)this.getFromCache(FILE_CACHE_PREFIX + this.buildBlobKey(fileInfo));
    }

    protected final void putFileInCache(LiveConnectFile file) {
        this.putInCache(FILE_CACHE_PREFIX + this.buildBlobKey(file.getInfo()), file);
    }

    protected URI asURI(String link) {
        try {
            return new URI(link);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid URI: " + link), (Throwable)e);
            return null;
        }
    }

    protected abstract String getCacheName();

    protected abstract String getPageProviderNameForUpdate();

    protected abstract LiveConnectFile retrieveFile(LiveConnectFileInfo var1) throws IOException;

    static {
        ComplexTypeJSONDecoder.registerBlobDecoder((JSONBlobDecoder)new JSONLiveConnectBlobDecoder());
    }
}

