/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.users.IndividualSpaceAllocation;
import com.dropbox.core.v2.users.TeamSpaceAllocation;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class SpaceAllocation {
    public static final SpaceAllocation OTHER = new SpaceAllocation(Tag.OTHER, null, null);
    private final Tag _tag;
    private final IndividualSpaceAllocation individualValue;
    private final TeamSpaceAllocation teamValue;

    private SpaceAllocation(Tag _tag, IndividualSpaceAllocation individualValue, TeamSpaceAllocation teamValue) {
        this._tag = _tag;
        this.individualValue = individualValue;
        this.teamValue = teamValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isIndividual() {
        return this._tag == Tag.INDIVIDUAL;
    }

    public static SpaceAllocation individual(IndividualSpaceAllocation value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SpaceAllocation(Tag.INDIVIDUAL, value, null);
    }

    public IndividualSpaceAllocation getIndividualValue() {
        if (this._tag != Tag.INDIVIDUAL) {
            throw new IllegalStateException("Invalid tag: required Tag.INDIVIDUAL, but was Tag." + this._tag.name());
        }
        return this.individualValue;
    }

    public boolean isTeam() {
        return this._tag == Tag.TEAM;
    }

    public static SpaceAllocation team(TeamSpaceAllocation value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SpaceAllocation(Tag.TEAM, null, value);
    }

    public TeamSpaceAllocation getTeamValue() {
        if (this._tag != Tag.TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.TEAM, but was Tag." + this._tag.name());
        }
        return this.teamValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.individualValue, this.teamValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SpaceAllocation) {
            SpaceAllocation other = (SpaceAllocation)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case INDIVIDUAL: {
                    return this.individualValue == other.individualValue || this.individualValue.equals(other.individualValue);
                }
                case TEAM: {
                    return this.teamValue == other.teamValue || this.teamValue.equals(other.teamValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<SpaceAllocation> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SpaceAllocation value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case INDIVIDUAL: {
                    g.writeStartObject();
                    this.writeTag("individual", g);
                    IndividualSpaceAllocation.Serializer.INSTANCE.serialize(value.individualValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case TEAM: {
                    g.writeStartObject();
                    this.writeTag("team", g);
                    TeamSpaceAllocation.Serializer.INSTANCE.serialize(value.teamValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SpaceAllocation deserialize(JsonParser p) throws IOException, JsonParseException {
            SpaceAllocation value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("individual".equals(tag)) {
                IndividualSpaceAllocation fieldValue = null;
                fieldValue = IndividualSpaceAllocation.Serializer.INSTANCE.deserialize(p, true);
                value = SpaceAllocation.individual(fieldValue);
            } else if ("team".equals(tag)) {
                TeamSpaceAllocation fieldValue = null;
                fieldValue = TeamSpaceAllocation.Serializer.INSTANCE.deserialize(p, true);
                value = SpaceAllocation.team(fieldValue);
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        INDIVIDUAL,
        TEAM,
        OTHER;

    }
}

