/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class GroupMembersAddError {
    public static final GroupMembersAddError GROUP_NOT_FOUND = new GroupMembersAddError(Tag.GROUP_NOT_FOUND, null, null, null);
    public static final GroupMembersAddError OTHER = new GroupMembersAddError(Tag.OTHER, null, null, null);
    public static final GroupMembersAddError DUPLICATE_USER = new GroupMembersAddError(Tag.DUPLICATE_USER, null, null, null);
    public static final GroupMembersAddError GROUP_NOT_IN_TEAM = new GroupMembersAddError(Tag.GROUP_NOT_IN_TEAM, null, null, null);
    public static final GroupMembersAddError USER_MUST_BE_ACTIVE_TO_BE_OWNER = new GroupMembersAddError(Tag.USER_MUST_BE_ACTIVE_TO_BE_OWNER, null, null, null);
    private final Tag _tag;
    private final List<String> membersNotInTeamValue;
    private final List<String> usersNotFoundValue;
    private final List<String> userCannotBeManagerOfCompanyManagedGroupValue;

    private GroupMembersAddError(Tag _tag, List<String> membersNotInTeamValue, List<String> usersNotFoundValue, List<String> userCannotBeManagerOfCompanyManagedGroupValue) {
        this._tag = _tag;
        this.membersNotInTeamValue = membersNotInTeamValue;
        this.usersNotFoundValue = usersNotFoundValue;
        this.userCannotBeManagerOfCompanyManagedGroupValue = userCannotBeManagerOfCompanyManagedGroupValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isGroupNotFound() {
        return this._tag == Tag.GROUP_NOT_FOUND;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isDuplicateUser() {
        return this._tag == Tag.DUPLICATE_USER;
    }

    public boolean isGroupNotInTeam() {
        return this._tag == Tag.GROUP_NOT_IN_TEAM;
    }

    public boolean isMembersNotInTeam() {
        return this._tag == Tag.MEMBERS_NOT_IN_TEAM;
    }

    public static GroupMembersAddError membersNotInTeam(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupMembersAddError(Tag.MEMBERS_NOT_IN_TEAM, value, null, null);
    }

    public List<String> getMembersNotInTeamValue() {
        if (this._tag != Tag.MEMBERS_NOT_IN_TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.MEMBERS_NOT_IN_TEAM, but was Tag." + this._tag.name());
        }
        return this.membersNotInTeamValue;
    }

    public boolean isUsersNotFound() {
        return this._tag == Tag.USERS_NOT_FOUND;
    }

    public static GroupMembersAddError usersNotFound(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupMembersAddError(Tag.USERS_NOT_FOUND, null, value, null);
    }

    public List<String> getUsersNotFoundValue() {
        if (this._tag != Tag.USERS_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.USERS_NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.usersNotFoundValue;
    }

    public boolean isUserMustBeActiveToBeOwner() {
        return this._tag == Tag.USER_MUST_BE_ACTIVE_TO_BE_OWNER;
    }

    public boolean isUserCannotBeManagerOfCompanyManagedGroup() {
        return this._tag == Tag.USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP;
    }

    public static GroupMembersAddError userCannotBeManagerOfCompanyManagedGroup(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupMembersAddError(Tag.USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP, null, null, value);
    }

    public List<String> getUserCannotBeManagerOfCompanyManagedGroupValue() {
        if (this._tag != Tag.USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP, but was Tag." + this._tag.name());
        }
        return this.userCannotBeManagerOfCompanyManagedGroupValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.membersNotInTeamValue, this.usersNotFoundValue, this.userCannotBeManagerOfCompanyManagedGroupValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GroupMembersAddError) {
            GroupMembersAddError other = (GroupMembersAddError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case GROUP_NOT_FOUND: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case DUPLICATE_USER: {
                    return true;
                }
                case GROUP_NOT_IN_TEAM: {
                    return true;
                }
                case MEMBERS_NOT_IN_TEAM: {
                    return this.membersNotInTeamValue == other.membersNotInTeamValue || this.membersNotInTeamValue.equals(other.membersNotInTeamValue);
                }
                case USERS_NOT_FOUND: {
                    return this.usersNotFoundValue == other.usersNotFoundValue || this.usersNotFoundValue.equals(other.usersNotFoundValue);
                }
                case USER_MUST_BE_ACTIVE_TO_BE_OWNER: {
                    return true;
                }
                case USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP: {
                    return this.userCannotBeManagerOfCompanyManagedGroupValue == other.userCannotBeManagerOfCompanyManagedGroupValue || this.userCannotBeManagerOfCompanyManagedGroupValue.equals(other.userCannotBeManagerOfCompanyManagedGroupValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<GroupMembersAddError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupMembersAddError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case GROUP_NOT_FOUND: {
                    g.writeString("group_not_found");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case DUPLICATE_USER: {
                    g.writeString("duplicate_user");
                    break;
                }
                case GROUP_NOT_IN_TEAM: {
                    g.writeString("group_not_in_team");
                    break;
                }
                case MEMBERS_NOT_IN_TEAM: {
                    g.writeStartObject();
                    this.writeTag("members_not_in_team", g);
                    g.writeFieldName("members_not_in_team");
                    StoneSerializers.list(StoneSerializers.string()).serialize((List<String>)value.membersNotInTeamValue, g);
                    g.writeEndObject();
                    break;
                }
                case USERS_NOT_FOUND: {
                    g.writeStartObject();
                    this.writeTag("users_not_found", g);
                    g.writeFieldName("users_not_found");
                    StoneSerializers.list(StoneSerializers.string()).serialize((List<String>)value.usersNotFoundValue, g);
                    g.writeEndObject();
                    break;
                }
                case USER_MUST_BE_ACTIVE_TO_BE_OWNER: {
                    g.writeString("user_must_be_active_to_be_owner");
                    break;
                }
                case USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP: {
                    g.writeStartObject();
                    this.writeTag("user_cannot_be_manager_of_company_managed_group", g);
                    g.writeFieldName("user_cannot_be_manager_of_company_managed_group");
                    StoneSerializers.list(StoneSerializers.string()).serialize((List<String>)value.userCannotBeManagerOfCompanyManagedGroupValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public GroupMembersAddError deserialize(JsonParser p) throws IOException, JsonParseException {
            GroupMembersAddError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("group_not_found".equals(tag)) {
                value = GROUP_NOT_FOUND;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("duplicate_user".equals(tag)) {
                value = DUPLICATE_USER;
            } else if ("group_not_in_team".equals(tag)) {
                value = GROUP_NOT_IN_TEAM;
            } else if ("members_not_in_team".equals(tag)) {
                List<String> fieldValue = null;
                Serializer.expectField("members_not_in_team", p);
                fieldValue = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                value = GroupMembersAddError.membersNotInTeam(fieldValue);
            } else if ("users_not_found".equals(tag)) {
                List<String> fieldValue = null;
                Serializer.expectField("users_not_found", p);
                fieldValue = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                value = GroupMembersAddError.usersNotFound(fieldValue);
            } else if ("user_must_be_active_to_be_owner".equals(tag)) {
                value = USER_MUST_BE_ACTIVE_TO_BE_OWNER;
            } else if ("user_cannot_be_manager_of_company_managed_group".equals(tag)) {
                List<String> fieldValue = null;
                Serializer.expectField("user_cannot_be_manager_of_company_managed_group", p);
                fieldValue = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                value = GroupMembersAddError.userCannotBeManagerOfCompanyManagedGroup(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        GROUP_NOT_FOUND,
        OTHER,
        DUPLICATE_USER,
        GROUP_NOT_IN_TEAM,
        MEMBERS_NOT_IN_TEAM,
        USERS_NOT_FOUND,
        USER_MUST_BE_ACTIVE_TO_BE_OWNER,
        USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP;

    }
}

