/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.QueryStringBuilder;

class URLTemplate {
    public static final URLTemplate EMPTY_TEMPLATE = new URLTemplate("");
    private String template;

    URLTemplate(String template) {
        this.template = Objects.requireNonNull(template);
    }

    URL build(String base, Object ... values) {
        String urlString = String.format(base + this.template, values);
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new OneDriveRuntimeException("Template produced an invalid URL (maybe a bug in client).", e);
        }
    }

    URL build(String base, QueryStringBuilder query, Object ... values) {
        String urlString = String.format(base + this.template, values) + query.toString();
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new OneDriveRuntimeException("Template produced an invalid URL (maybe a bug in client).", e);
        }
    }
}

