/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum ThumbnailSize {
    W32H32,
    W64H64,
    W128H128,
    W640H480,
    W1024H768;


    static class Serializer
    extends UnionSerializer<ThumbnailSize> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ThumbnailSize value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case W32H32: {
                    g.writeString("w32h32");
                    break;
                }
                case W64H64: {
                    g.writeString("w64h64");
                    break;
                }
                case W128H128: {
                    g.writeString("w128h128");
                    break;
                }
                case W640H480: {
                    g.writeString("w640h480");
                    break;
                }
                case W1024H768: {
                    g.writeString("w1024h768");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value));
                }
            }
        }

        @Override
        public ThumbnailSize deserialize(JsonParser p) throws IOException, JsonParseException {
            ThumbnailSize value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("w32h32".equals(tag)) {
                value = W32H32;
            } else if ("w64h64".equals(tag)) {
                value = W64H64;
            } else if ("w128h128".equals(tag)) {
                value = W128H128;
            } else if ("w640h480".equals(tag)) {
                value = W640H480;
            } else if ("w1024h768".equals(tag)) {
                value = W1024H768;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

