/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.loci.ai.core.enricher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ai.enrichment.EnrichmentDescriptor;
import org.nuxeo.ai.enrichment.EnrichmentMetadata;
import org.nuxeo.ai.metadata.AIMetadata;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ai.rest.RestEnrichmentProvider;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.labs.loci.ai.core.model.LociResponse;
import org.nuxeo.runtime.api.Framework;

public class LociAiEnrichmentProvider
extends RestEnrichmentProvider {
    private static final Logger log = LogManager.getLogger(LociAiEnrichmentProvider.class);
    public static final String PARAM_API_SECRET = "apiKey";
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    public String uri;
    public String method;
    public String apiKey;

    public void init(EnrichmentDescriptor descriptor) {
        super.init(descriptor);
        this.apiKey = (String)descriptor.options.get(PARAM_API_SECRET);
        this.uri = (String)descriptor.options.get("uri");
        this.method = descriptor.options.getOrDefault("methodName", "POST");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Collection<EnrichmentMetadata> enrich(BlobTextFromDocument blobTextFromDoc) {
        RequestBuilder requestBuilder = RequestBuilder.create((String)this.method);
        requestBuilder.setUri(this.uri);
        requestBuilder.addHeader("accept", "application/json");
        requestBuilder.addHeader("x-api-key", this.apiKey);
        HttpUriRequest request = this.prepareRequest(requestBuilder, blobTextFromDoc);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            List<EnrichmentMetadata> list;
            block18: {
                int statusCode;
                CloseableHttpResponse response;
                block16: {
                    Collection<EnrichmentMetadata> collection;
                    block17: {
                        response = httpClient.execute(request);
                        try {
                            statusCode = response.getStatusLine().getStatusCode();
                            if (statusCode < 200 || statusCode >= 300) break block16;
                            collection = this.handleResponse((HttpResponse)response, blobTextFromDoc);
                            if (response == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        response.close();
                    }
                    return collection;
                }
                String error = this.getContent((HttpResponse)response);
                log.warn(String.format("Unsuccessful call to rest api %s, status is %d, error is %s", this.uri, statusCode, error));
                list = Collections.emptyList();
                if (response == null) break block18;
                response.close();
            }
            return list;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public HttpUriRequest prepareRequest(RequestBuilder requestBuilder, BlobTextFromDocument blobTextFromDocument) {
        if (blobTextFromDocument.getBlobs().size() != 1) {
            throw new NuxeoException("Loci.ai only supports one blob asset at a time.");
        }
        ManagedBlob blob = (ManagedBlob)blobTextFromDocument.getBlobs().values().stream().findFirst().get();
        String mimetype = blob.getMimeType();
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String extension = (String)mimetypeRegistry.getMimetypeEntryByMimeType(mimetype).getExtensions().get(0);
        try {
            CloseableFile closeableFile = blob.getCloseableFile();
            MultipartEntityBuilder multipartBuilder = MultipartEntityBuilder.create();
            multipartBuilder.setContentType(ContentType.MULTIPART_FORM_DATA);
            multipartBuilder.addBinaryBody("asset_file", closeableFile.getFile(), ContentType.DEFAULT_BINARY, String.format("%s.%s", closeableFile.getFile().getName(), extension));
            requestBuilder.setEntity(multipartBuilder.build());
            return requestBuilder.build();
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public Collection<EnrichmentMetadata> handleResponse(HttpResponse httpResponse, BlobTextFromDocument blobTextFromDocument) {
        try {
            String json = this.getContent(httpResponse);
            String rawKey = this.saveJsonAsRawBlob(json);
            LociResponse response = (LociResponse)objectMapper.readValue(json, LociResponse.class);
            return this.processResponseProperties(response.tags, rawKey, blobTextFromDocument);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Collection<EnrichmentMetadata> processResponseProperties(List<String> tags, String rawKey, BlobTextFromDocument blobTextFromDoc) {
        List<AIMetadata.Label> labels = tags.stream().map(tag -> new AIMetadata.Label(tag, 1.0f)).toList();
        return Collections.singletonList((EnrichmentMetadata)new EnrichmentMetadata.Builder(this.kind, this.name, blobTextFromDoc).withLabels(this.asLabels(labels)).withRawKey(rawKey).build());
    }
}

