/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml;

import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.nuxeo.ecm.platform.auth.saml.SAMLConfiguration;
import org.nuxeo.ecm.platform.ui.web.auth.LoginScreenHelper;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.validation.ValidationException;

public abstract class AbstractSAMLProfile {
    protected static final Log log = LogFactory.getLog(AbstractSAMLProfile.class);
    protected final XMLObjectBuilderFactory builderFactory;
    private final Endpoint endpoint;
    protected SignatureTrustEngine trustEngine;
    private Decrypter decrypter;
    private int skewTimeMillis;

    public AbstractSAMLProfile(Endpoint endpoint) {
        this.endpoint = endpoint;
        this.builderFactory = Configuration.getBuilderFactory();
        this.skewTimeMillis = SAMLConfiguration.getSkewTimeMillis();
    }

    public abstract String getProfileIdentifier();

    protected <T extends SAMLObject> T build(QName qName) {
        return (T)((SAMLObject)this.builderFactory.getBuilder(qName).buildObject(qName));
    }

    protected void validateSignature(Signature signature, String IDPEntityID) throws SAMLException {
        if (this.trustEngine == null) {
            throw new SAMLException("Trust engine is not set, signature can't be verified");
        }
        if (signature == null) {
            throw new SAMLException("Response signature is not set, signature can't be verified");
        }
        try {
            SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
            validator.validate(signature);
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new EntityIDCriteria(IDPEntityID));
            criteriaSet.add((Object)new MetadataCriteria(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol"));
            criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
            log.debug((Object)("Verifying signature: " + signature));
            if (!this.getTrustEngine().validate((Object)signature, criteriaSet)) {
                throw new SAMLException("Signature is not trusted or invalid");
            }
        }
        catch (SecurityException | ValidationException e) {
            throw new SAMLException("Error validating signature", (Exception)e);
        }
    }

    protected void validateIssuer(Issuer issuer, SAMLMessageContext context) throws SAMLException {
        if (issuer.getFormat() != null && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLException("Assertion invalidated by issuer type");
        }
        if (context.getPeerEntityMetadata() != null && !context.getPeerEntityMetadata().getEntityID().equals(issuer.getValue())) {
            throw new SAMLException("Assertion invalidated by unexpected issuer value");
        }
    }

    protected void validateEndpoint(Response response, Endpoint endpoint) throws SAMLException {
        String destination = response.getDestination();
        if (destination != null && !destination.equals(endpoint.getLocation()) && !destination.equals(endpoint.getResponseLocation())) {
            log.debug((Object)("Intended destination " + destination + " doesn't match any of the endpoint URLs"));
            throw new SAMLException("Intended destination " + destination + " doesn't match any of the endpoint URLs");
        }
        AuthnRequest request = this.retrieveRequest(response);
        if (request != null) {
            AssertionConsumerService assertionConsumerService = (AssertionConsumerService)endpoint;
            if (request.getAssertionConsumerServiceIndex() != null) {
                if (!request.getAssertionConsumerServiceIndex().equals(assertionConsumerService.getIndex())) {
                    log.info((Object)"SAML response was received at a different endpoint index than was requested");
                }
            } else {
                String responseLocation;
                String requestedResponseURL = request.getAssertionConsumerServiceURL();
                request.getProtocolBinding();
                if (requestedResponseURL != null && !requestedResponseURL.equals(responseLocation = assertionConsumerService.getResponseLocation() != null ? assertionConsumerService.getResponseLocation() : assertionConsumerService.getLocation())) {
                    log.info((Object)("SAML response was received at a different endpoint URL " + responseLocation + " than was requested " + requestedResponseURL));
                }
            }
        }
    }

    protected void validateAssertion(Assertion assertion, SAMLMessageContext context) throws SAMLException {
        this.validateIssuer(assertion.getIssuer(), context);
        Conditions conditions = assertion.getConditions();
        DateTime now = new DateTime();
        DateTime notBefore = conditions.getNotBefore();
        DateTime notOnOrAfter = conditions.getNotOnOrAfter();
        if (notBefore != null && notBefore.minusMillis(this.getSkewTimeMillis()).isAfterNow()) {
            log.debug((Object)("Current time: [" + now + "] NotBefore: [" + notBefore + "]"));
            throw new SAMLException("Conditions are not yet active");
        }
        if (notOnOrAfter != null && notOnOrAfter.plusMillis(this.getSkewTimeMillis()).isBeforeNow()) {
            log.debug((Object)("Current time: [" + now + "] NotOnOrAfter: [" + notOnOrAfter + "]"));
            throw new SAMLException("Conditions have expired");
        }
        Signature signature = assertion.getSignature();
        if (this.trustEngine != null) {
            this.validateSignature(signature, context.getPeerEntityMetadata().getEntityID());
        }
    }

    protected AuthnRequest retrieveRequest(Response response) throws SAMLException {
        return null;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public SignatureTrustEngine getTrustEngine() {
        return this.trustEngine;
    }

    public void setTrustEngine(SignatureTrustEngine trustEngine) {
        this.trustEngine = trustEngine;
    }

    public Decrypter getDecrypter() {
        return this.decrypter;
    }

    public void setDecrypter(Decrypter decrypter) {
        this.decrypter = decrypter;
    }

    public int getSkewTimeMillis() {
        return this.skewTimeMillis;
    }

    public void setSkewTimeMillis(int skewTimeMillis) {
        this.skewTimeMillis = skewTimeMillis;
    }

    protected String newUUID() {
        return "_" + UUID.randomUUID().toString();
    }

    protected String getBaseURL(ServletRequest request) {
        return VirtualHostHelper.getBaseURL((ServletRequest)request);
    }

    protected String getStartPageURL(ServletRequest request) {
        return this.getBaseURL(request) + LoginScreenHelper.getStartupPagePath();
    }
}

