/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.auth.saml.CatchRedirectHttpServletResponse;
import org.nuxeo.ecm.platform.auth.saml.SAMLCredential;
import org.nuxeo.ecm.platform.auth.saml.SAMLUtils;
import org.nuxeo.ecm.platform.auth.saml.processor.SAMLProcessor;
import org.nuxeo.ecm.platform.auth.saml.processor.SAMLProcessorFactory;
import org.nuxeo.ecm.platform.auth.saml.user.AbstractUserResolver;
import org.nuxeo.ecm.platform.auth.saml.user.EmailBasedUserResolver;
import org.nuxeo.ecm.platform.auth.saml.user.UserMapperBasedResolver;
import org.nuxeo.ecm.platform.auth.saml.user.UserResolver;
import org.nuxeo.ecm.platform.ui.web.auth.LoginScreenHelper;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPluginLogoutExtension;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLinkComputer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.usermapper.service.UserMapperService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.config.GlobalParserPoolInitializer;
import org.opensaml.core.xml.config.XMLObjectProviderInitializer;
import org.opensaml.xmlsec.config.DecryptionParserPoolInitializer;
import org.opensaml.xmlsec.config.GlobalAlgorithmRegistryInitializer;

public class SAMLAuthenticationProvider
implements NuxeoAuthenticationPlugin,
LoginProviderLinkComputer,
NuxeoAuthenticationPluginLogoutExtension {
    private static final Logger log = LogManager.getLogger(SAMLAuthenticationProvider.class);
    public static final String ERROR_PAGE = "/saml/error.jsp";
    public static final String ERROR_AUTH = "error.saml.auth";
    public static final String ERROR_USER = "error.saml.userMapping";
    protected static final Class<? extends UserResolver> DEFAULT_USER_RESOLVER_CLASS = EmailBasedUserResolver.class;
    protected static final Class<? extends UserResolver> USERMAPPER_USER_RESOLVER_CLASS = UserMapperBasedResolver.class;
    protected UserResolver userResolver;
    protected SAMLProcessorFactory processorFactory;

    public void initPlugin(Map<String, String> parameters) {
        String userResolverClassname = parameters.get("userResolverClass");
        Class<UserResolver> userResolverClass = null;
        if (StringUtils.isBlank((CharSequence)userResolverClassname)) {
            UserMapperService ums = (UserMapperService)Framework.getService(UserMapperService.class);
            userResolverClass = ums != null ? USERMAPPER_USER_RESOLVER_CLASS : DEFAULT_USER_RESOLVER_CLASS;
        } else {
            try {
                userResolverClass = Class.forName(userResolverClassname).asSubclass(AbstractUserResolver.class);
            }
            catch (ClassNotFoundException e) {
                throw new NuxeoException("Failed get user resolver class " + userResolverClassname, (Throwable)e);
            }
        }
        try {
            this.userResolver = userResolverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.userResolver.init(parameters);
        }
        catch (ReflectiveOperationException e) {
            log.error("Failed to initialize user resolver {}", (Object)userResolverClassname);
        }
        SAMLAuthenticationProvider.initOpenSAML();
        this.processorFactory = new SAMLProcessorFactory(parameters);
        if (StringUtils.isNotBlank((CharSequence)parameters.get("name"))) {
            LoginScreenHelper.registerSingleProviderLoginScreenConfig((String)parameters.get("name"), (String)parameters.get("icon"), null, (String)parameters.get("label"), (String)parameters.get("description"), (LoginProviderLinkComputer)this);
        }
    }

    protected static void initOpenSAML() {
        try {
            new XMLObjectProviderInitializer().init();
            new org.opensaml.saml.config.impl.XMLObjectProviderInitializer().init();
            new org.opensaml.xmlsec.config.impl.XMLObjectProviderInitializer().init();
            new GlobalParserPoolInitializer().init();
            new GlobalAlgorithmRegistryInitializer().init();
            new DecryptionParserPoolInitializer().init();
        }
        catch (InitializationException e) {
            throw new NuxeoException("Failed to initialize OpenSAML library", (Throwable)e);
        }
    }

    public String computeUrl(HttpServletRequest request, String requestedUrl) {
        SAMLProcessor processor = this.processorFactory.retrieveOutboundProcessor("urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser");
        CatchRedirectHttpServletResponse catchRedirectResponse = new CatchRedirectHttpServletResponse();
        processor.execute(request, catchRedirectResponse);
        return catchRedirectResponse.getLocation();
    }

    public Boolean handleLoginPrompt(HttpServletRequest request, HttpServletResponse response, String baseURL) {
        String loginError = (String)request.getAttribute("org.nuxeo.ecm.login.error");
        if (loginError != null) {
            try {
                request.getRequestDispatcher(ERROR_PAGE).forward((ServletRequest)request, (ServletResponse)response);
                return Boolean.TRUE;
            }
            catch (IOException | ServletException e) {
                log.error("Failed to redirect to error page", e);
                return Boolean.FALSE;
            }
        }
        String loginURL = this.computeUrl(request, null);
        try {
            response.sendRedirect(loginURL);
        }
        catch (IOException e) {
            log.error("Unable to send redirect on {}", (Object)loginURL, (Object)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest request, HttpServletResponse response) {
        SAMLProcessor processor = this.processorFactory.retrieveInboundProcessor(request).orElse(null);
        if (processor == null) {
            return null;
        }
        request.removeAttribute("org.nuxeo.ecm.login.error");
        processor.execute(request, response);
        if (request.getAttribute("org.nuxeo.ecm.login.error") != null) {
            return null;
        }
        SAMLCredential credential = (SAMLCredential)request.getAttribute("SAMLCredential");
        if (credential == null) {
            return null;
        }
        Optional<String> userId = this.findOrCreateNuxeoUser(this.userResolver, credential);
        if (userId.isEmpty()) {
            log.warn("Failed to resolve user with NameID: {}", (Object)credential.getNameID().getValue());
            SAMLUtils.setLoginError(request, ERROR_USER);
            return null;
        }
        SAMLUtils.getSAMLSessionCookie(credential).ifPresent(samlSessionCookie -> {
            Cookie cookie = samlSessionCookie.toCookie(request);
            cookie.setHttpOnly(true);
            response.addCookie(cookie);
        });
        HttpSession session = request.getSession(!response.isCommitted());
        if (session != null && StringUtils.isNotEmpty((CharSequence)credential.getRelayState())) {
            session.setAttribute("Nuxeo5_Start_Page", (Object)credential.getRelayState());
        }
        UserIdentificationInfo userIdent = new UserIdentificationInfo(userId.get());
        userIdent.setCredentialsChecked(true);
        return userIdent;
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return Boolean.TRUE;
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    protected String getSLOUrl(HttpServletRequest request, HttpServletResponse response) {
        SAMLProcessor processor = this.processorFactory.retrieveOutboundProcessor("urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout");
        if (processor == null) {
            return null;
        }
        CatchRedirectHttpServletResponse catchRedirectResponse = new CatchRedirectHttpServletResponse();
        processor.execute(request, catchRedirectResponse);
        return catchRedirectResponse.getLocation();
    }

    public Boolean handleLogout(HttpServletRequest request, HttpServletResponse response) {
        String logoutURL = this.getSLOUrl(request, response);
        if (logoutURL == null) {
            return Boolean.FALSE;
        }
        log.debug("Send redirect to {}", (Object)logoutURL);
        try {
            response.sendRedirect(logoutURL);
        }
        catch (IOException e) {
            log.error("Unable to send redirect on {}", (Object)logoutURL, (Object)e);
            return Boolean.FALSE;
        }
        SAMLUtils.getSAMLHttpCookie(request).ifPresent(cookie -> this.removeCookie(response, (Cookie)cookie));
        return Boolean.TRUE;
    }

    protected void removeCookie(HttpServletResponse httpResponse, Cookie cookie) {
        log.debug("Removing cookie {}", (Object)cookie.getName());
        cookie.setMaxAge(0);
        cookie.setValue("");
        httpResponse.addCookie(cookie);
    }

    protected Optional<String> findOrCreateNuxeoUser(UserResolver userResolver, SAMLCredential credential) {
        return Optional.ofNullable((String)Framework.doPrivileged(() -> userResolver.findOrCreateNuxeoUser(credential)));
    }
}

