/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.auth.saml.SAMLUtils;
import org.nuxeo.ecm.platform.auth.saml.key.KeyManager;
import org.nuxeo.ecm.platform.auth.saml.processor.binding.SAMLInboundBinding;
import org.nuxeo.runtime.api.Framework;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.signature.KeyInfo;

public class SAMLConfiguration {
    private static final Logger log = LogManager.getLogger(SAMLConfiguration.class);
    public static final String ENTITY_ID = "nuxeo.saml2.entityId";
    public static final String LOGIN_BINDINGS = "nuxeo.saml2.loginBindings";
    public static final String AUTHN_REQUESTS_SIGNED = "nuxeo.saml2.authnRequestsSigned";
    public static final String WANT_ASSERTIONS_SIGNED = "nuxeo.saml2.wantAssertionsSigned";
    public static final String SKEW_TIME_MS = "nuxeo.saml2.skewTimeMs";
    public static final int DEFAULT_SKEW_TIME_MS = 60000;
    public static final String BINDING_PREFIX = "urn:oasis:names:tc:SAML:2.0:bindings";
    public static final String DEFAULT_LOGIN_BINDINGS = "HTTP-Redirect,HTTP-POST";
    public static final Collection<String> nameID = Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");

    private SAMLConfiguration() {
    }

    public static String getEntityId() {
        return Framework.getProperty((String)ENTITY_ID, (String)Framework.getProperty((String)"nuxeo.url"));
    }

    public static List<String> getLoginBindings() {
        String[] suffixes;
        Set supportedBindings = Stream.of(SAMLInboundBinding.values()).map(SAMLInboundBinding::getBindingURI).collect(Collectors.toSet());
        ArrayList<String> bindings = new ArrayList<String>();
        for (String sufix : suffixes = Framework.getProperty((String)LOGIN_BINDINGS, (String)DEFAULT_LOGIN_BINDINGS).split(",")) {
            String binding = "urn:oasis:names:tc:SAML:2.0:bindings:" + sufix;
            if (supportedBindings.contains(binding)) {
                bindings.add(binding);
                continue;
            }
            log.warn("Unknown SAML binding: {}", (Object)binding);
        }
        return bindings;
    }

    public static boolean getAuthnRequestsSigned() {
        return Boolean.parseBoolean(Framework.getProperty((String)AUTHN_REQUESTS_SIGNED));
    }

    public static boolean getWantAssertionsSigned() {
        return Boolean.parseBoolean(Framework.getProperty((String)WANT_ASSERTIONS_SIGNED));
    }

    public static int getSkewTimeMillis() {
        String skewTimeMs = Framework.getProperty((String)SKEW_TIME_MS);
        return skewTimeMs != null ? Integer.parseInt(skewTimeMs) : 60000;
    }

    public static EntityDescriptor getEntityDescriptor(String baseURL) {
        EntityDescriptor descriptor = (EntityDescriptor)SAMLUtils.buildSAMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        descriptor.setEntityID(SAMLConfiguration.getEntityId());
        descriptor.getRoleDescriptors().add(SAMLConfiguration.getSPSSODescriptor(baseURL));
        return descriptor;
    }

    public static SPSSODescriptor getSPSSODescriptor(String baseURL) {
        SPSSODescriptor spDescriptor = (SPSSODescriptor)SAMLUtils.buildSAMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spDescriptor.setAuthnRequestsSigned(Boolean.valueOf(SAMLConfiguration.getAuthnRequestsSigned()));
        spDescriptor.setWantAssertionsSigned(Boolean.valueOf(SAMLConfiguration.getWantAssertionsSigned()));
        spDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        spDescriptor.getNameIDFormats().addAll(SAMLConfiguration.buildNameIDFormats(nameID));
        KeyManager keyManager = (KeyManager)Framework.getService(KeyManager.class);
        if (keyManager.getSigningCredential() != null) {
            spDescriptor.getKeyDescriptors().add(SAMLConfiguration.buildKeyDescriptor(UsageType.SIGNING, SAMLConfiguration.generateKeyInfoForCredential(keyManager.getSigningCredential())));
        }
        if (keyManager.getEncryptionCredential() != null) {
            spDescriptor.getKeyDescriptors().add(SAMLConfiguration.buildKeyDescriptor(UsageType.ENCRYPTION, SAMLConfiguration.generateKeyInfoForCredential(keyManager.getEncryptionCredential())));
        }
        if (keyManager.getTlsCredential() != null) {
            spDescriptor.getKeyDescriptors().add(SAMLConfiguration.buildKeyDescriptor(UsageType.UNSPECIFIED, SAMLConfiguration.generateKeyInfoForCredential(keyManager.getTlsCredential())));
        }
        int index = 0;
        for (String binding : SAMLConfiguration.getLoginBindings()) {
            AssertionConsumerService consumer = (AssertionConsumerService)SAMLUtils.buildSAMLObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
            consumer.setLocation(baseURL);
            consumer.setBinding(binding);
            consumer.setIsDefault(Boolean.valueOf(index == 0));
            consumer.setIndex(Integer.valueOf(index++));
            spDescriptor.getAssertionConsumerServices().add(consumer);
        }
        SingleLogoutService logoutService = (SingleLogoutService)SAMLUtils.buildSAMLObject(SingleLogoutService.DEFAULT_ELEMENT_NAME);
        logoutService.setLocation(baseURL);
        logoutService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        spDescriptor.getSingleLogoutServices().add(logoutService);
        return spDescriptor;
    }

    private static KeyDescriptor buildKeyDescriptor(UsageType type, KeyInfo key) {
        KeyDescriptor descriptor = (KeyDescriptor)SAMLUtils.buildSAMLObject(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        descriptor.setUse(type);
        descriptor.setKeyInfo(key);
        return descriptor;
    }

    private static Collection<NameIDFormat> buildNameIDFormats(Collection<String> nameIDs) {
        LinkedList<NameIDFormat> formats = new LinkedList<NameIDFormat>();
        for (String nameIDValue : nameIDs) {
            NameIDFormat nameID = (NameIDFormat)SAMLUtils.buildSAMLObject(NameIDFormat.DEFAULT_ELEMENT_NAME);
            nameID.setURI(nameIDValue);
            formats.add(nameID);
        }
        return formats;
    }

    private static KeyInfo generateKeyInfoForCredential(Credential credential) {
        try {
            KeyInfoGenerator keyInfoGenerator = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager().getDefaultManager().getFactory(credential).newInstance();
            return keyInfoGenerator.generate(credential);
        }
        catch (SecurityException e) {
            log.error("Failed to  generate key info.");
            return null;
        }
    }
}

