/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml;

import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.platform.auth.saml.SAMLCredential;
import org.nuxeo.ecm.platform.ui.web.auth.LoginScreenHelper;
import org.nuxeo.ecm.platform.web.common.CookieHelper;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.saml.common.SAMLObject;

public final class SAMLUtils {
    public static final String SAML_SESSION_KEY = "SAML_SESSION";

    private SAMLUtils() {
    }

    public static String newUUID() {
        return "_" + UUID.randomUUID();
    }

    public static <T extends SAMLObject> T buildSAMLObject(QName qName) {
        return (T)((SAMLObject)((XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class)).getBuilderFactory().getBuilderOrThrow(qName).buildObject(qName));
    }

    public static String getStartPageURL(ServletRequest request) {
        StringBuilder baseURL = new StringBuilder(VirtualHostHelper.getBaseURL((ServletRequest)request));
        if (baseURL.charAt(baseURL.length() - 1) != '/') {
            baseURL.append('/');
        }
        baseURL.append(LoginScreenHelper.getStartupPagePath());
        return baseURL.toString();
    }

    public static void setLoginError(HttpServletRequest request, String messageKey) {
        String msg = I18NUtils.getMessageString((String)"messages", (String)messageKey, null, (Locale)request.getLocale());
        request.setAttribute("org.nuxeo.ecm.login.error", (Object)msg);
    }

    public static Optional<Cookie> getSAMLHttpCookie(HttpServletRequest request) {
        return Stream.ofNullable(request.getCookies()).flatMap(Stream::of).filter(c -> SAML_SESSION_KEY.equals(c.getName())).findFirst();
    }

    public static Optional<SAMLSessionCookie> getSAMLSessionCookie(HttpServletRequest request) {
        return SAMLUtils.getSAMLHttpCookie(request).map(SAMLSessionCookie::fromCookie);
    }

    public static Optional<SAMLSessionCookie> getSAMLSessionCookie(SAMLCredential credential) {
        if (credential.getSessionIndexes() == null || credential.getSessionIndexes().isEmpty()) {
            return Optional.empty();
        }
        String sessionId = credential.getSessionIndexes().get(0);
        String nameValue = credential.getNameID().getValue();
        String nameFormat = (String)StringUtils.defaultIfBlank((CharSequence)credential.getNameID().getFormat(), (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        return Optional.of(new SAMLSessionCookie(sessionId, nameValue, nameFormat));
    }

    public record SAMLSessionCookie(String sessionId, String nameValue, String nameFormat) {
        public Cookie toCookie(HttpServletRequest request) {
            return CookieHelper.createCookie((HttpServletRequest)request, (String)SAMLUtils.SAML_SESSION_KEY, (String)String.join((CharSequence)"|", this.sessionId, this.nameValue, this.nameFormat));
        }

        public static SAMLSessionCookie fromCookie(Cookie cookie) {
            String[] parts = cookie.getValue().split("\\|");
            return new SAMLSessionCookie(parts[0], parts[1], parts[2]);
        }
    }
}

