/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.nuxeo.ecm.platform.auth.saml.SAMLConfiguration;
import org.nuxeo.ecm.platform.auth.saml.processor.AbstractSAMLProcessor;
import org.nuxeo.ecm.platform.auth.saml.processor.action.DecodeInboundRequestAction;
import org.nuxeo.ecm.platform.auth.saml.processor.action.HandleEventContextErrorAction;
import org.nuxeo.ecm.platform.auth.saml.processor.action.HandleSSOMessageAction;
import org.nuxeo.ecm.platform.auth.saml.processor.action.SetNameIdentifierFromResponseAction;
import org.nuxeo.ecm.platform.auth.saml.processor.binding.SAMLInboundBinding;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.profile.action.ProfileAction;
import org.opensaml.profile.context.PreviousEventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.navigate.SAMLEntityIDFunction;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.impl.AudienceRestrictionConditionValidator;
import org.opensaml.saml.saml2.assertion.impl.BearerSubjectConfirmationValidator;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.impl.DecryptAssertions;
import org.opensaml.saml.saml2.profile.impl.DecryptAttributes;
import org.opensaml.saml.saml2.profile.impl.DefaultAssertionValidationContextBuilder;
import org.opensaml.saml.saml2.profile.impl.ValidateAssertions;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;

public class InboundProcessor
extends AbstractSAMLProcessor {
    protected final SAMLInboundBinding inboundBinding;
    protected final MessageHandler inboundHandler;

    public InboundProcessor(SAMLInboundBinding inboundBinding, MessageHandler inboundHandler) {
        this.inboundBinding = inboundBinding;
        this.inboundHandler = inboundHandler;
    }

    @Override
    protected List<ProfileAction> getActions() {
        return List.of(new DecodeInboundRequestAction(this.inboundBinding, this.inboundHandler), new DecryptAssertions(), new DecryptAttributes(), this.newValidateAssertionsAction(), this.newSetNameIdentifierAction(), this.newHandleSSOMessageAction(), new HandleEventContextErrorAction());
    }

    protected ValidateAssertions newValidateAssertionsAction() {
        ValidateAssertions validateAssertions = new ValidateAssertions();
        validateAssertions.setHttpServletRequestSupplier(HttpServletRequestResponseContext::getRequest);
        validateAssertions.setAssertionValidatorLookup(pair -> {
            SignatureTrustEngine trustEngine = ((SecurityParametersContext)((ProfileRequestContext)pair.getFirst()).getInboundMessageContext().getSubcontext(SecurityParametersContext.class)).getSignatureValidationParameters().getSignatureTrustEngine();
            return new SAML20AssertionValidator(List.of(new AudienceRestrictionConditionValidator()), List.of(new BearerSubjectConfirmationValidator()), List.of(), null, trustEngine, (SignaturePrevalidator)new SAMLSignatureProfileValidator());
        });
        DefaultAssertionValidationContextBuilder validationContextBuilder = new DefaultAssertionValidationContextBuilder();
        validationContextBuilder.setCheckAddress(prc -> false);
        validationContextBuilder.setSignatureRequired(prc -> ((SAMLMetadataContext)((SAMLPeerEntityContext)prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class)).getSubcontext(SAMLMetadataContext.class)).getRoleDescriptor().getKeyDescriptors().stream().anyMatch(keyDescriptor -> keyDescriptor.getUse() == UsageType.SIGNING));
        validationContextBuilder.setInResponseToRequired(prc -> false);
        validationContextBuilder.setInResponseTo(prc -> ((Response)prc.getInboundMessageContext().getMessage()).getInResponseTo());
        validationContextBuilder.setClockSkew(Duration.ofMillis(SAMLConfiguration.getSkewTimeMillis()));
        validationContextBuilder.setValidIssuers(prc -> {
            String entityID = (String)new SAMLEntityIDFunction().compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class)).apply(prc.getInboundMessageContext());
            return entityID == null ? Set.of() : Set.of(entityID);
        });
        validateAssertions.setValidationContextBuilder((Function)validationContextBuilder);
        return validateAssertions;
    }

    protected SetNameIdentifierFromResponseAction newSetNameIdentifierAction() {
        SetNameIdentifierFromResponseAction setNameIdentifierAction = new SetNameIdentifierFromResponseAction();
        setNameIdentifierAction.setActivationCondition(this::isSuccessSSOResponse);
        return setNameIdentifierAction;
    }

    protected HandleSSOMessageAction newHandleSSOMessageAction() {
        HandleSSOMessageAction handleSSOAction = new HandleSSOMessageAction();
        handleSSOAction.setActivationCondition(this::isSuccessSSOResponse);
        return handleSSOAction;
    }

    protected boolean isSuccessSSOResponse(ProfileRequestContext prc) {
        Object message = prc.getInboundMessageContext().getMessage();
        return !(message instanceof LogoutRequest) && !(message instanceof LogoutResponse) && prc.getSubcontext(PreviousEventContext.class) == null;
    }
}

