/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.auth.saml.SAMLConfiguration;
import org.nuxeo.ecm.platform.auth.saml.key.KeyManager;
import org.nuxeo.ecm.platform.auth.saml.processor.InboundProcessor;
import org.nuxeo.ecm.platform.auth.saml.processor.SAMLProcessor;
import org.nuxeo.ecm.platform.auth.saml.processor.SLOOutboundProcessor;
import org.nuxeo.ecm.platform.auth.saml.processor.WebSSOOutboundProcessor;
import org.nuxeo.ecm.platform.auth.saml.processor.binding.SAMLInboundBinding;
import org.nuxeo.ecm.platform.auth.saml.processor.binding.SAMLOutboundBinding;
import org.nuxeo.ecm.platform.auth.saml.processor.handler.PopulateDecryptionParametersHandler;
import org.nuxeo.ecm.platform.auth.saml.processor.messaging.SAMLObjectIssuerFunction;
import org.nuxeo.runtime.api.Framework;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.messaging.handler.impl.BasicMessageHandlerChain;
import org.opensaml.messaging.handler.impl.CheckExpectedIssuer;
import org.opensaml.messaging.handler.impl.CheckMandatoryAuthentication;
import org.opensaml.messaging.handler.impl.FunctionMessageHandler;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.impl.PopulateSignatureSigningParametersHandler;
import org.opensaml.saml.common.binding.impl.SAMLMetadataLookupHandler;
import org.opensaml.saml.common.binding.impl.SAMLProtocolAndRoleHandler;
import org.opensaml.saml.common.binding.security.impl.MessageLifetimeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLProtocolMessageXMLSignatureSecurityHandler;
import org.opensaml.saml.common.messaging.context.AbstractSAMLEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.common.messaging.context.navigate.SAMLMessageContextIssuerFunction;
import org.opensaml.saml.metadata.IterableMetadataSource;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLMetadataSignatureSigningParametersResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParametersResolver;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParametersResolver;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.impl.BasicDecryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicDecryptionParametersResolver;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureValidationConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureValidationParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.messaging.impl.PopulateSignatureValidationParametersHandler;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;

public class SAMLProcessorFactory {
    protected static final String SIGNATURE_ALGORITHM = "SignatureAlgorithm";
    protected static final String DIGEST_ALGORITHM = "DigestAlgorithm";
    protected final MessageHandler inboundHandlerChain;
    protected final MessageHandler initInboundForOutboundHandlerChain;
    protected final MessageHandler outboundHandlerChain;

    public SAMLProcessorFactory(Map<String, String> parameters) {
        try {
            MetadataResolver idpMetadataResolver = this.instantiateIdpMetadataResolver(parameters);
            SignatureSigningConfiguration signingConfiguration = this.instantiateSigningConfiguration(parameters);
            SignatureValidationConfiguration validationConfiguration = this.instantiateValidationConfiguration(idpMetadataResolver);
            DecryptionConfiguration decryptionConfiguration = this.instantiateDecryptionConfiguration();
            ArrayList<MessageHandler> inboundHandlers = new ArrayList<MessageHandler>();
            inboundHandlers.add(this.buildEntityIdHandler(SAMLConfiguration.getEntityId(), SAMLSelfEntityContext.class));
            inboundHandlers.add(this.buildSAMLProtocolAndRoleHandler(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
            inboundHandlers.add(this.buildSAMLMetadataLookupHandler(idpMetadataResolver));
            inboundHandlers.add(this.buildMessageLifetimeSecurityHandler());
            inboundHandlers.add(this.buildCheckExpectedIssuer());
            inboundHandlers.add(this.buildCheckResponseStatus());
            inboundHandlers.add(this.buildPopulateSignatureValidationParametersHandler(validationConfiguration));
            inboundHandlers.add(this.buildSAMLProtocolMessageXMLSignatureSecurityHandler());
            inboundHandlers.add(this.buildCheckMandatoryAuthentication());
            inboundHandlers.add(this.buildPopulateDecryptionParametersHandler(decryptionConfiguration));
            this.inboundHandlerChain = this.toHandlerChain(inboundHandlers);
            String idpEntryId = ((EntityDescriptor)((IterableMetadataSource)idpMetadataResolver).iterator().next()).getEntityID();
            ArrayList<MessageHandler> initInboundForOutboundHandlers = new ArrayList<MessageHandler>();
            initInboundForOutboundHandlers.add(this.buildSAMLProtocolAndRoleHandler(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
            initInboundForOutboundHandlers.add(this.buildEntityIdHandler(idpEntryId, SAMLPeerEntityContext.class));
            initInboundForOutboundHandlers.add(this.buildSAMLMetadataLookupHandler(idpMetadataResolver));
            this.initInboundForOutboundHandlerChain = this.toHandlerChain(initInboundForOutboundHandlers);
            ArrayList<MessageHandler> outboundHandlers = new ArrayList<MessageHandler>();
            outboundHandlers.add(this.buildSAMLProtocolAndRoleHandler(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
            outboundHandlers.add(this.buildPopulateSignatureSigningParametersHandler(signingConfiguration));
            outboundHandlers.add(this.buildSAMLOutboundProtocolMessageSigningHandler());
            this.outboundHandlerChain = this.toHandlerChain(outboundHandlers);
        }
        catch (ComponentInitializationException e) {
            throw new NuxeoException("Unable to init SAML plugin with parameters: " + parameters);
        }
    }

    public Optional<SAMLProcessor> retrieveInboundProcessor(HttpServletRequest request) {
        return Stream.of(SAMLInboundBinding.values()).filter(b -> b.accept(request)).findFirst().map(b -> new InboundProcessor((SAMLInboundBinding)b, this.inboundHandlerChain));
    }

    public SAMLProcessor retrieveOutboundProcessor(String profileId) {
        return switch (profileId) {
            case "urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout" -> new SLOOutboundProcessor(this.initInboundForOutboundHandlerChain, this.outboundHandlerChain, SAMLOutboundBinding.HTTP_REDIRECT);
            case "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser" -> new WebSSOOutboundProcessor(this.initInboundForOutboundHandlerChain, this.outboundHandlerChain, SAMLOutboundBinding.HTTP_REDIRECT);
            default -> null;
        };
    }

    protected BasicMessageHandlerChain toHandlerChain(List<MessageHandler> outboundHandlers) throws ComponentInitializationException {
        BasicMessageHandlerChain handler = new BasicMessageHandlerChain();
        handler.setHandlers(outboundHandlers);
        handler.initialize();
        return handler;
    }

    protected MetadataResolver instantiateIdpMetadataResolver(Map<String, String> parameters) throws ComponentInitializationException {
        try {
            FilesystemMetadataResolver metadataResolver;
            String metadataUrl = parameters.get("metadata");
            if (metadataUrl == null) {
                throw new ResolverException("No metadata URI set for provider: " + parameters.getOrDefault("name", ""));
            }
            if (metadataUrl.startsWith("http:") || metadataUrl.startsWith("https:")) {
                int requestTimeout = Integer.parseInt(parameters.getOrDefault("timeout", "5"));
                int timeoutMs = requestTimeout * 1000;
                CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).setSocketTimeout(timeoutMs).build()).build();
                metadataResolver = new HTTPMetadataResolver((HttpClient)httpClient, metadataUrl);
            } else {
                metadataResolver = new FilesystemMetadataResolver(new File(metadataUrl));
            }
            metadataResolver.setId("IDP");
            metadataResolver.setParserPool(XMLObjectProviderRegistrySupport.getParserPool());
            metadataResolver.initialize();
            return metadataResolver;
        }
        catch (ResolverException e) {
            throw new ComponentInitializationException("Unable to init IDP metadata resolver", (Exception)((Object)e));
        }
    }

    protected SignatureSigningConfiguration instantiateSigningConfiguration(Map<String, String> parameters) {
        List algorithms;
        if (((KeyManager)Framework.getService(KeyManager.class)).getSigningCredential() == null) {
            return null;
        }
        BasicSignatureSigningConfiguration signingConfiguration = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        signingConfiguration.setSigningCredentials(List.of(((KeyManager)Framework.getService(KeyManager.class)).getSigningCredential()));
        if (parameters.containsKey(DIGEST_ALGORITHM)) {
            signingConfiguration.setSignatureReferenceDigestMethods(List.of(parameters.get(DIGEST_ALGORITHM)));
        }
        if (!(algorithms = parameters.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(SIGNATURE_ALGORITHM)).map(Map.Entry::getValue).collect(Collectors.toList())).isEmpty()) {
            signingConfiguration.setSignatureAlgorithms(algorithms);
        }
        return signingConfiguration;
    }

    protected SignatureValidationConfiguration instantiateValidationConfiguration(MetadataResolver idpMetadataResolver) throws ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver(idpMetadataResolver);
        KeyInfoCredentialResolver keyInfoResolver = DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver();
        MetadataCredentialResolver metadataCredentialResolver = new MetadataCredentialResolver();
        metadataCredentialResolver.setRoleDescriptorResolver((RoleDescriptorResolver)roleResolver);
        metadataCredentialResolver.setKeyInfoCredentialResolver(keyInfoResolver);
        roleResolver.initialize();
        metadataCredentialResolver.initialize();
        ExplicitKeySignatureTrustEngine trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)metadataCredentialResolver, keyInfoResolver);
        BasicSignatureValidationConfiguration validationConfiguration = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureValidationConfiguration();
        validationConfiguration.setSignatureTrustEngine((SignatureTrustEngine)trustEngine);
        return validationConfiguration;
    }

    protected DecryptionConfiguration instantiateDecryptionConfiguration() {
        if (((KeyManager)Framework.getService(KeyManager.class)).getEncryptionCredential() == null) {
            return null;
        }
        Credential encryptionCredential = ((KeyManager)Framework.getService(KeyManager.class)).getEncryptionCredential();
        BasicDecryptionConfiguration decryptionConfiguration = DefaultSecurityConfigurationBootstrap.buildDefaultDecryptionConfiguration();
        decryptionConfiguration.setEncryptedKeyResolver((EncryptedKeyResolver)new ChainingEncryptedKeyResolver(List.of(new InlineEncryptedKeyResolver(), new EncryptedElementTypeEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver())));
        decryptionConfiguration.setKEKKeyInfoCredentialResolver((KeyInfoCredentialResolver)new StaticKeyInfoCredentialResolver(encryptionCredential));
        return decryptionConfiguration;
    }

    protected MessageHandler buildSAMLProtocolAndRoleHandler(QName roleName) throws ComponentInitializationException {
        SAMLProtocolAndRoleHandler protocolAndRoleHandler = new SAMLProtocolAndRoleHandler();
        protocolAndRoleHandler.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        protocolAndRoleHandler.setRole(roleName);
        protocolAndRoleHandler.initialize();
        return protocolAndRoleHandler;
    }

    protected <C extends AbstractSAMLEntityContext> MessageHandler buildEntityIdHandler(String entityId, Class<C> contextClass) throws ComponentInitializationException {
        FunctionMessageHandler entityIdHandler = new FunctionMessageHandler();
        entityIdHandler.setFunction(context -> {
            AbstractSAMLEntityContext peerEntityContext = (AbstractSAMLEntityContext)context.getSubcontext(contextClass, true);
            if (peerEntityContext.getEntityId() == null) {
                peerEntityContext.setEntityId(entityId);
            }
            return null;
        });
        entityIdHandler.initialize();
        return entityIdHandler;
    }

    protected MessageHandler buildSAMLMetadataLookupHandler(MetadataResolver metadataResolver) throws ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver(metadataResolver);
        roleResolver.initialize();
        SAMLMetadataLookupHandler metadataLookupHandler = new SAMLMetadataLookupHandler();
        metadataLookupHandler.setRoleDescriptorResolver((RoleDescriptorResolver)roleResolver);
        metadataLookupHandler.initialize();
        return metadataLookupHandler;
    }

    protected MessageHandler buildMessageLifetimeSecurityHandler() throws ComponentInitializationException {
        MessageLifetimeSecurityHandler lifetimeHandler = new MessageLifetimeSecurityHandler();
        lifetimeHandler.setClockSkew(Duration.ofMillis(SAMLConfiguration.getSkewTimeMillis()));
        lifetimeHandler.initialize();
        return lifetimeHandler;
    }

    protected MessageHandler buildCheckExpectedIssuer() throws ComponentInitializationException {
        CheckExpectedIssuer expectedIssuer = new CheckExpectedIssuer();
        expectedIssuer.setIssuerLookupStrategy((Function)new SAMLObjectIssuerFunction());
        expectedIssuer.setExpectedIssuerLookupStrategy((Function)new SAMLMessageContextIssuerFunction());
        expectedIssuer.initialize();
        return expectedIssuer;
    }

    protected MessageHandler buildCheckResponseStatus() throws ComponentInitializationException {
        FunctionMessageHandler checkResponseHandler = new FunctionMessageHandler();
        checkResponseHandler.setFunction(context -> {
            StatusResponseType statusResponseType;
            Status status;
            String statusCode;
            Object message = context.getMessage();
            if (message instanceof StatusResponseType && !"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode = (status = (statusResponseType = (StatusResponseType)message).getStatus()).getStatusCode().getValue()) && !"urn:oasis:names:tc:SAML:2.0:status:PartialLogout".equals(statusCode)) {
                return new MessageHandlerException(String.format("The received status code is not a success, code: %s, message: %s", statusCode, status.getStatusMessage()));
            }
            return null;
        });
        checkResponseHandler.initialize();
        return checkResponseHandler;
    }

    protected MessageHandler buildPopulateSignatureValidationParametersHandler(SignatureValidationConfiguration validationConfiguration) throws ComponentInitializationException {
        PopulateSignatureValidationParametersHandler signatureValidationParameters = new PopulateSignatureValidationParametersHandler();
        signatureValidationParameters.setConfigurationLookupStrategy(context -> List.of(validationConfiguration));
        signatureValidationParameters.setSignatureValidationParametersResolver((SignatureValidationParametersResolver)new BasicSignatureValidationParametersResolver());
        signatureValidationParameters.initialize();
        return signatureValidationParameters;
    }

    protected MessageHandler buildSAMLProtocolMessageXMLSignatureSecurityHandler() throws ComponentInitializationException {
        SAMLProtocolMessageXMLSignatureSecurityHandler messageXMLSignatureHandler = new SAMLProtocolMessageXMLSignatureSecurityHandler();
        messageXMLSignatureHandler.initialize();
        return messageXMLSignatureHandler;
    }

    protected MessageHandler buildCheckMandatoryAuthentication() {
        CheckMandatoryAuthentication mandatoryAuthentication = new CheckMandatoryAuthentication();
        mandatoryAuthentication.setAuthenticationLookupStrategy(context -> ((SignableSAMLObject)context.getMessage()).getSignature() == null || ((SAMLPeerEntityContext)context.getSubcontext(SAMLPeerEntityContext.class)).isAuthenticated());
        return mandatoryAuthentication;
    }

    protected MessageHandler buildPopulateDecryptionParametersHandler(DecryptionConfiguration decryptionConfiguration) throws ComponentInitializationException {
        PopulateDecryptionParametersHandler decryptionParameters = new PopulateDecryptionParametersHandler();
        decryptionParameters.setActivationCondition(context -> decryptionConfiguration != null);
        decryptionParameters.setConfigurationLookupStrategy(context -> List.of(decryptionConfiguration));
        decryptionParameters.setDecryptionParametersResolver((DecryptionParametersResolver)new BasicDecryptionParametersResolver());
        decryptionParameters.initialize();
        return decryptionParameters;
    }

    protected MessageHandler buildPopulateSignatureSigningParametersHandler(SignatureSigningConfiguration signingConfiguration) throws ComponentInitializationException {
        PopulateSignatureSigningParametersHandler signatureSigningParameters = new PopulateSignatureSigningParametersHandler();
        signatureSigningParameters.setActivationCondition(context -> signingConfiguration != null);
        signatureSigningParameters.setConfigurationLookupStrategy(context -> List.of(signingConfiguration));
        signatureSigningParameters.setSignatureSigningParametersResolver((SignatureSigningParametersResolver)new SAMLMetadataSignatureSigningParametersResolver());
        signatureSigningParameters.setNoResultIsError(true);
        signatureSigningParameters.initialize();
        return signatureSigningParameters;
    }

    protected MessageHandler buildSAMLOutboundProtocolMessageSigningHandler() throws ComponentInitializationException {
        SAMLOutboundProtocolMessageSigningHandler messageSigner = new SAMLOutboundProtocolMessageSigningHandler();
        messageSigner.initialize();
        return messageSigner;
    }
}

