/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor.action;

import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jetbrains.annotations.NotNull;
import org.nuxeo.ecm.platform.auth.saml.SAMLUtils;
import org.opensaml.profile.action.AbstractConditionalProfileAction;
import org.opensaml.profile.context.PreviousEventContext;
import org.opensaml.profile.context.ProfileRequestContext;

public class HandleEventContextErrorAction
extends AbstractConditionalProfileAction {
    private static final Logger log = LogManager.getLogger(HandleEventContextErrorAction.class);

    public HandleEventContextErrorAction() {
        this.setActivationCondition(prc -> prc.getSubcontext(PreviousEventContext.class) != null);
    }

    protected void doExecute(@NotNull ProfileRequestContext profileRequestContext) {
        HttpServletRequest request = HttpServletRequestResponseContext.getRequest();
        PreviousEventContext eventContext = (PreviousEventContext)profileRequestContext.getSubcontext(PreviousEventContext.class);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((PreviousEventContext)eventContext).getEvent();
        log.info("Error processing SAML message, reason: {}", supplierArray);
        SAMLUtils.setLoginError(request, "error.saml.auth");
    }
}

