/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor.action;

import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.auth.saml.processor.binding.SAMLOutboundBinding;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;

public class SetEndpointAction
extends AbstractProfileAction {
    protected final Function<IDPSSODescriptor, List<? extends Endpoint>> endpointResolver;
    protected final SAMLOutboundBinding outboundBinding;

    public SetEndpointAction(Function<IDPSSODescriptor, List<? extends Endpoint>> endpointResolver, SAMLOutboundBinding outboundBinding) {
        this.endpointResolver = endpointResolver;
        this.outboundBinding = outboundBinding;
    }

    protected void doExecute(@NotNull ProfileRequestContext profileRequestContext) {
        SAMLMetadataContext samlMetadataContext = (SAMLMetadataContext)((SAMLPeerEntityContext)profileRequestContext.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class)).getSubcontext(SAMLMetadataContext.class);
        IDPSSODescriptor idpSSODescriptor = (IDPSSODescriptor)samlMetadataContext.getRoleDescriptor();
        Endpoint endpoint = this.endpointResolver.apply(idpSSODescriptor).stream().filter(e -> this.outboundBinding.getBindingURI().equals(e.getBinding())).findFirst().orElseThrow(() -> new NuxeoException("The IDP doesn't support the outbound binding: " + this.outboundBinding));
        MessageContext context = profileRequestContext.getOutboundMessageContext();
        SAMLEndpointContext endpointContext = (SAMLEndpointContext)((SAMLPeerEntityContext)context.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true);
        endpointContext.setEndpoint(endpoint);
    }
}

