/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor.binding;

import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.platform.auth.saml.processor.binding.SAMLBinding;
import org.opensaml.messaging.decoder.servlet.HttpServletRequestMessageDecoder;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPRedirectDeflateDecoder;

public enum SAMLInboundBinding implements SAMLBinding
{
    HTTP_POST("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", request -> "POST".equalsIgnoreCase(request.getMethod()) && SAMLInboundBinding.iSAMLObjectPresent(request), HTTPPostDecoder::new),
    HTTP_REDIRECT("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", request -> "GET".equalsIgnoreCase(request.getMethod()) && SAMLInboundBinding.iSAMLObjectPresent(request), HTTPRedirectDeflateDecoder::new);

    public static final String SAML_REQUEST = "SAMLRequest";
    public static final String SAML_RESPONSE = "SAMLResponse";
    protected final String bindingURI;
    protected final Predicate<HttpServletRequest> acceptor;
    protected final Supplier<HttpServletRequestMessageDecoder> decoderFactory;

    private SAMLInboundBinding(String bindingURI, Predicate<HttpServletRequest> acceptor, Supplier<HttpServletRequestMessageDecoder> decoderFactory) {
        this.bindingURI = bindingURI;
        this.acceptor = acceptor;
        this.decoderFactory = decoderFactory;
    }

    @Override
    public String getBindingURI() {
        return this.bindingURI;
    }

    public boolean accept(HttpServletRequest request) {
        return this.acceptor.test(request);
    }

    public HttpServletRequestMessageDecoder newDecoder() {
        return this.decoderFactory.get();
    }

    protected static boolean iSAMLObjectPresent(HttpServletRequest request) {
        return request.getParameter(SAML_REQUEST) != null || request.getParameter(SAML_RESPONSE) != null;
    }
}

