/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor.handler;

import java.util.List;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.DecryptionParametersResolver;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.DecryptionConfigurationCriterion;

public class PopulateDecryptionParametersHandler
extends AbstractMessageHandler {
    private static final Logger log = LogManager.getLogger(PopulateDecryptionParametersHandler.class);
    protected Function<MessageContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(SecurityParametersContext.class, true);
    protected Function<MessageContext, List<DecryptionConfiguration>> configurationLookupStrategy;
    protected DecryptionParametersResolver resolver;

    public void setSecurityParametersContextLookupStrategy(Function<MessageContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(Function<MessageContext, List<DecryptionConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DecryptionConfiguration lookup strategy cannot be null");
    }

    public void setDecryptionParametersResolver(DecryptionParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (DecryptionParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"DecryptionParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("DecryptionParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = input -> List.of(SecurityConfigurationSupport.getGlobalDecryptionConfiguration());
        }
    }

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        log.debug("{} Resolving DecryptionParameters for request", (Object)this.getLogPrefix());
        List<DecryptionConfiguration> configs = this.configurationLookupStrategy.apply(messageContext);
        if (configs == null || configs.isEmpty()) {
            log.error("{} No DecryptionConfiguration returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No DecryptionConfiguration returned by lookup strategy");
        }
        SecurityParametersContext paramsCtx = this.securityParametersContextLookupStrategy.apply(messageContext);
        if (paramsCtx == null) {
            log.debug("{} No SecurityParametersContext returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("SecurityParametersContext returned by lookup strategy");
        }
        try {
            DecryptionParameters params = (DecryptionParameters)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new DecryptionConfigurationCriterion(configs)}));
            paramsCtx.setDecryptionParameters(params);
            log.debug("{} {} DecryptionParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
        }
        catch (ResolverException e) {
            log.error("{} Error resolving DecryptionParameters: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            throw new MessageHandlerException("Error resolving DecryptionParameters");
        }
    }
}

