/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor.messaging;

import java.util.ArrayList;
import java.util.List;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;

public class SAMLAssertionsContentContext
extends BaseContext {
    protected List<String> sessionIndexes;
    protected List<Attribute> attributes;

    public List<String> getSessionIndexes() {
        if (this.sessionIndexes == null) {
            this.resolveContent();
        }
        return this.sessionIndexes;
    }

    public void setSessionIndexes(List<String> sessionIndexes) {
        this.sessionIndexes = sessionIndexes;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.resolveContent();
        }
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    protected void resolveContent() {
        SAMLObject message = this.resolveSAMLMessage();
        this.sessionIndexes = new ArrayList<String>();
        this.attributes = new ArrayList<Attribute>();
        if (message instanceof Response) {
            Response response = (Response)message;
            for (Assertion assertion : response.getAssertions()) {
                for (AuthnStatement statement : assertion.getAuthnStatements()) {
                    this.sessionIndexes.add(statement.getSessionIndex());
                }
                for (AuthnStatement statement : assertion.getAttributeStatements()) {
                    this.attributes.addAll(statement.getAttributes());
                }
            }
        }
    }

    protected SAMLObject resolveSAMLMessage() {
        MessageContext parent;
        Object object;
        BaseContext baseContext = this.getParent();
        if (baseContext instanceof MessageContext && (object = (parent = (MessageContext)baseContext).getMessage()) instanceof SAMLObject) {
            SAMLObject message = (SAMLObject)object;
            return message;
        }
        return null;
    }
}

