/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor.messaging;

import java.util.function.Function;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class SAMLObjectIssuerFunction
implements Function<MessageContext, String> {
    @Override
    public String apply(MessageContext context) {
        if (context == null) {
            return null;
        }
        SAMLObject message = (SAMLObject)context.getMessage();
        Issuer issuer = null;
        if (message instanceof RequestAbstractType) {
            RequestAbstractType request = (RequestAbstractType)message;
            issuer = request.getIssuer();
        } else if (message instanceof StatusResponseType) {
            StatusResponseType responseType = (StatusResponseType)message;
            issuer = responseType.getIssuer();
        }
        return issuer != null ? issuer.getValue() : null;
    }
}

