/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.user;

import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.auth.saml.SAMLCredential;
import org.nuxeo.ecm.platform.auth.saml.user.UserResolver;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUserResolver
implements UserResolver {
    private static final Logger log = LogManager.getLogger(AbstractUserResolver.class);

    public abstract String findNuxeoUser(SAMLCredential var1);

    public abstract String getLoginName(SAMLCredential var1);

    public DocumentModel createNuxeoUser(String nuxeoLogin) {
        DocumentModel userDoc;
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            userDoc = userManager.getBareUserModel();
            userDoc.setPropertyValue(userManager.getUserIdField(), (Serializable)((Object)nuxeoLogin));
            userManager.createUser(userDoc);
        }
        catch (NuxeoException e) {
            log.error("Error while creating user: {} in UserManager", (Object)nuxeoLogin, (Object)e);
            return null;
        }
        return userDoc;
    }

    public abstract DocumentModel updateUserInfo(DocumentModel var1, SAMLCredential var2);

    @Override
    public String findOrCreateNuxeoUser(SAMLCredential userInfo) {
        UserManager userManager;
        NuxeoPrincipal principal;
        String login = this.getLoginName(userInfo);
        if (login != null && (principal = (userManager = (UserManager)Framework.getService(UserManager.class)).getPrincipal(login)) != null) {
            return login;
        }
        String user = this.findNuxeoUser(userInfo);
        if (user == null) {
            DocumentModel userDoc = this.createNuxeoUser(login);
            this.updateUserInfo(userDoc, userInfo);
        }
        return user;
    }

    @Override
    public void init(Map<String, String> parameters) {
    }
}

