/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.key;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.nuxeo.ecm.platform.auth.saml.key.KeyDescriptor;
import org.nuxeo.ecm.platform.auth.saml.key.KeyManager;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.common.SAMLRuntimeException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.impl.KeyStoreCredentialResolver;

public class KeyManagerImpl
extends DefaultComponent
implements KeyManager {
    private static final Logger log = LogManager.getLogger(KeyManagerImpl.class);
    private static final String KEYSTORE_TYPE = "JKS";
    protected KeyDescriptor config;
    private KeyStore keyStore;
    private KeyStoreCredentialResolver credentialResolver;
    private Set<String> availableCredentials;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        this.config = (KeyDescriptor)contribution;
        this.setup();
    }

    private void setup() {
        if (this.config != null) {
            try {
                this.keyStore = this.getKeyStore(this.config.getKeystoreFilePath(), this.config.getKeystorePassword());
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            this.credentialResolver = new KeyStoreCredentialResolver(this.keyStore, this.config.getPasswords());
        } else {
            this.keyStore = null;
            this.credentialResolver = null;
            this.availableCredentials = null;
        }
    }

    private KeyStore getKeyStore(String path, String password) throws SecurityException {
        KeyStore ks;
        try {
            File rootKeystoreFile = new File(path);
            if (!rootKeystoreFile.exists()) {
                throw new SecurityException("Unable to find keyStore at " + new File(".").getAbsolutePath() + File.separator + path);
            }
            try (FileInputStream keystoreIS = new FileInputStream(rootKeystoreFile);){
                ks = KeyStore.getInstance(KEYSTORE_TYPE);
                ks.load(keystoreIS, password.toCharArray());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SecurityException("Unable to load the key store", e);
        }
        return ks;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        this.config = null;
        this.setup();
    }

    @Override
    public Credential getCredential(String keyName) {
        try {
            return this.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(keyName)}));
        }
        catch (ResolverException e) {
            throw new SAMLRuntimeException("Can't obtain SP signing key", (Exception)((Object)e));
        }
    }

    @Override
    public Set<String> getAvailableCredentials() {
        if (this.availableCredentials != null) {
            return this.availableCredentials;
        }
        try {
            this.availableCredentials = new HashSet<String>();
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                this.availableCredentials.add(aliases.nextElement());
            }
            return this.availableCredentials;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Unable to load aliases from keyStore", e);
        }
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        if (alias == null || alias.length() == 0) {
            return null;
        }
        try {
            return (X509Certificate)this.keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            log.error("Error loading certificate", (Throwable)e);
            return null;
        }
    }

    @Override
    public Credential getSigningCredential() {
        if (!this.hasCredentials() || this.config.getSigningKey() == null) {
            return null;
        }
        return this.getCredential(this.config.getSigningKey());
    }

    @Override
    public Credential getEncryptionCredential() {
        if (!this.hasCredentials() || this.config.getEncryptionKey() == null) {
            return null;
        }
        return this.getCredential(this.config.getEncryptionKey());
    }

    @Override
    public Credential getTlsCredential() {
        if (!this.hasCredentials() || this.config.getTlsKey() == null) {
            return null;
        }
        return this.getCredential(this.config.getTlsKey());
    }

    @NotNull
    public Iterable<Credential> resolve(CriteriaSet criteria) throws ResolverException {
        return this.credentialResolver.resolve(criteria);
    }

    public Credential resolveSingle(CriteriaSet criteria) throws ResolverException {
        return this.credentialResolver.resolveSingle(criteria);
    }

    private boolean hasCredentials() {
        return this.config != null && this.credentialResolver != null;
    }
}

