/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor;

import java.time.Instant;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.auth.saml.SAMLConfiguration;
import org.nuxeo.ecm.platform.auth.saml.SAMLUtils;
import org.nuxeo.ecm.platform.auth.saml.processor.AbstractSAMLProcessor;
import org.nuxeo.ecm.platform.auth.saml.processor.action.BuildOutboundMessageAction;
import org.nuxeo.ecm.platform.auth.saml.processor.action.EncodeOutboundResponseAction;
import org.nuxeo.ecm.platform.auth.saml.processor.action.InvokeInitInboundHandlerAction;
import org.nuxeo.ecm.platform.auth.saml.processor.action.SetEndpointAction;
import org.nuxeo.ecm.platform.auth.saml.processor.binding.SAMLOutboundBinding;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.profile.action.ProfileAction;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SSODescriptor;

public class SLOOutboundProcessor
extends AbstractSAMLProcessor {
    public static final String PROFILE_URI = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout";
    protected final MessageHandler initInboundHandler;
    protected final MessageHandler outboundHandler;
    protected final SAMLOutboundBinding outboundBinding;

    public SLOOutboundProcessor(MessageHandler initInboundHandler, MessageHandler outboundHandler, SAMLOutboundBinding outboundBinding) {
        this.initInboundHandler = initInboundHandler;
        this.outboundHandler = outboundHandler;
        this.outboundBinding = outboundBinding;
    }

    @Override
    protected List<ProfileAction> getActions() {
        return List.of(new InvokeInitInboundHandlerAction(this.initInboundHandler), new SetEndpointAction(SSODescriptor::getSingleLogoutServices, this.outboundBinding), new BuildOutboundMessageAction(this::buildLogoutRequest), new EncodeOutboundResponseAction(this.outboundBinding, this.outboundHandler));
    }

    protected LogoutRequest buildLogoutRequest(MessageContext ctx) {
        Endpoint endpoint = ((SAMLEndpointContext)((SAMLPeerEntityContext)ctx.getSubcontext(SAMLPeerEntityContext.class)).getSubcontext(SAMLEndpointContext.class)).getEndpoint();
        HttpServletRequest request = HttpServletRequestResponseContext.getRequest();
        SAMLUtils.SAMLSessionCookie samlSessionCookie = SAMLUtils.getSAMLSessionCookie(request).orElseThrow(() -> new NuxeoException("Unable to retrieve the SAML Session Cookie"));
        LogoutRequest logoutRequest = (LogoutRequest)SAMLUtils.buildSAMLObject(LogoutRequest.DEFAULT_ELEMENT_NAME);
        logoutRequest.setID(SAMLUtils.newUUID());
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        logoutRequest.setIssueInstant(Instant.now());
        logoutRequest.setDestination(endpoint.getLocation());
        Issuer issuer = (Issuer)SAMLUtils.buildSAMLObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(SAMLConfiguration.getEntityId());
        logoutRequest.setIssuer(issuer);
        logoutRequest.setNameID(this.buildNameID(samlSessionCookie));
        SessionIndex index = (SessionIndex)SAMLUtils.buildSAMLObject(SessionIndex.DEFAULT_ELEMENT_NAME);
        index.setValue(samlSessionCookie.sessionId());
        logoutRequest.getSessionIndexes().add(index);
        return logoutRequest;
    }

    protected NameID buildNameID(SAMLUtils.SAMLSessionCookie sessionCookie) {
        String nameValue = sessionCookie.nameValue();
        String nameFormat = sessionCookie.nameFormat();
        if (StringUtils.isBlank((CharSequence)nameFormat) || "null".equals(nameFormat)) {
            nameFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        NameID nameID = (NameID)SAMLUtils.buildSAMLObject(NameID.DEFAULT_ELEMENT_NAME);
        nameID.setValue(nameValue);
        nameID.setFormat(nameFormat);
        return nameID;
    }
}

