/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor;

import java.time.Instant;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.nuxeo.ecm.platform.auth.saml.SAMLConfiguration;
import org.nuxeo.ecm.platform.auth.saml.SAMLUtils;
import org.nuxeo.ecm.platform.auth.saml.processor.AbstractSAMLProcessor;
import org.nuxeo.ecm.platform.auth.saml.processor.action.BuildOutboundMessageAction;
import org.nuxeo.ecm.platform.auth.saml.processor.action.EncodeOutboundResponseAction;
import org.nuxeo.ecm.platform.auth.saml.processor.action.InvokeInitInboundHandlerAction;
import org.nuxeo.ecm.platform.auth.saml.processor.action.SetEndpointAction;
import org.nuxeo.ecm.platform.auth.saml.processor.binding.SAMLOutboundBinding;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.profile.action.ProfileAction;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;

public class WebSSOOutboundProcessor
extends AbstractSAMLProcessor {
    public static final String PROFILE_URI = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
    protected final MessageHandler initInboundHandler;
    protected final MessageHandler outboundHandler;
    protected final SAMLOutboundBinding outboundBinding;

    public WebSSOOutboundProcessor(MessageHandler initInboundHandler, MessageHandler outboundHandler, SAMLOutboundBinding outboundBinding) {
        this.initInboundHandler = initInboundHandler;
        this.outboundHandler = outboundHandler;
        this.outboundBinding = outboundBinding;
    }

    @Override
    protected List<ProfileAction> getActions() {
        return List.of(new InvokeInitInboundHandlerAction(this.initInboundHandler), new SetEndpointAction(IDPSSODescriptor::getSingleSignOnServices, this.outboundBinding), new BuildOutboundMessageAction(this::buildAuthnRequest), new EncodeOutboundResponseAction(this.outboundBinding, this.outboundHandler));
    }

    protected AuthnRequest buildAuthnRequest(MessageContext ctx) {
        Endpoint endpoint = ((SAMLEndpointContext)((SAMLPeerEntityContext)ctx.getSubcontext(SAMLPeerEntityContext.class)).getSubcontext(SAMLEndpointContext.class)).getEndpoint();
        HttpServletRequest request = HttpServletRequestResponseContext.getRequest();
        AuthnRequest authnRequest = (AuthnRequest)SAMLUtils.buildSAMLObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        authnRequest.setID(SAMLUtils.newUUID());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssueInstant(Instant.now());
        authnRequest.setDestination(endpoint.getLocation());
        authnRequest.setAssertionConsumerServiceURL(SAMLUtils.getStartPageURL((ServletRequest)request));
        Issuer issuer = (Issuer)SAMLUtils.buildSAMLObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(SAMLConfiguration.getEntityId());
        authnRequest.setIssuer(issuer);
        NameIDPolicy nameIDPolicy = (NameIDPolicy)SAMLUtils.buildSAMLObject(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        authnRequest.setNameIDPolicy(nameIDPolicy);
        return authnRequest;
    }
}

