/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor.action;

import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.jetbrains.annotations.NotNull;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;

public class BuildOutboundMessageAction
extends AbstractProfileAction {
    protected final Function<MessageContext, SAMLObject> buildRequest;

    public BuildOutboundMessageAction(Function<MessageContext, SAMLObject> buildRequest) {
        this.buildRequest = buildRequest;
    }

    protected void doExecute(@NotNull ProfileRequestContext profileRequestContext) {
        MessageContext context = profileRequestContext.getOutboundMessageContext();
        SAMLObject request = this.buildRequest.apply(context);
        context.setMessage((Object)request);
        String requestedUrl = this.getRequestedUrl(HttpServletRequestResponseContext.getRequest());
        if (requestedUrl != null) {
            SAMLBindingSupport.setRelayState((MessageContext)context, (String)requestedUrl);
        }
        profileRequestContext.setOutboundMessageContext(context);
    }

    protected String getRequestedUrl(HttpServletRequest request) {
        HttpSession session;
        String requestedUrl = (String)request.getAttribute("requestedUrl");
        if (requestedUrl == null && (session = request.getSession(false)) != null) {
            requestedUrl = (String)session.getAttribute("Nuxeo5_Start_Page");
        }
        return requestedUrl;
    }
}

