/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor.action;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.auth.saml.processor.binding.SAMLInboundBinding;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.HttpServletRequestMessageDecoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DecodeInboundRequestAction
extends AbstractProfileAction {
    private static final Logger log = LogManager.getLogger(DecodeInboundRequestAction.class);
    protected SAMLInboundBinding decoderBinding;
    protected MessageHandler messageHandler;

    public DecodeInboundRequestAction(SAMLInboundBinding decoderBinding, MessageHandler messageHandler) {
        this.decoderBinding = decoderBinding;
        this.messageHandler = messageHandler;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.decoderBinding == null) {
            throw new ComponentInitializationException("SAMLInboundBinding cannot be null");
        }
        if (HttpServletRequestResponseContext.getResponse() == null) {
            throw new ComponentInitializationException("HttpServletRequestResponseContext must be loaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(ProfileRequestContext profileRequestContext) {
        HttpServletRequestMessageDecoder decoder = this.decoderBinding.newDecoder();
        if (decoder == null) {
            log.error("{} Unable to locate an inbound message decoder", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToDecode");
            return;
        }
        try {
            log.debug("{} Decoding inbound request using message decoder of type {} for this response", (Object)this.getLogPrefix(), (Object)decoder.getClass().getName());
            decoder.setHttpServletRequestSupplier(HttpServletRequestResponseContext::getRequest);
            decoder.initialize();
            decoder.decode();
            MessageContext msgContext = decoder.getMessageContext();
            log.debug("{} Invoking message handler of type {} for this request", (Object)this.getLogPrefix(), (Object)this.messageHandler.getClass().getName());
            this.messageHandler.invoke(msgContext);
            profileRequestContext.setInboundMessageContext(msgContext);
        }
        catch (ComponentInitializationException | MessageDecodingException | MessageHandlerException e) {
            log.error("{} Unable to decode inbound response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToDecode");
        }
        finally {
            decoder.destroy();
        }
    }
}

