/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.processor.action;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.auth.saml.processor.binding.SAMLOutboundBinding;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.servlet.HttpServletResponseMessageEncoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class EncodeOutboundResponseAction
extends AbstractProfileAction {
    private static final Logger log = LogManager.getLogger(EncodeOutboundResponseAction.class);
    protected SAMLOutboundBinding encoderBinding;
    protected MessageHandler messageHandler;

    public EncodeOutboundResponseAction(SAMLOutboundBinding encoderBinding, MessageHandler messageHandler) {
        this.encoderBinding = encoderBinding;
        this.messageHandler = messageHandler;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.encoderBinding == null) {
            throw new ComponentInitializationException("SAMLOutboundBinding cannot be null");
        }
    }

    protected boolean doPreExecute(ProfileRequestContext profileRequestContext) {
        MessageContext msgContext = profileRequestContext.getOutboundMessageContext();
        if (msgContext == null) {
            log.debug("{} Outbound message context was null", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(ProfileRequestContext profileRequestContext) {
        HttpServletResponseMessageEncoder encoder = this.encoderBinding.newEncoder();
        if (encoder == null) {
            log.error("{} Unable to locate an outbound message encoder", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncode");
            return;
        }
        MessageContext msgContext = profileRequestContext.getOutboundMessageContext();
        try {
            log.debug("{} Encoding outbound response using message encoder of type {} for this response", (Object)this.getLogPrefix(), (Object)encoder.getClass().getName());
            encoder.setMessageContext(msgContext);
            encoder.setHttpServletResponseSupplier(HttpServletRequestResponseContext::getResponse);
            encoder.initialize();
            encoder.prepareContext();
            log.debug("{} Invoking message handler of type {} for this response", (Object)this.getLogPrefix(), (Object)this.messageHandler.getClass().getName());
            this.messageHandler.invoke(msgContext);
            encoder.encode();
            if (msgContext.getMessage() != null) {
                log.debug("{} Outbound message encoded from a message of type {}", (Object)this.getLogPrefix(), (Object)msgContext.getMessage().getClass().getName());
            } else {
                log.debug("{} Outbound message was encoded from protocol-specific data rather than MessageContext#getMessage()", (Object)this.getLogPrefix());
            }
        }
        catch (ComponentInitializationException | MessageEncodingException | MessageHandlerException e) {
            log.error("{} Unable to encode outbound response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncode");
        }
        finally {
            encoder.destroy();
        }
    }
}

