/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.user;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.auth.saml.SAMLCredential;
import org.nuxeo.ecm.platform.auth.saml.user.AbstractUserResolver;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class EmailBasedUserResolver
extends AbstractUserResolver {
    private static final Logger log = LogManager.getLogger(EmailBasedUserResolver.class);

    @Override
    public String findNuxeoUser(SAMLCredential credential) {
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            HashMap<String, String> query = new HashMap<String, String>();
            query.put(userManager.getUserEmailField(), credential.getNameID().getValue());
            DocumentModelList users = userManager.searchUsers(query, null);
            if (users.isEmpty()) {
                return null;
            }
            DocumentModel user = (DocumentModel)users.get(0);
            return (String)((Object)user.getPropertyValue(userManager.getUserIdField()));
        }
        catch (NuxeoException e) {
            log.error("Error while search user in UserManager using email: {}", (Object)credential.getNameID().getValue(), (Object)e);
            return null;
        }
    }

    @Override
    public DocumentModel updateUserInfo(DocumentModel user, SAMLCredential credential) {
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            user.setPropertyValue(userManager.getUserEmailField(), (Serializable)((Object)credential.getNameID().getValue()));
        }
        catch (NuxeoException e) {
            log.error("Error while search user in UserManager using email: {}", (Object)credential.getNameID().getValue(), (Object)e);
            return null;
        }
        return user;
    }

    @Override
    public String getLoginName(SAMLCredential userInfo) {
        String email = userInfo.getNameID().getValue();
        return email;
    }
}

