/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.web;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.platform.auth.saml.SAMLConfiguration;
import org.nuxeo.ecm.platform.auth.saml.SAMLUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(MetadataServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String baseURL = SAMLUtils.getStartPageURL((ServletRequest)request);
        EntityDescriptor descriptor = SAMLConfiguration.getEntityDescriptor(baseURL);
        try {
            Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)descriptor);
            if (marshaller == null) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((EntityDescriptor)descriptor).getElementQName();
                log.error("Unable to marshall message, no marshaller registered for message object: {}", supplierArray);
                return;
            }
            Element dom = marshaller.marshall((XMLObject)descriptor);
            SerializeSupport.writeNode((Node)dom, (OutputStream)response.getOutputStream());
        }
        catch (MarshallingException e) {
            log.error("Unable to write metadata.");
        }
    }
}

