/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import java.util.HashMap;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class QueryOptionsTransformInjectNS
extends XMLFilterImpl {
    private static final String SEARCH_NS = "http://marklogic.com/appservices/search";
    private boolean inBinding = false;
    private HashMap<String, String> nsmap = new HashMap();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (SEARCH_NS.equals(uri)) {
            if ("namespace-bindings".equals(localName)) {
                this.inBinding = true;
                this.nsmap.clear();
            }
            if (this.inBinding && "binding".equals(localName)) {
                this.nsmap.put(attributes.getValue("prefix"), attributes.getValue("namespace-uri"));
            }
            if (this.inBinding) {
                return;
            }
            BindingAttributes attrs = new BindingAttributes(attributes);
            if ("path-index".equals(localName) || "searchable-expression".equals(localName)) {
                String xmlns = null;
                for (String pfx : this.nsmap.keySet()) {
                    xmlns = "xmlns";
                    if (!"".equals(pfx)) {
                        xmlns = xmlns + ":" + pfx;
                    }
                    attrs.addAttribute("http://www.w3.org/2000/xmlns/", xmlns, this.nsmap.get(pfx));
                }
            }
            super.startElement(uri, localName, qName, attrs);
        } else {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (SEARCH_NS.equals(uri) && "namespace-bindings".equals(localName)) {
            this.inBinding = false;
            return;
        }
        if (this.inBinding) {
            return;
        }
        super.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] chars, int i, int i1) throws SAXException {
        if (this.inBinding) {
            return;
        }
        super.characters(chars, i, i1);
    }

    private static class BindingAttributes
    implements Attributes {
        private Vector<String> names = new Vector();
        private Vector<String> values = new Vector();
        private Vector<String> nsuris = new Vector();

        public BindingAttributes() {
        }

        public BindingAttributes(Attributes attributes) {
            if (attributes == null) {
                return;
            }
            for (int pos = 0; pos < attributes.getLength(); ++pos) {
                this.names.add(attributes.getQName(pos));
                this.values.add(attributes.getValue(pos));
                this.nsuris.add(attributes.getURI(pos));
            }
        }

        public void addAttribute(String uri, String qName, String value) {
            if (this.getIndex(qName) < 0) {
                this.nsuris.add(uri);
                this.names.add(qName);
                this.values.add(value);
            }
        }

        @Override
        public int getLength() {
            return this.names.size();
        }

        @Override
        public String getURI(int i) {
            return this.nsuris.get(i);
        }

        @Override
        public String getLocalName(int i) {
            String name = this.names.get(i);
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":"));
            }
            return name;
        }

        @Override
        public String getQName(int i) {
            return this.names.get(i);
        }

        @Override
        public String getType(int i) {
            return "CDATA";
        }

        @Override
        public String getValue(int i) {
            return this.values.get(i);
        }

        @Override
        public int getIndex(String uri, String localName) {
            for (int i = 0; i < this.names.size(); ++i) {
                if (!localName.equals(this.getLocalName(i)) || !uri.equals(this.getURI(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String qName) {
            for (int i = 0; i < this.names.size(); ++i) {
                if (!qName.equals(this.names.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String uri, String localName) {
            if (this.getIndex(uri, localName) >= 0) {
                return "CDATA";
            }
            return null;
        }

        @Override
        public String getType(String qName) {
            if (this.getIndex(qName) >= 0) {
                return "CDATA";
            }
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            int pos = this.getIndex(uri, localName);
            if (pos >= 0) {
                return this.getValue(pos);
            }
            return null;
        }

        @Override
        public String getValue(String qName) {
            int pos = this.getIndex(qName);
            if (pos >= 0) {
                return this.getValue(pos);
            }
            return null;
        }
    }
}

