/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.QuadsWriteHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.TriplesReadHandle;
import com.marklogic.client.io.marker.TriplesWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<Reader>,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
QuadsWriteHandle,
TriplesReadHandle,
TriplesWriteHandle,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(InputStreamHandle.class);
    private static final int BUFFER_SIZE = 8192;
    private Reader content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{Reader.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return Reader.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                ReaderHandle handle = this.isHandled(type) ? new ReaderHandle() : null;
                return handle;
            }
        };
    }

    public ReaderHandle() {
        this.setResendable(false);
    }

    public ReaderHandle(Reader content) {
        this();
        this.set(content);
    }

    @Override
    public Reader get() {
        return this.content;
    }

    @Override
    public void set(Reader content) {
        this.content = content;
    }

    public ReaderHandle with(Reader content) {
        this.set(content);
        return this;
    }

    public ReaderHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public ReaderHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            byte[] b = buffer.toByteArray();
            this.fromBuffer(b);
            return b;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            return new String(this.toBuffer(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        try {
            this.content = new InputStreamReader(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected ReaderHandle sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No character stream to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Charset charset = Charset.forName("UTF-8");
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer charBuf = CharBuffer.allocate(8192);
        byte[] buf = new byte[16384];
        ByteBuffer byteBuf = ByteBuffer.wrap(buf);
        while (this.content.read(charBuf) != -1) {
            encoder.reset();
            charBuf.flip();
            byteBuf.clear();
            CoderResult result = encoder.encode(charBuf, byteBuf, false);
            if (result.isError()) {
                throw new IOException("Failed during UTF-8 encoding - " + result.toString());
            }
            byteBuf.flip();
            out.write(buf, 0, byteBuf.limit());
            charBuf.clear();
        }
        out.flush();
    }

    @Override
    public void close() {
        if (this.content != null) {
            try {
                this.content.close();
            }
            catch (IOException e) {
                logger.error("Failed to close underlying InputStream", (Throwable)e);
                throw new MarkLogicIOException(e);
            }
        }
    }
}

