/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.admin.config;

import com.marklogic.client.admin.config.QueryOptions;
import com.marklogic.client.admin.config.support.Buckets;
import com.marklogic.client.admin.config.support.ConstraintSource;
import com.marklogic.client.admin.config.support.GeospatialIndexType;
import com.marklogic.client.admin.config.support.GeospatialSpec;
import com.marklogic.client.admin.config.support.HeatmapAndOptions;
import com.marklogic.client.admin.config.support.IndexSpecImpl;
import com.marklogic.client.admin.config.support.MetadataExtract;
import com.marklogic.client.admin.config.support.QueryOptionsConfiguration;
import com.marklogic.client.admin.config.support.QueryUri;
import com.marklogic.client.admin.config.support.RangeIndexType;
import com.marklogic.client.admin.config.support.RangeSpec;
import com.marklogic.client.admin.config.support.TermSource;
import com.marklogic.client.admin.config.support.TermSpec;
import com.marklogic.client.admin.config.support.TupleSource;
import com.marklogic.client.impl.GeospatialSpecImpl;
import com.marklogic.client.impl.RangeSpecImpl;
import com.marklogic.client.impl.Utilities;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

@Deprecated
public class QueryOptionsBuilder {
    public QueryOptionsConfiguration configure() {
        return new QueryOptionsConfiguration();
    }

    public QueryOptions.QueryConstraint constraint(String name, ConstraintSource source) {
        QueryOptions.QueryConstraint constraint = new QueryOptions.QueryConstraint(name);
        constraint.setSource(source);
        return constraint;
    }

    public QueryOptions.QueryValues values(String name, TupleSource source, String ... valuesOptions) {
        return this.values(name, source, (QueryOptions.Aggregate)null, valuesOptions);
    }

    public QueryOptions.QueryValues values(String name, TupleSource source, QueryOptions.Aggregate aggregate, String ... valuesOptions) {
        QueryOptions.QueryValues v = new QueryOptions.QueryValues();
        v.setName(name);
        v.setAggregate(aggregate);
        source.build(v);
        v.setValuesOptions(Arrays.asList(valuesOptions));
        return v;
    }

    public QueryOptions.QueryTuples tuples(String name, List<TupleSource> sources, String ... valuesOptions) {
        return this.tuples(name, sources, (QueryOptions.Aggregate)null, valuesOptions);
    }

    public QueryOptions.QueryTuples tuples(String name, List<TupleSource> sources, QueryOptions.Aggregate aggregate, String ... valuesOptions) {
        QueryOptions.QueryTuples tuples = new QueryOptions.QueryTuples();
        tuples.setName(name);
        tuples.setAggregate(aggregate);
        for (TupleSource t : sources) {
            t.build(tuples);
        }
        return tuples;
    }

    public QueryOptions.QueryOperator operator(String name, QueryOptions.QueryState ... states) {
        QueryOptions.QueryOperator operator = new QueryOptions.QueryOperator();
        operator.setName(name);
        for (QueryOptions.QueryState state : states) {
            operator.addState(state);
        }
        return operator;
    }

    public List<QueryOptions.QuerySortOrder> sortOrders(QueryOptions.QuerySortOrder ... sortOrders) {
        return Arrays.asList(sortOrders);
    }

    public QueryOptions.QuerySortOrder sortOrder(TermSpec indexSpec) {
        QueryOptions.QuerySortOrder sortOrder = new QueryOptions.QuerySortOrder();
        indexSpec.build(sortOrder);
        return sortOrder;
    }

    public QueryOptions.QuerySortOrder sortOrder(RangeSpec indexSpec, QueryOptions.QuerySortOrder.Direction direction) {
        QueryOptions.QuerySortOrder sortOrder = new QueryOptions.QuerySortOrder();
        indexSpec.build(sortOrder);
        sortOrder.setType(indexSpec.getType());
        sortOrder.setCollation(indexSpec.getCollation());
        sortOrder.setDirection(direction);
        return sortOrder;
    }

    public QueryOptions.QuerySortOrder sortByScore(QueryOptions.QuerySortOrder.Direction direction) {
        QueryOptions.QuerySortOrder sortOrder = new QueryOptions.QuerySortOrder();
        sortOrder.setScore();
        sortOrder.setDirection(direction);
        return sortOrder;
    }

    public QueryOptions.QueryAdditionalQuery additionalQuery(String ctsQuery) {
        return new QueryOptions.QueryAdditionalQuery(Utilities.domElement(ctsQuery));
    }

    public QueryOptions.QuerySearchableExpression searchableExpression(String searchableExpression, QueryOptions.ExpressionNamespaceBinding ... bindings) {
        return new QueryOptions.QuerySearchableExpression(searchableExpression, bindings);
    }

    public QueryOptions.QueryExtractMetadata extractMetadata(MetadataExtract ... extractions) {
        QueryOptions.QueryExtractMetadata extractMetadata = new QueryOptions.QueryExtractMetadata();
        for (MetadataExtract item : extractions) {
            item.build(extractMetadata);
        }
        return extractMetadata;
    }

    public QueryOptions.QueryTransformResults rawResults() {
        QueryOptions.QueryTransformResults t = new QueryOptions.QueryTransformResults();
        t.setApply("raw");
        return t;
    }

    public QueryOptions.QueryTransformResults emptySnippets() {
        QueryOptions.QueryTransformResults t = new QueryOptions.QueryTransformResults();
        t.setApply("empty-snippet");
        return t;
    }

    public QueryOptions.QueryTransformResults metadataSnippetTransform(QName ... preferredElements) {
        QueryOptions.QueryTransformResults t = new QueryOptions.QueryTransformResults();
        t.setApply("metadata-snippet");
        for (QName element : preferredElements) {
            t.addPreferredElement(new QueryOptions.MarkLogicQName(element.getNamespaceURI(), element.getLocalPart()));
        }
        return t;
    }

    public QueryOptions.QueryTransformResults snippetTransform(Integer perMatchTokens, Integer maxMatches, Integer maxSnippetChars, QName ... preferredElements) {
        QueryOptions.QueryTransformResults t = new QueryOptions.QueryTransformResults();
        t.setApply("snippet");
        t.setPerMatchTokens(perMatchTokens);
        t.setMaxMatches(maxMatches);
        t.setMaxSnippetChars(maxSnippetChars);
        for (QName element : preferredElements) {
            t.addPreferredElement(new QueryOptions.MarkLogicQName(element.getNamespaceURI(), element.getLocalPart()));
        }
        return t;
    }

    public QueryOptions.QueryTransformResults transformResults(QueryOptions.XQueryExtension extension) {
        QueryOptions.QueryTransformResults t = new QueryOptions.QueryTransformResults();
        t.setApply(extension.getApply());
        t.setNs(extension.getNs());
        t.setAt(extension.getAt());
        return t;
    }

    public QueryOptions.QueryGrammar grammar(List<QueryOptions.QueryGrammar.QueryStarter> starters, List<QueryOptions.QueryGrammar.QueryJoiner> joiners, String quotation, Element implicit) {
        QueryOptions.QueryGrammar grammar = new QueryOptions.QueryGrammar();
        grammar.setStarters(starters);
        grammar.setJoiners(joiners);
        grammar.setQuotation(quotation);
        grammar.setImplicit(implicit);
        return grammar;
    }

    public QueryOptions.QueryTerm term(QueryOptions.XQueryExtension extension) {
        QueryOptions.QueryTerm term = new QueryOptions.QueryTerm();
        term.setTermFunction(extension);
        return term;
    }

    public QueryOptions.QueryTerm term(QueryOptions.QueryTerm.TermApply empty, TermSource defaultSource, String ... termOptions) {
        QueryOptions.QueryTerm term = new QueryOptions.QueryTerm();
        term.setEmptyApply(empty);
        term.setSource(defaultSource);
        term.setTermOptions(Arrays.asList(termOptions));
        return term;
    }

    public QueryOptions.QueryTerm term(QueryOptions.QueryTerm.TermApply empty, String defaultSourceName, String ... termOptions) {
        QueryOptions.QueryTerm term = new QueryOptions.QueryTerm();
        term.setEmptyApply(empty);
        term.setRef(defaultSourceName);
        term.setTermOptions(Arrays.asList(termOptions));
        return term;
    }

    public QueryOptions.QueryTerm term(String ... termOptions) {
        QueryOptions.QueryTerm term = new QueryOptions.QueryTerm();
        term.setTermOptions(Arrays.asList(termOptions));
        return term;
    }

    public ConstraintSource properties() {
        return new QueryOptions.QueryProperties();
    }

    public QueryOptions.QueryCollection collection(String prefix) {
        return this.collection(prefix, null, new String[0]);
    }

    public QueryOptions.QueryCollection collection(String prefix, QueryOptions.Facets isFaceted, String ... options) {
        QueryOptions.QueryCollection collection = new QueryOptions.QueryCollection();
        if (isFaceted != null) {
            collection.doFacets(isFaceted == QueryOptions.Facets.FACETED);
        }
        collection.setPrefix(prefix);
        for (String option : options) {
            collection.addFacetOption(option);
        }
        return collection;
    }

    public QueryOptions.QueryElementQuery elementQuery(QName qname) {
        QueryOptions.QueryElementQuery qeq = new QueryOptions.QueryElementQuery();
        if (qname != null) {
            qeq.setNs(qname.getNamespaceURI());
            qeq.setName(qname.getLocalPart());
        }
        return qeq;
    }

    public List<TupleSource> tupleSources(TupleSource ... tupleSources) {
        return Arrays.asList(tupleSources);
    }

    public QueryOptions.QueryRange range(RangeSpec indexSpec) {
        return this.range(indexSpec, null, null, null, new String[0]);
    }

    public QueryOptions.QueryRange range(RangeSpec indexSpec, QueryOptions.Facets faceted, QueryOptions.FragmentScope scope, List<Buckets> buckets, String ... facetOptions) {
        QueryOptions.QueryRange range = new QueryOptions.QueryRange();
        indexSpec.build(range);
        if (faceted != null) {
            range.doFacets(faceted == QueryOptions.Facets.FACETED);
        }
        range.setFragmentScope(scope);
        range.addBuckets(buckets);
        for (String option : facetOptions) {
            range.addFacetOption(option);
        }
        return range;
    }

    public ConstraintSource value(TermSpec indexSpec) {
        return this.value(indexSpec, null, null, new String[0]);
    }

    public ConstraintSource value(TermSpec indexSpec, Double weight, QueryOptions.FragmentScope scope, String ... termOptions) {
        QueryOptions.QueryValue value = new QueryOptions.QueryValue();
        indexSpec.build(value);
        value.setWeight(weight);
        value.setFragmentScope(scope);
        value.setTermOptions(Arrays.asList(termOptions));
        return value;
    }

    public QueryOptions.QueryWord word(TermSpec indexSpec) {
        return this.word(indexSpec, null, null, new String[0]);
    }

    public QueryOptions.QueryWord word(TermSpec indexSpec, Double weight, QueryOptions.FragmentScope scope, String ... options) {
        QueryOptions.QueryWord word = new QueryOptions.QueryWord();
        indexSpec.build(word);
        word.setWeight(weight);
        word.setFragmentScope(scope);
        word.setTermOptions(Arrays.asList(options));
        return word;
    }

    public ConstraintSource customParse(QueryOptions.XQueryExtension parse, String ... termOptions) {
        QueryOptions.QueryCustom custom = new QueryOptions.QueryCustom(true);
        custom.setParse(parse);
        custom.setTermOptions(Arrays.asList(termOptions));
        return custom;
    }

    public ConstraintSource customFacet(QueryOptions.XQueryExtension parse, QueryOptions.XQueryExtension start, QueryOptions.XQueryExtension finish, String ... facetOptions) {
        QueryOptions.QueryCustom custom = new QueryOptions.QueryCustom(true);
        custom.setParse(parse);
        custom.setStartFacet(start);
        custom.setFinishFacet(finish);
        custom.setFacetOptions(Arrays.asList(facetOptions));
        return custom;
    }

    public ConstraintSource geospatial(GeospatialSpec index, HeatmapAndOptions heatmap, String ... geoOptions) {
        QueryOptions.QueryGeospatial geospatial = null;
        if (index.getGeospatialIndexType() == GeospatialIndexType.ATTRIBUTE_PAIR) {
            geospatial = new QueryOptions.QueryGeospatialAttributePair();
            geospatial.setLatitude(new QueryOptions.MarkLogicQName(index.getLatitude().getNamespaceURI(), index.getLatitude().getLocalPart()));
            geospatial.setLongitude(new QueryOptions.MarkLogicQName(index.getLongitude().getNamespaceURI(), index.getLongitude().getLocalPart()));
            geospatial.setParent(new QueryOptions.MarkLogicQName(index.getParent().getNamespaceURI(), index.getParent().getLocalPart()));
        } else if (index.getGeospatialIndexType() == GeospatialIndexType.ELEMENT_PAIR) {
            geospatial = new QueryOptions.QueryGeospatialElementPair();
            geospatial.setLatitude(new QueryOptions.MarkLogicQName(index.getLatitude().getNamespaceURI(), index.getLatitude().getLocalPart()));
            geospatial.setLongitude(new QueryOptions.MarkLogicQName(index.getLongitude().getNamespaceURI(), index.getLongitude().getLocalPart()));
            geospatial.setParent(new QueryOptions.MarkLogicQName(index.getParent().getNamespaceURI(), index.getParent().getLocalPart()));
        } else if (index.getGeospatialIndexType() == GeospatialIndexType.ELEMENT) {
            geospatial = new QueryOptions.QueryGeospatialElement();
            geospatial.setElement(new QueryOptions.MarkLogicQName(index.getElement().getNamespaceURI(), index.getElement().getLocalPart()));
        } else if (index.getGeospatialIndexType() == GeospatialIndexType.ELEMENT_CHILD) {
            geospatial = new QueryOptions.QueryGeospatialElement();
            geospatial.setElement(new QueryOptions.MarkLogicQName(index.getElement().getNamespaceURI(), index.getElement().getLocalPart()));
            geospatial.setParent(new QueryOptions.MarkLogicQName(index.getParent().getNamespaceURI(), index.getParent().getLocalPart()));
        }
        if (heatmap != null) {
            geospatial.setHeatmap(heatmap.getHeatmap());
        }
        if (geoOptions != null) {
            geospatial.setGeoOptions(Arrays.asList(geoOptions));
        }
        return geospatial;
    }

    public ConstraintSource geospatial(GeospatialSpec index, String ... geoOptions) {
        return this.geospatial(index, (HeatmapAndOptions)null, geoOptions);
    }

    public QueryOptions.QueryState state(String stateName) {
        QueryOptions.QueryState state = new QueryOptions.QueryState();
        state.setName(stateName);
        return state;
    }

    public TermSpec elementTermIndex(QName element) {
        IndexSpecImpl index = new IndexSpecImpl();
        index.setElement(element);
        return index;
    }

    public RangeSpec elementRangeIndex(QName element, RangeIndexType type) {
        RangeSpecImpl index = new RangeSpecImpl();
        index.setElement(element);
        index.setType(type.getType());
        index.setCollation(type.getCollation());
        return index;
    }

    public TermSpec elementAttributeTermIndex(QName element, QName attribute) {
        IndexSpecImpl index = new IndexSpecImpl();
        index.setElement(element);
        index.setAttribute(attribute);
        return index;
    }

    public RangeSpec elementAttributeRangeIndex(QName element, QName attribute, RangeIndexType type) {
        RangeSpecImpl index = new RangeSpecImpl();
        index.setAttribute(attribute);
        index.setElement(element);
        index.setType(type.getType());
        index.setCollation(type.getCollation());
        return index;
    }

    public TermSpec fieldTermIndex(String fieldName) {
        IndexSpecImpl index = new IndexSpecImpl();
        index.setField(fieldName);
        return index;
    }

    public RangeSpec fieldRangeIndex(String fieldName, RangeIndexType type) {
        RangeSpecImpl index = new RangeSpecImpl();
        index.setField(fieldName);
        index.setType(type.getType());
        index.setCollation(type.getCollation());
        return index;
    }

    public TermSpec jsonTermIndex(String jsonKey) {
        IndexSpecImpl index = new IndexSpecImpl();
        index.setJsonKey(jsonKey);
        return index;
    }

    public RangeSpec jsonRangeIndex(String jsonKey, RangeIndexType type) {
        RangeSpecImpl index = new RangeSpecImpl();
        index.setJsonKey(jsonKey);
        index.setType(type.getType());
        index.setCollation(type.getCollation());
        return index;
    }

    public RangeSpec pathIndex(String xPath, QueryOptions.ExpressionNamespaceBinding ... bindings) {
        return this.pathIndex(xPath, (QueryOptions.ExpressionNamespaceBindings)null, (RangeIndexType)null);
    }

    public RangeSpec pathIndex(String xPath, QueryOptions.ExpressionNamespaceBindings bindings, RangeIndexType type) {
        QueryOptions.PathIndex index = bindings == null ? new QueryOptions.PathIndex(xPath) : new QueryOptions.PathIndex(xPath, bindings.toArray());
        RangeSpecImpl impl = new RangeSpecImpl();
        impl.setPathIndex(index);
        if (type != null) {
            impl.setType(type.getType());
            impl.setCollation(type.getCollation());
        }
        return impl;
    }

    public GeospatialSpec attributePairGeospatialIndex(QName parent, QName latitudeAttribute, QName longitudeAttribute) {
        GeospatialSpecImpl index = new GeospatialSpecImpl();
        index.setLatitude(latitudeAttribute);
        index.setLongitude(longitudeAttribute);
        index.setParent(parent);
        index.setGeospatialIndexType(GeospatialIndexType.ATTRIBUTE_PAIR);
        return index;
    }

    public GeospatialSpec elementPairGeospatialIndex(QName parent, QName latitudeElement, QName longitudeElement) {
        GeospatialSpecImpl index = new GeospatialSpecImpl();
        index.setLatitude(latitudeElement);
        index.setLongitude(longitudeElement);
        index.setParent(parent);
        index.setGeospatialIndexType(GeospatialIndexType.ELEMENT_PAIR);
        return index;
    }

    public GeospatialSpec elementGeospatialIndex(QName geospatialElement) {
        GeospatialSpecImpl index = new GeospatialSpecImpl();
        index.setElement(geospatialElement);
        index.setGeospatialIndexType(GeospatialIndexType.ELEMENT);
        return index;
    }

    public GeospatialSpec elementChildGeospatialIndex(QName parent, QName geospatialElement) {
        GeospatialSpecImpl index = new GeospatialSpecImpl();
        index.setParent(parent);
        index.setElement(geospatialElement);
        index.setGeospatialIndexType(GeospatialIndexType.ELEMENT_CHILD);
        return index;
    }

    public HeatmapAndOptions heatmap(double south, double west, double north, double east, int latitudeDivs, int longitudeDivs, String ... options) {
        HeatmapAndOptions heatmapAndOptions = new HeatmapAndOptions();
        QueryOptions.Heatmap heatmap = new QueryOptions.Heatmap();
        heatmap.setN(north);
        heatmap.setS(south);
        heatmap.setW(west);
        heatmap.setE(east);
        heatmap.setLatdivs(latitudeDivs);
        heatmap.setLondivs(longitudeDivs);
        heatmapAndOptions.setHeatmap(heatmap);
        heatmapAndOptions.setFacetOptions(Arrays.asList(options));
        return heatmapAndOptions;
    }

    public QueryOptions.ExpressionNamespaceBinding ns(String prefix, String namespaceURI) {
        return new QueryOptions.ExpressionNamespaceBinding(prefix, namespaceURI);
    }

    public QueryOptions.QueryRange.Bucket bucket(String name, String label, String ge, String lt) {
        QueryOptions.QueryRange.Bucket bucket = new QueryOptions.QueryRange.Bucket();
        bucket.setName(name);
        bucket.setContent(label);
        bucket.setGe(ge);
        bucket.setLt(lt);
        return bucket;
    }

    public QueryOptions.QueryRange.ComputedBucket computedBucket(String name, String label, String ge, String lt, QueryOptions.QueryRange.ComputedBucket.AnchorValue anchor) {
        QueryOptions.QueryRange.ComputedBucket bucket = new QueryOptions.QueryRange.ComputedBucket();
        bucket.setName(name);
        bucket.setLabel(label);
        bucket.setGe(ge);
        bucket.setLt(lt);
        bucket.setAnchor(anchor);
        return bucket;
    }

    public QueryOptions.ConstraintValue constraintValue(String constraintName) {
        return new QueryOptions.ConstraintValue(constraintName);
    }

    public QueryUri uri() {
        return QueryUri.YES;
    }

    public QueryOptions.Field field(String name) {
        return new QueryOptions.Field(name);
    }

    public QueryOptions.Aggregate aggregate(String aggregateFunctionName) {
        QueryOptions.Aggregate a = new QueryOptions.Aggregate();
        a.setApply(aggregateFunctionName);
        return a;
    }

    public QueryOptions.Aggregate aggregate(String aggregateFunctionName, String aggregatePlugin) {
        QueryOptions.Aggregate a = new QueryOptions.Aggregate();
        a.setApply(aggregateFunctionName);
        a.setUdf(aggregatePlugin);
        return a;
    }

    public QueryOptions.XQueryExtension extension(String apply, String ns, String at) {
        QueryOptions.XQueryExtension locator = new QueryOptions.XQueryExtension();
        locator.setApply(apply);
        locator.setAt(at);
        locator.setNs(ns);
        return locator;
    }

    public RangeIndexType stringRangeType(String collation) {
        RangeIndexType rangeIndexType = new RangeIndexType("xs:string");
        rangeIndexType.setCollation(collation);
        return rangeIndexType;
    }

    public RangeIndexType rangeType(String type) {
        return new RangeIndexType(type);
    }

    public List<Buckets> buckets(Buckets ... buckets) {
        return Arrays.asList(buckets);
    }

    public QueryOptions.ElementValue elementValue(QName elemName) {
        QueryOptions.ElementValue qname = new QueryOptions.ElementValue();
        qname.setElemName(elemName.getLocalPart());
        qname.setElemNs(elemName.getNamespaceURI());
        return qname;
    }

    public QueryOptions.AttributeValue attributeValue(QName elemName, QName attrName) {
        QueryOptions.AttributeValue qname = new QueryOptions.AttributeValue();
        qname.setAttrName(attrName.getLocalPart());
        qname.setAttrNs(attrName.getNamespaceURI());
        qname.setElemName(elemName.getLocalPart());
        qname.setElemNs(elemName.getNamespaceURI());
        return qname;
    }

    public QueryOptions.JsonKey jsonValue(String keyName) {
        return new QueryOptions.JsonKey(keyName);
    }

    public List<QueryOptions.QueryGrammar.QueryStarter> starters(QueryOptions.QueryGrammar.QueryStarter ... starters) {
        return Arrays.asList(starters);
    }

    public QueryOptions.QueryGrammar.QueryStarter starterGrouping(String text, int strength, String delimiter) {
        QueryOptions.QueryGrammar.QueryStarter starter = new QueryOptions.QueryGrammar.QueryStarter();
        starter.setStarterText(text);
        starter.setStrength(strength);
        starter.setApply(QueryOptions.QueryGrammar.QueryStarter.StarterApply.GROUPING);
        starter.setDelimiter(delimiter);
        return starter;
    }

    public QueryOptions.QueryGrammar.QueryStarter starterPrefix(String text, int strength, String element) {
        QueryOptions.QueryGrammar.QueryStarter starter = new QueryOptions.QueryGrammar.QueryStarter();
        starter.setStarterText(text);
        starter.setStrength(strength);
        starter.setApply(QueryOptions.QueryGrammar.QueryStarter.StarterApply.PREFIX);
        starter.setElement(element);
        return starter;
    }

    public List<QueryOptions.QueryGrammar.QueryJoiner> joiners(QueryOptions.QueryGrammar.QueryJoiner ... joiners) {
        return Arrays.asList(joiners);
    }

    public QueryOptions.QueryGrammar.QueryJoiner joiner(String joinerText, int strength, QueryOptions.QueryGrammar.QueryJoiner.JoinerApply apply) {
        return this.joiner(joinerText, strength, apply, null, null, null);
    }

    public QueryOptions.QueryGrammar.QueryJoiner joiner(String joinerText, int strength, QueryOptions.QueryGrammar.QueryJoiner.JoinerApply apply, QueryOptions.QueryGrammar.QueryJoiner.Comparator comparator, QueryOptions.QueryGrammar.Tokenize tokenize) {
        QueryOptions.QueryGrammar.QueryJoiner joiner = this.joiner(joinerText, strength, apply, null, tokenize, null);
        joiner.setCompare(comparator);
        return joiner;
    }

    public QueryOptions.QueryGrammar.QueryJoiner joiner(String joinerText, int strength, QueryOptions.QueryGrammar.QueryJoiner.JoinerApply apply, String element, QueryOptions.QueryGrammar.Tokenize token) {
        return this.joiner(joinerText, strength, apply, element, token, null);
    }

    public QueryOptions.QueryGrammar.QueryJoiner joiner(String joinerText, int strength, QueryOptions.QueryGrammar.QueryJoiner.JoinerApply apply, String element, QueryOptions.QueryGrammar.Tokenize tokenize, Integer consume) {
        QueryOptions.QueryGrammar.QueryJoiner joiner = new QueryOptions.QueryGrammar.QueryJoiner(joinerText);
        joiner.setStrength(strength);
        joiner.setApply(apply);
        joiner.setElement(element);
        if (tokenize != null) {
            joiner.setTokenize(tokenize);
        }
        if (consume != null) {
            joiner.setConsume(consume);
        }
        return joiner;
    }

    public QueryOptions.ExpressionNamespaceBindings namespaces(QueryOptions.ExpressionNamespaceBinding ... namespaces) {
        QueryOptions.ExpressionNamespaceBindings bindings = new QueryOptions.ExpressionNamespaceBindings();
        for (QueryOptions.ExpressionNamespaceBinding b : namespaces) {
            bindings.addBinding(b.getPrefix(), b.getNamespaceURI());
        }
        return bindings;
    }
}

