/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.extra.dom4j;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DOM4JHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<Document>,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private SAXReader reader;
    private OutputFormat outputFormat;
    private Document content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{Document.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return Document.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                DOM4JHandle handle = this.isHandled(type) ? new DOM4JHandle() : null;
                return handle;
            }
        };
    }

    public DOM4JHandle() {
        super.setFormat(Format.XML);
        this.setResendable(true);
    }

    public DOM4JHandle(Document content) {
        this();
        this.set(content);
    }

    public SAXReader getReader() {
        if (this.reader == null) {
            this.reader = this.makeReader();
        }
        return this.reader;
    }

    public void setReader(SAXReader reader) {
        this.reader = reader;
    }

    protected SAXReader makeReader() {
        SAXReader reader = new SAXReader();
        reader.setValidation(false);
        return reader;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Override
    public Document get() {
        return this.content;
    }

    @Override
    public void set(Document content) {
        this.content = content;
    }

    public DOM4JHandle with(Document content) {
        this.set(content);
        return this;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("JDOMHandle supports the XML format only");
        }
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            return new String(this.toBuffer(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            return;
        }
        try {
            this.content = this.getReader().read((Reader)new InputStreamReader(content, "UTF-8"));
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        catch (DocumentException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No document to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        OutputFormat outputFormat = this.getOutputFormat();
        if (outputFormat != null) {
            new XMLWriter((Writer)writer, outputFormat).write(this.content);
        } else {
            new XMLWriter((Writer)writer).write(this.content);
        }
        ((Writer)writer).flush();
    }
}

