/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.extra.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class GSONHandle
extends BaseHandle<InputStream, String>
implements BufferableHandle,
ContentHandle<JsonElement>,
JSONReadHandle,
JSONWriteHandle,
StructureReadHandle,
StructureWriteHandle {
    private JsonElement content;
    private JsonParser parser;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{JsonElement.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return JsonElement.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                GSONHandle handle = this.isHandled(type) ? new GSONHandle() : null;
                return handle;
            }
        };
    }

    public GSONHandle() {
        super.setFormat(Format.JSON);
        this.setResendable(true);
    }

    public GSONHandle(JsonElement content) {
        this();
        this.set(content);
    }

    public JsonParser getParser() {
        if (this.parser == null) {
            this.parser = new JsonParser();
        }
        return this.parser;
    }

    @Override
    public JsonElement get() {
        return this.content;
    }

    @Override
    public void set(JsonElement content) {
        this.content = content;
    }

    public GSONHandle with(JsonElement content) {
        this.set(content);
        return this;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.JSON) {
            throw new IllegalArgumentException("GSONHandle supports the JSON format only");
        }
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        if (this.content == null) {
            return null;
        }
        return this.content.toString().getBytes(Charset.forName("UTF-8"));
    }

    public String toString() {
        if (this.content == null) {
            return null;
        }
        return this.content.toString();
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            return;
        }
        try {
            this.content = this.getParser().parse((Reader)new InputStreamReader(content, "UTF-8"));
        }
        catch (JsonIOException e) {
            throw new MarkLogicIOException(e);
        }
        catch (JsonSyntaxException e) {
            throw new MarkLogicIOException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected String sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No document to write");
        }
        return this.content.toString();
    }
}

