/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public abstract class JacksonBaseHandle<T>
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender {
    private ObjectMapper mapper;

    protected JacksonBaseHandle() {
        super.setFormat(Format.JSON);
    }

    public ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            this.mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        }
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public abstract void set(T var1);

    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.set(null);
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    public byte[] toBuffer() {
        try {
            if (!this.hasContent()) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            return new String(this.toBuffer(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (!this.hasContent()) {
            throw new IllegalStateException("No document to write");
        }
        return this;
    }

    protected abstract boolean hasContent();

    @Override
    public abstract void write(OutputStream var1) throws IOException;
}

