/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.CharBuffer;

public class ReaderTee
extends Reader {
    private Reader in;
    private OutputStreamWriter tee;
    private long max = 0L;
    private long sent = 0L;

    public ReaderTee(Reader in, OutputStream tee, long max) {
        this.in = in;
        this.tee = new OutputStreamWriter(tee);
        this.max = max;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.sent >= this.max) {
            return this.in.read();
        }
        int b = this.in.read();
        if (b == -1) {
            this.cleanupTee();
            return b;
        }
        if (this.max == Long.MAX_VALUE) {
            this.tee.write(b);
            return b;
        }
        this.tee.write(b);
        ++this.sent;
        if (this.sent == this.max) {
            this.cleanupTee();
        }
        return b;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.sent >= this.max) {
            return this.in.read(cbuf);
        }
        int resultLen = this.in.read(cbuf);
        if (resultLen < 1) {
            if (resultLen == -1) {
                this.cleanupTee();
            }
            return resultLen;
        }
        return this.readTee(cbuf, 0, resultLen);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.sent >= this.max) {
            return this.in.read(cbuf, off, len);
        }
        int resultLen = this.in.read(cbuf, off, len);
        if (resultLen < 1) {
            if (resultLen == -1) {
                this.cleanupTee();
            }
            return resultLen;
        }
        return this.readTee(cbuf, off, resultLen);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (this.sent >= this.max) {
            return this.in.read(target);
        }
        int resultLen = this.in.read(target);
        if (resultLen < 1) {
            if (resultLen == -1) {
                this.cleanupTee();
            }
            return resultLen;
        }
        char[] cbuf = new char[resultLen];
        target.get(cbuf);
        return this.readTee(cbuf, 0, resultLen);
    }

    private int readTee(char[] cbuf, int off, int resultLen) throws IOException {
        if (this.max == Long.MAX_VALUE) {
            this.tee.write(cbuf, off, resultLen);
            return resultLen;
        }
        int teeLen = this.sent + (long)resultLen <= this.max ? resultLen : (int)(this.max - this.sent);
        this.sent += (long)teeLen;
        this.tee.write(cbuf, off, teeLen);
        if (this.sent >= this.max) {
            this.cleanupTee();
        }
        return resultLen;
    }

    private void cleanupTee() throws IOException {
        if (this.tee == null) {
            return;
        }
        this.tee.flush();
        this.tee = null;
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.cleanupTee();
    }

    @Override
    public boolean ready() throws IOException {
        if (this.in == null) {
            return true;
        }
        return this.in.ready();
    }

    @Override
    public boolean markSupported() {
        if (this.in == null) {
            return false;
        }
        return this.in.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        if (this.in == null) {
            throw new IOException("Reader closed");
        }
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.in == null) {
            throw new IOException("Reader closed");
        }
        return this.in.skip(n);
    }
}

