/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.storage.marklogic;

import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.query.RawQueryDefinition;
import com.marklogic.client.query.RawStructuredQueryDefinition;
import com.marklogic.client.query.StructuredQueryBuilder;
import com.marklogic.client.query.StructuredQueryDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.storage.ExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.storage.marklogic.MarkLogicHelper;
import org.nuxeo.ecm.storage.marklogic.MarkLogicStateSerializer;
import org.nuxeo.runtime.api.Framework;

class MarkLogicQueryBuilder {
    private static final Long ZERO = 0L;
    private static final Long ONE = 1L;
    private static final String DATE_CAST = "DATE";
    protected final SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
    private static final Pattern NON_CANON_INDEX = Pattern.compile("[^/\\[\\]]+\\[(\\d+|\\*|\\*\\d+)\\]");
    protected static final Pattern WILDCARD_SPLIT = Pattern.compile("(.*/\\*\\d+)(?:/(.*))?");
    private final QueryManager queryManager;
    private final StructuredQueryBuilder sqb;
    private final Expression expression;
    private final SelectClause selectClause;
    private final OrderByClause orderByClause;
    private final Set<String> principals;
    private final ExpressionEvaluator.PathResolver pathResolver;
    private final boolean fulltextSearchDisabled;
    private final boolean distinctDocuments;
    private Boolean projectionHasWildcard;

    public MarkLogicQueryBuilder(QueryManager queryManager, DBSExpressionEvaluator evaluator, OrderByClause orderByClause, boolean distinctDocuments) {
        this.queryManager = queryManager;
        this.sqb = queryManager.newStructuredQueryBuilder();
        this.expression = evaluator.getExpression();
        this.selectClause = evaluator.getSelectClause();
        this.orderByClause = orderByClause;
        this.principals = evaluator.principals;
        this.pathResolver = evaluator.pathResolver;
        this.fulltextSearchDisabled = evaluator.fulltextSearchDisabled;
        this.distinctDocuments = distinctDocuments;
    }

    public boolean doManualProjection() {
        return !this.distinctDocuments && this.hasProjectionWildcard();
    }

    private boolean hasProjectionWildcard() {
        if (this.projectionHasWildcard == null) {
            this.projectionHasWildcard = false;
            for (int i = 0; i < this.selectClause.elements.size(); ++i) {
                Operand op = (Operand)this.selectClause.elements.get(i);
                if (!(op instanceof Reference)) {
                    throw new QueryParseException("Projection not supported: " + op);
                }
                if (!this.walkReference(op).hasWildcard()) continue;
                this.projectionHasWildcard = true;
                break;
            }
        }
        return this.projectionHasWildcard;
    }

    public RawQueryDefinition buildQuery() {
        Expression expression = this.expression;
        if (this.principals != null) {
            LiteralList principalLiterals = this.principals.stream().map(StringLiteral::new).collect(Collectors.toCollection(LiteralList::new));
            Expression principalsExpression = new Expression((Operand)new Reference("ecm:__read_acl"), Operator.IN, (Operand)principalLiterals);
            expression = new Expression((Operand)expression, Operator.AND, (Operand)principalsExpression);
        }
        RawStructuredQueryDefinition query = this.sqb.build(new StructuredQueryDefinition[]{this.walkExpression(expression).build(this.sqb)});
        String options = this.buildOptions();
        String comboQuery = "<search xmlns=\"http://marklogic.com/appservices/search\">" + query.toString() + options + "</search>";
        return this.queryManager.newRawCombinedQueryDefinition((StructureWriteHandle)new StringHandle(comboQuery));
    }

    private String buildOptions() {
        StringBuilder options = new StringBuilder("<options xmlns=\"http://marklogic.com/appservices/search\">");
        options.append("<transform-results apply=\"empty-snippet\"/>");
        if (!this.doManualProjection()) {
            options.append(this.buildProjections());
        }
        options.append("</options>");
        return options.toString();
    }

    private String buildProjections() {
        if (this.doManualProjection()) {
            return "";
        }
        StringBuilder extract = new StringBuilder("<extract-document-data selected=\"include-with-ancestors\">");
        for (int i = 0; i < this.selectClause.elements.size(); ++i) {
            Operand op = (Operand)this.selectClause.elements.get(i);
            if (!(op instanceof Reference)) {
                throw new QueryParseException("Projection not supported: " + op);
            }
            FieldInfo fieldInfo = this.walkReference((Reference)op);
            extract.append("<extract-path>");
            extract.append("/document").append('/').append(MarkLogicHelper.serializeKey(fieldInfo.queryField));
            extract.append("</extract-path>");
        }
        extract.append("</extract-document-data>");
        return extract.toString();
    }

    private QueryBuilder walkExpression(Expression expression) {
        String cast;
        Operator op = expression.operator;
        Operand lvalue = expression.lvalue;
        Operand rvalue = expression.rvalue;
        Reference ref = lvalue instanceof Reference ? (Reference)lvalue : null;
        String name = ref != null ? ref.name : null;
        String string = cast = ref != null ? ref.cast : null;
        if (DATE_CAST.equals(cast)) {
            this.checkDateLiteralForCast(op, rvalue, name);
        }
        if (op == Operator.STARTSWITH) {
            return this.walkStartsWith(lvalue, rvalue);
        }
        if ("ecm:path".equals(name)) {
            return this.walkEcmPath(op, rvalue);
        }
        if (op == Operator.SUM) {
            throw new UnsupportedOperationException("SUM");
        }
        if (op == Operator.SUB) {
            throw new UnsupportedOperationException("SUB");
        }
        if (op == Operator.MUL) {
            throw new UnsupportedOperationException("MUL");
        }
        if (op == Operator.DIV) {
            throw new UnsupportedOperationException("DIV");
        }
        if (op == Operator.LT) {
            return this.walkLt(lvalue, rvalue);
        }
        if (op == Operator.GT) {
            return this.walkGt(lvalue, rvalue);
        }
        if (op == Operator.EQ) {
            return this.walkEq(lvalue, rvalue, true);
        }
        if (op == Operator.NOTEQ) {
            return this.walkEq(lvalue, rvalue, false);
        }
        if (op == Operator.LTEQ) {
            return this.walkLtEq(lvalue, rvalue);
        }
        if (op == Operator.GTEQ) {
            return this.walkGtEq(lvalue, rvalue);
        }
        if (op == Operator.AND) {
            if (expression instanceof MultiExpression) {
                return this.walkMultiExpression((MultiExpression)expression);
            }
            return this.walkAnd(lvalue, rvalue);
        }
        if (op == Operator.NOT) {
            return this.walkNot(lvalue);
        }
        if (op == Operator.OR) {
            return this.walkOr(lvalue, rvalue);
        }
        if (op == Operator.LIKE) {
            return this.walkLike(lvalue, rvalue, true, false);
        }
        if (op == Operator.ILIKE) {
            return this.walkLike(lvalue, rvalue, true, true);
        }
        if (op == Operator.NOTLIKE) {
            return this.walkLike(lvalue, rvalue, false, false);
        }
        if (op == Operator.NOTILIKE) {
            return this.walkLike(lvalue, rvalue, false, true);
        }
        if (op == Operator.IN) {
            return this.walkIn(lvalue, rvalue, true);
        }
        if (op == Operator.NOTIN) {
            return this.walkIn(lvalue, rvalue, false);
        }
        if (op == Operator.ISNULL) {
            return this.walkNull(lvalue, true);
        }
        if (op == Operator.ISNOTNULL) {
            return this.walkNull(lvalue, false);
        }
        if (op == Operator.BETWEEN) {
            return this.walkBetween(lvalue, rvalue, true);
        }
        if (op == Operator.NOTBETWEEN) {
            return this.walkBetween(lvalue, rvalue, false);
        }
        throw new QueryParseException("Unknown operator: " + op);
    }

    private void checkDateLiteralForCast(Operator op, Operand value, String name) {
        if (op == Operator.BETWEEN || op == Operator.NOTBETWEEN) {
            LiteralList l = (LiteralList)value;
            this.checkDateLiteralForCast((Operand)l.get(0), name);
            this.checkDateLiteralForCast((Operand)l.get(1), name);
        } else {
            this.checkDateLiteralForCast(value, name);
        }
    }

    private void checkDateLiteralForCast(Operand value, String name) {
        if (value instanceof DateLiteral && !((DateLiteral)value).onlyDate) {
            throw new QueryParseException("DATE() cast must be used with DATE literal, not TIMESTAMP: " + name);
        }
    }

    private QueryBuilder walkStartsWith(Operand lvalue, Operand rvalue) {
        if (!(lvalue instanceof Reference)) {
            throw new QueryParseException("Invalid STARTSWITH query, left hand side must be a property: " + lvalue);
        }
        String name = ((Reference)lvalue).name;
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("Invalid STARTSWITH query, right hand side must be a literal path: " + rvalue);
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ("ecm:path".equals(name)) {
            return this.walkStartsWithPath(path);
        }
        return this.walkStartsWithNonPath(lvalue, path);
    }

    private QueryBuilder walkStartsWithPath(String path) {
        String ancestorId = this.pathResolver.getIdForPath(path);
        if (ancestorId == null) {
            return this.walkNull((Operand)new Reference("ecm:uuid"), true);
        }
        return this.walkEq((Operand)new Reference("ecm:__ancestorIds"), (Operand)new StringLiteral(ancestorId), true);
    }

    private QueryBuilder walkStartsWithNonPath(Operand lvalue, String path) {
        Expression equalOperand = new Expression(lvalue, Operator.EQ, (Operand)new StringLiteral(path));
        Expression likeOperand = new Expression(lvalue, Operator.LIKE, (Operand)new StringLiteral(path + "/%"));
        return this.walkOr((Operand)equalOperand, (Operand)likeOperand);
    }

    private QueryBuilder walkEcmPath(Operator op, Operand rvalue) {
        String id;
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:path requires = or <> operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:path requires literal path as right argument");
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((id = this.pathResolver.getIdForPath(path)) == null) {
            return this.walkNull((Operand)new Reference("ecm:uuid"), true);
        }
        return this.walkEq((Operand)new Reference("ecm:uuid"), (Operand)new StringLiteral(id), op == Operator.EQ);
    }

    private QueryBuilder walkNot(Operand lvalue) {
        QueryBuilder query = this.walkOperandAsExpression(lvalue);
        query.not();
        return query;
    }

    private QueryBuilder walkEq(Operand lvalue, Operand rvalue, boolean equals) {
        FieldInfo leftInfo = this.walkReference(lvalue);
        if (leftInfo.isMixinTypes() && !(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("Invalid EQ rhs: " + rvalue);
        }
        Literal convertedLiteral = this.convertIfBoolean(leftInfo, (Literal)rvalue);
        if (convertedLiteral == null) {
            return this.walkNull(lvalue, equals);
        }
        return this.getQueryBuilder(leftInfo, name -> new EqualQueryBuilder((String)name, convertedLiteral, equals));
    }

    private QueryBuilder walkLt(Operand lvalue, Operand rvalue) {
        FieldInfo leftInfo = this.walkReference(lvalue);
        return this.getQueryBuilder(leftInfo, name -> new RangeQueryBuilder((String)name, StructuredQueryBuilder.Operator.LT, (Literal)rvalue));
    }

    private QueryBuilder walkGt(Operand lvalue, Operand rvalue) {
        FieldInfo leftInfo = this.walkReference(lvalue);
        return this.getQueryBuilder(leftInfo, name -> new RangeQueryBuilder((String)name, StructuredQueryBuilder.Operator.GT, (Literal)rvalue));
    }

    private QueryBuilder walkLtEq(Operand lvalue, Operand rvalue) {
        FieldInfo leftInfo = this.walkReference(lvalue);
        return this.getQueryBuilder(leftInfo, name -> new RangeQueryBuilder((String)name, StructuredQueryBuilder.Operator.LE, (Literal)rvalue));
    }

    private QueryBuilder walkGtEq(Operand lvalue, Operand rvalue) {
        FieldInfo leftInfo = this.walkReference(lvalue);
        return this.getQueryBuilder(leftInfo, name -> new RangeQueryBuilder((String)name, StructuredQueryBuilder.Operator.GE, (Literal)rvalue));
    }

    private QueryBuilder walkBetween(Operand lvalue, Operand rvalue, boolean positive) {
        LiteralList literals = (LiteralList)rvalue;
        Literal left = (Literal)literals.get(0);
        Literal right = (Literal)literals.get(1);
        Expression gteExpression = new Expression(lvalue, Operator.GTEQ, (Operand)left);
        Expression lteExpression = new Expression(lvalue, Operator.LTEQ, (Operand)right);
        QueryBuilder andBuilder = this.walkAnd((Operand)gteExpression, (Operand)lteExpression);
        if (!positive) {
            andBuilder.not();
        }
        return andBuilder;
    }

    private QueryBuilder walkMultiExpression(MultiExpression expression) {
        return this.walkAnd(expression.values);
    }

    private QueryBuilder walkAnd(Operand lvalue, Operand rvalue) {
        return this.walkAnd(Arrays.asList(lvalue, rvalue));
    }

    private QueryBuilder walkAnd(List<Operand> values) {
        List<QueryBuilder> children = this.walkOperandAsExpression(values);
        LinkedHashMap<String, List> propBaseToBuilders = new LinkedHashMap<String, List>();
        HashMap<String, String> propBaseKeyToFieldBase = new HashMap<String, String>();
        Iterator<QueryBuilder> it = children.iterator();
        while (it.hasNext()) {
            QueryBuilder child = it.next();
            if (!(child instanceof CorrelatedContainerQueryBuilder)) continue;
            CorrelatedContainerQueryBuilder queryBuilder = (CorrelatedContainerQueryBuilder)child;
            String correlatedPath = queryBuilder.getCorrelatedPath();
            propBaseKeyToFieldBase.putIfAbsent(correlatedPath, queryBuilder.getPath());
            List propBaseBuilders = propBaseToBuilders.computeIfAbsent(correlatedPath, key -> new LinkedList());
            propBaseBuilders.add(queryBuilder.getChild());
            it.remove();
        }
        for (Map.Entry entry : propBaseToBuilders.entrySet()) {
            String correlatedPath = (String)entry.getKey();
            List propBaseBuilders = (List)entry.getValue();
            QueryBuilder queryBuilder = propBaseBuilders.size() == 1 ? (QueryBuilder)propBaseBuilders.get(0) : new CompositionQueryBuilder(propBaseBuilders, true);
            String path = (String)propBaseKeyToFieldBase.get(correlatedPath);
            children.add(new CorrelatedContainerQueryBuilder(path, correlatedPath, queryBuilder));
        }
        if (children.size() == 1) {
            return children.get(0);
        }
        return new CompositionQueryBuilder(children, true);
    }

    private QueryBuilder walkOr(Operand lvalue, Operand rvalue) {
        return this.walkOr(Arrays.asList(lvalue, rvalue));
    }

    private QueryBuilder walkOr(List<Operand> values) {
        List<QueryBuilder> children = this.walkOperandAsExpression(values);
        if (children.size() == 1) {
            return children.get(0);
        }
        return new CompositionQueryBuilder(children, false);
    }

    private QueryBuilder walkLike(Operand lvalue, Operand rvalue, boolean positive, boolean caseInsensitive) {
        FieldInfo leftInfo = this.walkReference(lvalue);
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("Invalid LIKE/ILIKE, right hand side must be a string: " + rvalue);
        }
        return this.getQueryBuilder(leftInfo, name -> new LikeQueryBuilder((String)name, (StringLiteral)rvalue, positive, caseInsensitive));
    }

    private QueryBuilder walkIn(Operand lvalue, Operand rvalue, boolean positive) {
        if (!(rvalue instanceof LiteralList)) {
            throw new QueryParseException("Invalid IN, right hand side must be a list: " + rvalue);
        }
        FieldInfo leftInfo = this.walkReference(lvalue);
        return this.getQueryBuilder(leftInfo, name -> new InQueryBuilder((String)name, (LiteralList)rvalue, positive));
    }

    private QueryBuilder walkNull(Operand lvalue, boolean isNull) {
        FieldInfo leftInfo = this.walkReference(lvalue);
        return this.getQueryBuilder(leftInfo, name -> new IsNullQueryBuilder((String)name, isNull));
    }

    private List<QueryBuilder> walkOperandAsExpression(List<Operand> operands) {
        return operands.stream().map(this::walkOperandAsExpression).collect(Collectors.toList());
    }

    private QueryBuilder walkOperandAsExpression(Operand operand) {
        if (!(operand instanceof Expression)) {
            throw new IllegalArgumentException("Operand " + operand + "is not an Expression.");
        }
        return this.walkExpression((Expression)operand);
    }

    private FieldInfo walkReference(Operand value) {
        if (!(value instanceof Reference)) {
            throw new QueryParseException("Invalid query, left hand side must be a property: " + value);
        }
        return this.walkReference((Reference)value);
    }

    private FieldInfo walkReference(Reference reference) {
        Type type;
        FieldInfo fieldInfo = this.walkReference(reference.name);
        if (!(!DATE_CAST.equals(reference.cast) || (type = fieldInfo.type) instanceof DateType || type instanceof ListType && ((ListType)type).getFieldType() instanceof DateType)) {
            throw new QueryParseException("Cannot cast to " + reference.cast + ": " + reference.name);
        }
        return fieldInfo;
    }

    private FieldInfo walkReference(String name) {
        String prop = this.canonicalXPath(name);
        CharSequence[] parts = prop.split("/");
        if (prop.startsWith("ecm:")) {
            if (prop.startsWith("ecm:acl/")) {
                return this.parseACP(prop, (String[])parts);
            }
            String field = DBSSession.convToInternal((String)prop);
            return new FieldInfo(prop, field);
        }
        String first = parts[0];
        Field field = this.schemaManager.getField(first);
        if (field == null) {
            if (first.indexOf(58) > -1) {
                throw new QueryParseException("No such property: " + name);
            }
            for (Schema schema : this.schemaManager.getSchemas()) {
                if (StringUtils.isBlank((String)schema.getNamespace().prefix) && schema != null && (field = schema.getField(first)) != null) break;
            }
            if (field == null) {
                throw new QueryParseException("No such property: " + name);
            }
        }
        Type type = field.getType();
        parts[0] = field.getName().getPrefixedName();
        boolean firstPart = true;
        for (String string : parts) {
            if (NumberUtils.isDigits((String)string)) {
                type = ((ListType)type).getFieldType();
            } else if (!string.startsWith("*")) {
                if (!firstPart) {
                    field = ((ComplexType)type).getField(string);
                    if (field == null) {
                        throw new QueryParseException("No such property: " + name);
                    }
                    type = field.getType();
                }
            } else {
                type = ((ListType)type).getFieldType();
            }
            firstPart = false;
        }
        String fullField = String.join((CharSequence)"/", parts);
        return new FieldInfo(prop, fullField, type, false);
    }

    private FieldInfo parseACP(String prop, String[] parts) {
        String fullField;
        if (parts.length != 3) {
            throw new QueryParseException("No such property: " + prop);
        }
        String wildcard = parts[1];
        if (NumberUtils.isDigits((String)wildcard)) {
            throw new QueryParseException("Cannot use explicit index in ACLs: " + prop);
        }
        String last = parts[2];
        if ("name".equals(last)) {
            fullField = "ecm:acp/*/name";
        } else {
            String fieldLast = DBSSession.convToInternalAce((String)last);
            if (fieldLast == null) {
                throw new QueryParseException("No such property: " + prop);
            }
            fullField = "ecm:acp/*/acl/" + wildcard + '/' + fieldLast;
        }
        Type type = DBSSession.getType((String)last);
        return new FieldInfo(prop, fullField, type, false);
    }

    private String canonicalXPath(String xpath) {
        while (xpath.length() > 0 && xpath.charAt(0) == '/') {
            xpath = xpath.substring(1);
        }
        if (xpath.indexOf(91) == -1) {
            return xpath;
        }
        return NON_CANON_INDEX.matcher(xpath).replaceAll("$1");
    }

    public Literal convertIfBoolean(FieldInfo fieldInfo, Literal literal) {
        if (fieldInfo.type instanceof BooleanType && literal instanceof IntegerLiteral) {
            long value = ((IntegerLiteral)literal).value;
            if (ZERO.equals(value)) {
                literal = fieldInfo.isTrueOrNullBoolean ? null : new BooleanLiteral(false);
            } else if (ONE.equals(value)) {
                literal = new BooleanLiteral(true);
            } else {
                throw new QueryParseException("Invalid boolean: " + value);
            }
        }
        return literal;
    }

    private QueryBuilder getQueryBuilder(FieldInfo fieldInfo, Function<String, QueryBuilder> constraintBuilder) {
        Matcher m = WILDCARD_SPLIT.matcher(fieldInfo.fullField);
        if (m.matches()) {
            String correlatedFieldPart = m.group(1);
            String fieldSuffix = m.group(2);
            if (fieldSuffix == null) {
                fieldSuffix = fieldInfo.queryField.substring(fieldInfo.queryField.lastIndexOf(47) + 1);
            }
            String path = fieldInfo.queryField.substring(0, fieldInfo.queryField.indexOf('/' + fieldSuffix));
            return new CorrelatedContainerQueryBuilder(path, correlatedFieldPart, constraintBuilder.apply(fieldSuffix));
        }
        String path = fieldInfo.queryField;
        if (fieldInfo.type != null && fieldInfo.type.isListType() && !fieldInfo.fullField.endsWith("*")) {
            path = path + '/' + MarkLogicHelper.buildItemNameFromPath(path);
        }
        return constraintBuilder.apply(path);
    }

    private static interface QueryBuilder {
        public StructuredQueryDefinition build(StructuredQueryBuilder var1);

        public void not();

        default public Object getLiteralValue(Literal literal) {
            Object result;
            if (literal instanceof BooleanLiteral) {
                result = ((BooleanLiteral)literal).value;
            } else if (literal instanceof DateLiteral) {
                result = ((DateLiteral)literal).value;
            } else if (literal instanceof DoubleLiteral) {
                result = ((DoubleLiteral)literal).value;
            } else if (literal instanceof IntegerLiteral) {
                result = ((IntegerLiteral)literal).value;
            } else if (literal instanceof StringLiteral) {
                result = ((StringLiteral)literal).value;
            } else {
                throw new QueryParseException("Unknown literal: " + literal);
            }
            return result;
        }

        default public String serializeName(String name) {
            return MarkLogicHelper.serializeKey(name);
        }
    }

    private static abstract class AbstractNamedQueryBuilder
    implements QueryBuilder {
        protected final String path;

        public AbstractNamedQueryBuilder(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public StructuredQueryDefinition build(StructuredQueryBuilder sqb) {
            String[] parts = this.path.split("/");
            StructuredQueryDefinition query = this.build(sqb, parts[parts.length - 1]);
            for (int i = parts.length - 2; i >= 0; --i) {
                query = sqb.containerQuery((StructuredQueryBuilder.ContainerIndex)sqb.element(this.serializeName(parts[i])), query);
            }
            return query;
        }

        protected abstract StructuredQueryDefinition build(StructuredQueryBuilder var1, String var2);
    }

    private static class CompositionQueryBuilder
    implements QueryBuilder {
        private final List<QueryBuilder> children;
        private boolean and;

        public CompositionQueryBuilder(List<QueryBuilder> children, boolean and) {
            this.children = children;
            this.and = and;
        }

        @Override
        public StructuredQueryDefinition build(StructuredQueryBuilder sqb) {
            if (this.children.size() == 1) {
                return this.children.get(0).build(sqb);
            }
            StructuredQueryDefinition[] childrenQueries = (StructuredQueryDefinition[])this.children.stream().map(child -> child.build(sqb)).toArray(StructuredQueryDefinition[]::new);
            if (this.and) {
                return sqb.and(childrenQueries);
            }
            return sqb.or(childrenQueries);
        }

        @Override
        public void not() {
            this.and = !this.and;
            this.children.forEach(QueryBuilder::not);
        }
    }

    private static class IsNullQueryBuilder
    extends AbstractNamedQueryBuilder {
        private boolean isNull;

        public IsNullQueryBuilder(String path, boolean isNull) {
            super(path);
            this.isNull = isNull;
        }

        @Override
        public StructuredQueryDefinition build(StructuredQueryBuilder sqb) {
            StructuredQueryDefinition query = super.build(sqb);
            if (this.isNull) {
                return sqb.not(query);
            }
            return query;
        }

        @Override
        protected StructuredQueryDefinition build(StructuredQueryBuilder sqb, String name) {
            String serializedName = this.serializeName(name);
            return sqb.containerQuery((StructuredQueryBuilder.ContainerIndex)sqb.element(serializedName), (StructuredQueryDefinition)sqb.and(new StructuredQueryDefinition[0]));
        }

        @Override
        public void not() {
            this.isNull = !this.isNull;
        }
    }

    private static class InQueryBuilder
    extends AbstractNamedQueryBuilder {
        private final LiteralList literals;
        private boolean in;

        public InQueryBuilder(String path, LiteralList literals, boolean in) {
            super(path);
            this.literals = literals;
            this.in = in;
        }

        @Override
        public StructuredQueryDefinition build(StructuredQueryBuilder sqb) {
            StructuredQueryDefinition query = super.build(sqb);
            if (this.in) {
                return query;
            }
            return sqb.not(query);
        }

        @Override
        protected StructuredQueryDefinition build(StructuredQueryBuilder sqb, String name) {
            String serializedName = this.serializeName(name);
            String[] serializedValues = (String[])this.literals.stream().map(this::getLiteralValue).map(MarkLogicStateSerializer::serializeValue).toArray(String[]::new);
            return sqb.value((StructuredQueryBuilder.TextIndex)sqb.element(serializedName), serializedValues);
        }

        @Override
        public void not() {
            this.in = !this.in;
        }
    }

    private static class RangeQueryBuilder
    extends AbstractNamedQueryBuilder {
        private StructuredQueryBuilder.Operator operator;
        private final Literal literal;

        public RangeQueryBuilder(String path, StructuredQueryBuilder.Operator operator, Literal literal) {
            super(path);
            this.operator = operator;
            this.literal = literal;
        }

        @Override
        protected StructuredQueryDefinition build(StructuredQueryBuilder sqb, String name) {
            String serializedName = this.serializeName(name);
            Object value = this.getLiteralValue(this.literal);
            String valueType = MarkLogicHelper.ElementType.getType(value.getClass()).getKey();
            String serializedValue = MarkLogicStateSerializer.serializeValue(value);
            return sqb.range((StructuredQueryBuilder.RangeIndex)sqb.element(serializedName), valueType, this.operator, new Object[]{serializedValue});
        }

        @Override
        public void not() {
            if (this.operator == StructuredQueryBuilder.Operator.LT) {
                this.operator = StructuredQueryBuilder.Operator.GE;
            } else if (this.operator == StructuredQueryBuilder.Operator.GT) {
                this.operator = StructuredQueryBuilder.Operator.LE;
            } else if (this.operator == StructuredQueryBuilder.Operator.LE) {
                this.operator = StructuredQueryBuilder.Operator.GT;
            } else if (this.operator == StructuredQueryBuilder.Operator.GE) {
                this.operator = StructuredQueryBuilder.Operator.LT;
            }
        }
    }

    private static class LikeQueryBuilder
    extends AbstractNamedQueryBuilder {
        private static final String CASE_INSENSITIVE = "case-insensitive";
        private static final String PUNCTUATION_SENSITIVE = "punctuation-sensitive";
        private static final String WHITESPACE_SENSITIVE = "whitespace-sensitive";
        private static final String WILDCARDED = "wildcarded";
        private static final String[] BASIC_OPTIONS = new String[]{"punctuation-sensitive", "wildcarded", "whitespace-sensitive"};
        private final StringLiteral literal;
        private boolean positive;
        private final boolean caseInsensitive;

        public LikeQueryBuilder(String path, StringLiteral literal, boolean positive, boolean caseInsensitive) {
            super(path);
            this.literal = literal;
            this.positive = positive;
            this.caseInsensitive = caseInsensitive;
        }

        @Override
        public StructuredQueryDefinition build(StructuredQueryBuilder sqb) {
            StructuredQueryDefinition query = super.build(sqb);
            if (this.positive) {
                return query;
            }
            return sqb.not(query);
        }

        @Override
        protected StructuredQueryDefinition build(StructuredQueryBuilder sqb, String name) {
            String serializedName = this.serializeName(name);
            String serializedValue = this.likeToMarkLogicWildcard(this.literal.value);
            String[] options = BASIC_OPTIONS;
            if (this.caseInsensitive) {
                options = Arrays.copyOf(options, options.length + 1);
                options[options.length - 1] = CASE_INSENSITIVE;
            }
            return sqb.value((StructuredQueryBuilder.TextIndex)sqb.element(serializedName), null, options, 1.0, new String[]{serializedValue});
        }

        @Override
        public void not() {
            this.positive = !this.positive;
        }

        private String likeToMarkLogicWildcard(String like) {
            StringBuilder mlValue = new StringBuilder();
            char[] chars = like.toCharArray();
            boolean escape = false;
            for (char c : chars) {
                boolean escapeNext = false;
                switch (c) {
                    case '%': {
                        if (escape) {
                            mlValue.append(c);
                            break;
                        }
                        mlValue.append("*");
                        break;
                    }
                    case '_': {
                        if (escape) {
                            mlValue.append(c);
                            break;
                        }
                        mlValue.append("?");
                        break;
                    }
                    case '\\': {
                        if (escape) {
                            mlValue.append("\\");
                            break;
                        }
                        escapeNext = true;
                        break;
                    }
                    case '*': 
                    case '?': {
                        mlValue.append("\\").append(c);
                        break;
                    }
                    default: {
                        mlValue.append(c);
                    }
                }
                escape = escapeNext;
            }
            return mlValue.toString();
        }
    }

    private static class EqualQueryBuilder
    extends AbstractNamedQueryBuilder {
        private final Literal literal;
        private boolean equal;

        public EqualQueryBuilder(String path, Literal literal, boolean equal) {
            super(path);
            this.literal = literal;
            this.equal = equal;
        }

        @Override
        public StructuredQueryDefinition build(StructuredQueryBuilder sqb) {
            StructuredQueryDefinition query = super.build(sqb);
            if (this.equal) {
                return query;
            }
            return sqb.not(query);
        }

        @Override
        protected StructuredQueryDefinition build(StructuredQueryBuilder sqb, String name) {
            String serializedName = this.serializeName(name);
            String serializedValue = MarkLogicStateSerializer.serializeValue(this.getLiteralValue(this.literal));
            return sqb.value((StructuredQueryBuilder.TextIndex)sqb.element(serializedName), new String[]{serializedValue});
        }

        @Override
        public void not() {
            this.equal = !this.equal;
        }
    }

    private static class CorrelatedContainerQueryBuilder
    extends AbstractNamedQueryBuilder {
        private final String correlatedPath;
        private final QueryBuilder child;

        public CorrelatedContainerQueryBuilder(String path, String correlatedPath, QueryBuilder child) {
            super(path);
            this.correlatedPath = correlatedPath;
            this.child = child;
        }

        @Override
        protected StructuredQueryDefinition build(StructuredQueryBuilder sqb, String name) {
            if (!this.correlatedPath.matches("^.*\\*\\d$")) {
                throw new QueryParseException("A correlated query builder might finish by a wildcard, path=" + this.path);
            }
            return sqb.containerQuery((StructuredQueryBuilder.ContainerIndex)sqb.element(this.serializeName(name)), this.child.build(sqb));
        }

        @Override
        public void not() {
            this.child.not();
        }

        public String getCorrelatedPath() {
            return this.correlatedPath;
        }

        public QueryBuilder getChild() {
            return this.child;
        }
    }

    private class FieldInfo {
        private final String prop;
        protected final String fullField;
        protected final String queryField;
        protected final Type type;
        protected final boolean isTrueOrNullBoolean;

        public FieldInfo(String prop, String field) {
            this(prop, field, DBSSession.getType((String)field), true);
        }

        public FieldInfo(String prop, String fullField, Type type, boolean isTrueOrNullBoolean) {
            this.prop = prop;
            this.fullField = fullField;
            ArrayList<String> fields = new ArrayList<String>();
            String previous = null;
            for (String element : fullField.split("/")) {
                if (element.startsWith("*")) {
                    if (previous == null) {
                        throw new QueryParseException("Invalid query, property can't starts by '*'");
                    }
                    fields.add(previous + "__item");
                } else {
                    fields.add(element);
                }
                previous = element;
            }
            this.queryField = String.join((CharSequence)"/", fields);
            this.type = type;
            this.isTrueOrNullBoolean = isTrueOrNullBoolean;
        }

        public boolean isBoolean() {
            return this.type instanceof BooleanType;
        }

        public boolean isMixinTypes() {
            return this.fullField.equals("ecm:mixinTypes");
        }

        public boolean hasWildcard() {
            return this.fullField.contains("*");
        }
    }
}

