/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.storage.marklogic;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.storage.marklogic.MarkLogicHelper;

final class MarkLogicStateDeserializer {
    private MarkLogicStateDeserializer() {
    }

    public static State deserialize(String s) {
        try {
            Document document = DocumentHelper.parseText((String)s);
            return MarkLogicStateDeserializer.deserializeState(document.getRootElement());
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private static State deserializeState(Element parent) {
        State state = new State(parent.nodeCount());
        Iterator elements = parent.elementIterator();
        while (elements.hasNext()) {
            Element element = (Element)elements.next();
            state.put(MarkLogicHelper.deserializeKey(element.getQualifiedName()), MarkLogicStateDeserializer.deserializeValue(element));
        }
        return state;
    }

    private static Serializable deserializeValue(Element element) {
        Object result;
        Iterator children = element.elementIterator();
        if (children.hasNext()) {
            Element first = (Element)children.next();
            result = first.getQualifiedName().endsWith("__item") ? MarkLogicStateDeserializer.deserializeList(element) : MarkLogicStateDeserializer.deserializeState(element);
        } else {
            MarkLogicHelper.ElementType type = MarkLogicStateDeserializer.getElementType(element).orElse(MarkLogicHelper.ElementType.STRING);
            String text = element.getText();
            switch (type) {
                case BOOLEAN: {
                    result = Boolean.parseBoolean(text);
                    break;
                }
                case DOUBLE: {
                    if (text.contains(".")) {
                        result = Double.parseDouble(text);
                        break;
                    }
                    result = Long.parseLong(text);
                    break;
                }
                case LONG: {
                    result = Long.parseLong(text);
                    break;
                }
                case CALENDAR: {
                    result = MarkLogicHelper.deserializeCalendar(text);
                    break;
                }
                default: {
                    result = text;
                    if (element.attribute("type") != null || !"".equals(result)) break;
                    result = null;
                }
            }
        }
        return result;
    }

    private static Serializable deserializeList(Element array) {
        Object[] result;
        List items = array.elements();
        if (items.isEmpty()) {
            result = null;
        } else {
            Element first = (Element)items.get(0);
            Optional<MarkLogicHelper.ElementType> type = MarkLogicStateDeserializer.getElementType(first);
            if (first.elements().isEmpty() && type.isPresent()) {
                ArrayList<Serializable> l = new ArrayList<Serializable>(items.size());
                for (Object element : items) {
                    l.add(MarkLogicStateDeserializer.deserializeValue((Element)element));
                }
                Class<?> scalarType = MarkLogicStateDeserializer.scalarTypeToSerializableClass(type.get(), first.getText());
                result = l.toArray((Object[])Array.newInstance(scalarType, l.size()));
            } else {
                Object[] l = new ArrayList(items.size());
                for (Object element : items) {
                    l.add(MarkLogicStateDeserializer.deserializeState((Element)element));
                }
                result = l;
            }
        }
        return result;
    }

    private static Optional<MarkLogicHelper.ElementType> getElementType(Element element) {
        return Optional.ofNullable(element.attributeValue("type")).map(MarkLogicHelper.ElementType::of);
    }

    private static Class<?> scalarTypeToSerializableClass(MarkLogicHelper.ElementType type, String content) {
        Class result;
        switch (type) {
            case BOOLEAN: {
                result = Boolean.class;
                break;
            }
            case DOUBLE: {
                if (content.contains(".")) {
                    result = Double.class;
                    break;
                }
                result = Long.class;
                break;
            }
            case LONG: {
                result = Long.class;
                break;
            }
            case CALENDAR: {
                result = Calendar.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }
}

