/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.storage.marklogic;

import com.google.common.base.Charsets;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.storage.marklogic.MarkLogicStateDeserializer;
import org.nuxeo.ecm.storage.marklogic.MarkLogicStateSerializer;

class StateHandle
extends BaseHandle<byte[], String>
implements ContentHandle<State>,
XMLReadHandle,
XMLWriteHandle {
    private State state;

    public StateHandle() {
        super.setFormat(Format.XML);
        this.setResendable(true);
    }

    public StateHandle(State state) {
        this();
        this.set(state);
    }

    public State get() {
        return this.state;
    }

    public void set(State state) {
        this.state = state;
    }

    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("StateHandle supports the XML format only");
        }
    }

    protected Class<byte[]> receiveAs() {
        return byte[].class;
    }

    protected void receiveContent(byte[] bytes) {
        if (bytes == null) {
            this.state = null;
            return;
        }
        String stateString = new String(bytes, Charsets.UTF_8);
        this.state = MarkLogicStateDeserializer.deserialize(stateString);
    }

    protected String sendContent() {
        if (this.state == null) {
            throw new IllegalStateException("No state to write");
        }
        return MarkLogicStateSerializer.serialize(this.state);
    }

    public String toString() {
        if (this.state == null) {
            return null;
        }
        return this.state.toString();
    }
}

