/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.storage.marklogic;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.admin.ServerConfigurationManager;
import com.marklogic.client.document.DocumentDescriptor;
import com.marklogic.client.document.DocumentMetadataPatchBuilder;
import com.marklogic.client.document.DocumentPage;
import com.marklogic.client.document.DocumentRecord;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.XMLDocumentManager;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentPatchHandle;
import com.marklogic.client.query.QueryDefinition;
import com.marklogic.client.query.RawQueryDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.resource.spi.ConnectionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSStateFlattener;
import org.nuxeo.ecm.storage.marklogic.MarkLogicLockUpdateBuilder;
import org.nuxeo.ecm.storage.marklogic.MarkLogicQueryBuilder;
import org.nuxeo.ecm.storage.marklogic.MarkLogicQuerySimpleBuilder;
import org.nuxeo.ecm.storage.marklogic.MarkLogicRepositoryDescriptor;
import org.nuxeo.ecm.storage.marklogic.MarkLogicStateUpdateBuilder;
import org.nuxeo.ecm.storage.marklogic.StateHandle;

public class MarkLogicRepository
extends DBSRepositoryBase {
    private static final Log log = LogFactory.getLog(MarkLogicRepository.class);
    private static final Function<String, String> ID_FORMATTER = id -> String.format("/%s.xml", id);
    public static final String DB_DEFAULT = "nuxeo";
    protected DatabaseClient markLogicClient;

    public MarkLogicRepository(ConnectionManager cm, MarkLogicRepositoryDescriptor descriptor) {
        super(cm, descriptor.name, (DBSRepositoryDescriptor)descriptor);
        this.markLogicClient = MarkLogicRepository.newMarkLogicClient(descriptor);
        this.initRepository();
    }

    public List<DBSRepositoryBase.IdType> getAllowedIdTypes() {
        return Collections.singletonList(DBSRepositoryBase.IdType.varchar);
    }

    public void shutdown() {
        super.shutdown();
        this.markLogicClient.release();
    }

    public static DatabaseClient newMarkLogicClient(MarkLogicRepositoryDescriptor descriptor) {
        String host = descriptor.host;
        Integer port = descriptor.port;
        if (StringUtils.isBlank((String)host) || port == null) {
            throw new NuxeoException("Missing <host> or <port> in MarkLogic repository descriptor");
        }
        String dbname = StringUtils.defaultIfBlank((String)descriptor.dbname, (String)DB_DEFAULT);
        String user = descriptor.user;
        String password = descriptor.password;
        if (StringUtils.isNotBlank((String)user) && StringUtils.isNotBlank((String)password)) {
            return DatabaseClientFactory.newClient((String)host, (int)port, (String)dbname, (String)user, (String)password, (DatabaseClientFactory.Authentication)DatabaseClientFactory.Authentication.DIGEST);
        }
        return DatabaseClientFactory.newClient((String)host, (int)port, (String)dbname);
    }

    protected void initRepository() {
        ServerConfigurationManager configMgr = this.markLogicClient.newServerConfigManager();
        configMgr.readConfiguration();
        configMgr.setUpdatePolicy(ServerConfigurationManager.UpdatePolicy.VERSION_OPTIONAL);
        configMgr.writeConfiguration();
        if (this.readState(this.getRootId()) == null) {
            this.initRoot();
        }
    }

    protected void initBlobsPaths() {
    }

    public String generateNewId() {
        return UUID.randomUUID().toString();
    }

    public State readState(String id) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: READ " + id));
        }
        try {
            return ((StateHandle)this.markLogicClient.newXMLDocumentManager().read(ID_FORMATTER.apply(id), (AbstractReadHandle)new StateHandle())).get();
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public List<State> readStates(List<String> ids) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: READ " + ids));
        }
        String[] markLogicIds = (String[])ids.stream().map(ID_FORMATTER).toArray(String[]::new);
        DocumentPage page = this.markLogicClient.newXMLDocumentManager().read(markLogicIds);
        return StreamSupport.stream(page.spliterator(), false).map(document -> ((StateHandle)document.getContent((AbstractReadHandle)new StateHandle())).get()).collect(Collectors.toList());
    }

    public void createState(State state) {
        String id = state.get((Object)"ecm:id").toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: CREATE " + id + ": " + state));
        }
        this.markLogicClient.newXMLDocumentManager().write(ID_FORMATTER.apply(id), (AbstractWriteHandle)new StateHandle(state));
    }

    public void createStates(List<State> states) {
        XMLDocumentManager docManager = this.markLogicClient.newXMLDocumentManager();
        DocumentWriteSet writeSet = docManager.newWriteSet();
        for (State state2 : states) {
            String id = state2.get((Object)"ecm:id").toString();
            writeSet.add(ID_FORMATTER.apply(id), (AbstractWriteHandle)new StateHandle(state2));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: CREATE [" + states.stream().map(state -> state.get((Object)"ecm:id").toString()).collect(Collectors.joining(", ")) + "]: " + states));
        }
        docManager.write(writeSet);
    }

    public void updateState(String id, State.StateDiff diff) {
        XMLDocumentManager docManager = this.markLogicClient.newXMLDocumentManager();
        DocumentMetadataPatchBuilder.PatchHandle patch = new MarkLogicStateUpdateBuilder(() -> ((XMLDocumentManager)docManager).newPatchBuilder()).apply(diff);
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: UPDATE " + id + ": " + patch.toString()));
        }
        docManager.patch(ID_FORMATTER.apply(id), (DocumentPatchHandle)patch);
    }

    public void deleteStates(Set<String> ids) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: DELETE " + ids));
        }
        String[] markLogicIds = (String[])ids.stream().map(ID_FORMATTER).toArray(String[]::new);
        this.markLogicClient.newXMLDocumentManager().delete(markLogicIds);
    }

    public State readChildState(String parentId, String name, Set<String> ignored) {
        RawQueryDefinition query = this.getChildQuery(parentId, name, ignored);
        return this.findOne(query);
    }

    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        RawQueryDefinition query = this.getChildQuery(parentId, name, ignored);
        return this.exist(query);
    }

    private RawQueryDefinition getChildQuery(String parentId, String name, Set<String> ignored) {
        return new MarkLogicQuerySimpleBuilder(this.markLogicClient.newQueryManager()).eq("ecm:parentId", parentId).eq("ecm:name", name).notIn("ecm:id", ignored).build();
    }

    public List<State> queryKeyValue(String key, Object value, Set<String> ignored) {
        return this.queryKeyValue(key, value, ignored, this::findAll);
    }

    public List<State> queryKeyValue(String key1, Object value1, String key2, Object value2, Set<String> ignored) {
        MarkLogicQuerySimpleBuilder builder = new MarkLogicQuerySimpleBuilder(this.markLogicClient.newQueryManager());
        builder.eq(key1, value1);
        builder.eq(key2, value2);
        builder.notIn("ecm:id", ignored);
        return this.findAll(builder.build());
    }

    public void queryKeyValueArray(String key, Object value, Set<String> ids, Map<String, String> proxyTargets, Map<String, Object[]> targetProxies) {
        MarkLogicQuerySimpleBuilder builder = new MarkLogicQuerySimpleBuilder(this.markLogicClient.newQueryManager());
        builder.eq(key, value);
        builder.select("ecm:id");
        builder.select("ecm:isProxy");
        builder.select("ecm:proxyTargetId");
        builder.select("ecm:proxyIds");
        RawQueryDefinition query = builder.build();
        if (log.isTraceEnabled()) {
            this.logQuery(query);
        }
        try (DocumentPage page = this.markLogicClient.newXMLDocumentManager().search((QueryDefinition)query, 0L);){
            for (DocumentRecord record : page) {
                Object[] proxyIds;
                State state = ((StateHandle)record.getContent((AbstractReadHandle)new StateHandle())).get();
                String id = (String)((Object)state.get((Object)"ecm:id"));
                ids.add(id);
                if (proxyTargets != null && Boolean.TRUE.equals(state.get((Object)"ecm:isProxy"))) {
                    String targetId = (String)((Object)state.get((Object)"ecm:proxyTargetId"));
                    proxyTargets.put(id, targetId);
                }
                if (targetProxies == null || (proxyIds = (Object[])state.get((Object)"ecm:proxyIds")) == null) continue;
                targetProxies.put(id, proxyIds);
            }
        }
    }

    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        return this.queryKeyValue(key, value, ignored, this::exist);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PartialList<Map<String, Serializable>> queryAndFetch(DBSExpressionEvaluator evaluator, OrderByClause orderByClause, boolean distinctDocuments, int limit, int offset, int countUpTo) {
        MarkLogicQueryBuilder builder = new MarkLogicQueryBuilder(this.markLogicClient.newQueryManager(), evaluator, orderByClause, distinctDocuments);
        RawQueryDefinition query = builder.buildQuery();
        boolean manualProjection = builder.doManualProjection();
        if (manualProjection) {
            evaluator.parse();
        }
        if (log.isTraceEnabled()) {
            this.logQuery(query, limit, offset);
        }
        XMLDocumentManager docManager = this.markLogicClient.newXMLDocumentManager();
        docManager.setPageLength(limit == 0 ? 50L : (long)limit);
        try (DocumentPage page = docManager.search((QueryDefinition)query, (long)offset);){
            long totalSize;
            ArrayList<Map> projections = new ArrayList<Map>((int)page.size());
            for (DocumentRecord record : page) {
                State state = ((StateHandle)record.getContent((AbstractReadHandle)new StateHandle())).get();
                if (manualProjection) {
                    projections.addAll(evaluator.matches(state));
                    continue;
                }
                projections.add(DBSStateFlattener.flatten((State)state));
            }
            if (countUpTo == -1) {
                totalSize = limit == 0 ? (long)projections.size() : page.getTotalSize();
            } else if (countUpTo == 0) {
                totalSize = -1L;
            } else {
                totalSize = limit == 0 ? (long)projections.size() : page.getTotalSize();
                if (totalSize > (long)countUpTo) {
                    totalSize = -2L;
                }
            }
            if (log.isTraceEnabled() && projections.size() != 0) {
                log.trace((Object)("MarkLogic:    -> " + projections.size()));
            }
            PartialList partialList = new PartialList(projections, totalSize);
            return partialList;
        }
        catch (FailedRequestException fre) {
            throw new QueryParseException("Request was rejected by server", (Throwable)fre);
        }
    }

    public Lock getLock(String id) {
        State state = this.readState(id);
        if (state == null) {
            throw new DocumentNotFoundException(id);
        }
        String owner = (String)((Object)state.get((Object)"ecm:lockOwner"));
        if (owner == null) {
            return null;
        }
        Calendar created = (Calendar)state.get((Object)"ecm:lockCreated");
        return new Lock(owner, created);
    }

    public Lock setLock(String id, Lock lock) {
        XMLDocumentManager docManager = this.markLogicClient.newXMLDocumentManager();
        DocumentDescriptor descriptor = docManager.newDescriptor(ID_FORMATTER.apply(id));
        try {
            State state;
            Optional<Lock> oldLock;
            if (log.isTraceEnabled()) {
                log.trace((Object)("MarkLogic: READ " + id));
            }
            if ((oldLock = this.extractLock(state = ((StateHandle)docManager.read(descriptor, (AbstractReadHandle)new StateHandle())).get())).isPresent()) {
                return oldLock.get();
            }
            DocumentMetadataPatchBuilder.PatchHandle patch = new MarkLogicLockUpdateBuilder(() -> ((XMLDocumentManager)docManager).newPatchBuilder()).set(lock);
            if (log.isTraceEnabled()) {
                log.trace((Object)("MarkLogic: UPDATE " + id + ": " + patch.toString()));
            }
            docManager.patch(descriptor, (DocumentPatchHandle)patch);
            return null;
        }
        catch (ResourceNotFoundException e) {
            throw new DocumentNotFoundException(id, (Throwable)e);
        }
        catch (FailedRequestException e) {
            return this.extractLock(this.readState(id)).orElseThrow(() -> new ConcurrentUpdateException("Lock " + id));
        }
    }

    public Lock removeLock(String id, String owner) {
        XMLDocumentManager docManager = this.markLogicClient.newXMLDocumentManager();
        DocumentDescriptor descriptor = docManager.newDescriptor(ID_FORMATTER.apply(id));
        try {
            State state;
            Optional<Lock> oldLockOpt;
            if (log.isTraceEnabled()) {
                log.trace((Object)("MarkLogic: READ " + id));
            }
            if ((oldLockOpt = this.extractLock(state = ((StateHandle)docManager.read(descriptor, (AbstractReadHandle)new StateHandle())).get())).isPresent()) {
                Lock oldLock = oldLockOpt.get();
                if (LockManager.canLockBeRemoved((String)oldLock.getOwner(), (String)owner)) {
                    DocumentMetadataPatchBuilder.PatchHandle patch = new MarkLogicLockUpdateBuilder(() -> ((XMLDocumentManager)docManager).newPatchBuilder()).delete();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("MarkLogic: UPDATE " + id + ": " + patch.toString()));
                    }
                    docManager.patch(descriptor, (DocumentPatchHandle)patch);
                    return oldLock;
                }
                return new Lock(oldLock.getOwner(), oldLock.getCreated(), true);
            }
            return null;
        }
        catch (ResourceNotFoundException e) {
            throw new DocumentNotFoundException(id, (Throwable)e);
        }
    }

    private Optional<Lock> extractLock(State state) {
        String owner = (String)((Object)state.get((Object)"ecm:lockOwner"));
        if (owner == null) {
            return Optional.empty();
        }
        Calendar oldCreated = (Calendar)state.get((Object)"ecm:lockCreated");
        return Optional.of(new Lock(owner, oldCreated));
    }

    public void closeLockManager() {
    }

    public void clearLockManagerCaches() {
    }

    public void markReferencedBinaries() {
        throw new IllegalStateException("Not implemented yet");
    }

    private <T> T queryKeyValue(String key, Object value, Set<String> ignored, Function<RawQueryDefinition, T> executor) {
        MarkLogicQuerySimpleBuilder builder = new MarkLogicQuerySimpleBuilder(this.markLogicClient.newQueryManager());
        builder.eq(key, value);
        builder.notIn("ecm:id", ignored);
        return executor.apply(builder.build());
    }

    private boolean exist(RawQueryDefinition query) {
        if (log.isTraceEnabled()) {
            this.logQuery(query);
        }
        return this.markLogicClient.newQueryManager().findOne((QueryDefinition)query) != null;
    }

    private State findOne(RawQueryDefinition query) {
        if (log.isTraceEnabled()) {
            this.logQuery(query);
        }
        XMLDocumentManager docManager = this.markLogicClient.newXMLDocumentManager();
        docManager.setPageLength(1L);
        try (DocumentPage page = docManager.search((QueryDefinition)query, 0L);){
            if (page.hasNext()) {
                State state = ((StateHandle)page.nextContent((AbstractReadHandle)new StateHandle())).get();
                return state;
            }
            State state = null;
            return state;
        }
    }

    private List<State> findAll(RawQueryDefinition query) {
        if (log.isTraceEnabled()) {
            this.logQuery(query);
        }
        return this.findAll(query, 1L);
    }

    private List<State> findAll(RawQueryDefinition query, long start) {
        try (DocumentPage page = this.markLogicClient.newXMLDocumentManager().search((QueryDefinition)query, start);){
            ArrayList<State> states = new ArrayList<State>((int)(page.getTotalSize() - start + 1L));
            for (DocumentRecord record : page) {
                states.add(((StateHandle)record.getContent((AbstractReadHandle)new StateHandle())).get());
            }
            if (page.hasNextPage()) {
                states.addAll(this.findAll(query, start + page.getPageSize()));
            }
            ArrayList<State> arrayList = states;
            return arrayList;
        }
    }

    private void logQuery(RawQueryDefinition query) {
        log.trace((Object)("MarkLogic: QUERY " + query.getHandle()));
    }

    private void logQuery(RawQueryDefinition query, int limit, int offset) {
        log.trace((Object)("MarkLogic: QUERY " + query.getHandle() + " OFFSET " + offset + " LIMIT " + limit));
    }
}

