/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.storage.marklogic;

import com.marklogic.client.document.DocumentMetadataPatchBuilder;
import com.marklogic.client.document.DocumentPatchBuilder;
import java.util.function.Supplier;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.storage.marklogic.MarkLogicHelper;
import org.nuxeo.ecm.storage.marklogic.MarkLogicStateSerializer;

class MarkLogicLockUpdateBuilder {
    private final Supplier<DocumentPatchBuilder> supplier;

    public MarkLogicLockUpdateBuilder(Supplier<DocumentPatchBuilder> supplier) {
        this.supplier = supplier;
    }

    public DocumentMetadataPatchBuilder.PatchHandle delete() {
        DocumentPatchBuilder patchBuilder = this.supplier.get();
        String documentPath = "/document/";
        patchBuilder.delete(documentPath + MarkLogicHelper.serializeKey("ecm:lockOwner"));
        patchBuilder.delete(documentPath + MarkLogicHelper.serializeKey("ecm:lockCreated"));
        return patchBuilder.build();
    }

    public DocumentMetadataPatchBuilder.PatchHandle set(Lock lock) {
        DocumentPatchBuilder patchBuilder = this.supplier.get();
        patchBuilder.insertFragment("/document", DocumentPatchBuilder.Position.LAST_CHILD, (Object)MarkLogicStateSerializer.serialize("ecm:lockOwner", lock.getOwner()).get().asXML());
        patchBuilder.insertFragment("/document", DocumentPatchBuilder.Position.LAST_CHILD, (Object)MarkLogicStateSerializer.serialize("ecm:lockCreated", lock.getCreated()).get().asXML());
        return patchBuilder.build();
    }
}

