/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.storage.marklogic;

import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.query.RawQueryDefinition;
import com.marklogic.client.query.RawStructuredQueryDefinition;
import com.marklogic.client.query.StructuredQueryBuilder;
import com.marklogic.client.query.StructuredQueryDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.storage.marklogic.MarkLogicHelper;
import org.nuxeo.ecm.storage.marklogic.MarkLogicStateSerializer;

class MarkLogicQuerySimpleBuilder {
    private final QueryManager queryManager;
    private final StructuredQueryBuilder sqb;
    private final List<StructuredQueryDefinition> queries;
    private final Set<String> selectKeys;

    public MarkLogicQuerySimpleBuilder(QueryManager queryManager) {
        this.queryManager = queryManager;
        this.sqb = queryManager.newStructuredQueryBuilder();
        this.queries = new ArrayList<StructuredQueryDefinition>();
        this.selectKeys = new HashSet<String>();
    }

    public MarkLogicQuerySimpleBuilder eq(String key, Object value) {
        String serializedKey = MarkLogicHelper.serializeKey(key);
        String serializedValue = MarkLogicStateSerializer.serializeValue(value);
        Type type = DBSSession.getType((String)key);
        StructuredQueryBuilder.Element element = type instanceof ListType ? this.sqb.element(serializedKey + "__item") : this.sqb.element(serializedKey);
        this.queries.add(this.sqb.value((StructuredQueryBuilder.TextIndex)element, new String[]{serializedValue}));
        return this;
    }

    public MarkLogicQuerySimpleBuilder notIn(String key, Collection<?> values) {
        if (!values.isEmpty()) {
            String serializedKey = MarkLogicHelper.serializeKey(key);
            String[] serializedValues = (String[])values.stream().map(MarkLogicStateSerializer::serializeValue).toArray(String[]::new);
            StructuredQueryDefinition inQuery = this.sqb.value((StructuredQueryBuilder.TextIndex)this.sqb.element(serializedKey), serializedValues);
            StructuredQueryBuilder.NotQuery notQuery = this.sqb.not(inQuery);
            this.queries.add((StructuredQueryDefinition)notQuery);
        }
        return this;
    }

    public MarkLogicQuerySimpleBuilder select(String key) {
        this.selectKeys.add(key);
        return this;
    }

    public RawQueryDefinition build() {
        RawStructuredQueryDefinition query = this.sqb.build(this.queries.toArray(new StructuredQueryDefinition[this.queries.size()]));
        String comboQuery = "<search xmlns=\"http://marklogic.com/appservices/search\">" + query.toString() + this.buildOptions() + "</search>";
        return this.queryManager.newRawCombinedQueryDefinition((StructureWriteHandle)new StringHandle(comboQuery));
    }

    private String buildOptions() {
        StringBuilder options = new StringBuilder("<options xmlns=\"http://marklogic.com/appservices/search\">");
        options.append("<transform-results apply=\"empty-snippet\"/>");
        if (!this.selectKeys.isEmpty()) {
            options.append(this.buildSelectPaths());
        }
        options.append("</options>");
        return options.toString();
    }

    private String buildSelectPaths() {
        StringBuilder extract = new StringBuilder("<extract-document-data selected=\"include-with-ancestors\">");
        for (String selectKey : this.selectKeys) {
            extract.append("<extract-path>");
            extract.append("/document").append('/').append(MarkLogicHelper.serializeKey(selectKey));
            extract.append("</extract-path>");
        }
        extract.append("</extract-document-data>");
        return extract.toString();
    }
}

