/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.xcc.spi.ConnectionProvider;
import com.marklogic.xcc.spi.ServerConnection;
import java.io.IOException;
import java.nio.channels.ByteChannel;

public class SimpleConnection
implements ServerConnection {
    private final ByteChannel channel;
    private final ConnectionProvider provider;
    private long timeoutTime = 0L;

    public SimpleConnection(ByteChannel channel, ConnectionProvider provider) {
        this.channel = channel;
        this.provider = provider;
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public ConnectionProvider provider() {
        return this.provider;
    }

    @Override
    public long getTimeoutMillis() {
        long millis = this.timeoutTime - System.currentTimeMillis();
        return millis < 0L ? 0L : millis;
    }

    @Override
    @Deprecated
    public void setTimeoutMillis(long timeoutMillis) {
        this.timeoutTime = System.currentTimeMillis() + timeoutMillis;
    }

    @Override
    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    @Override
    public void setTimeoutTime(long timeMillis) {
        this.timeoutTime = timeMillis;
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public String toString() {
        return "SimpleConnection [provider: " + this.provider.toString() + "]";
    }
}

