/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentbaseMetaData;
import com.marklogic.xcc.ModuleInvoke;
import com.marklogic.xcc.ModuleSpawn;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.UserCredentials;
import com.marklogic.xcc.Version;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.StreamingResultException;
import com.marklogic.xcc.exceptions.XQueryException;
import com.marklogic.xcc.impl.AdhocImpl;
import com.marklogic.xcc.impl.CBMetaDataImpl;
import com.marklogic.xcc.impl.ModuleImpl;
import com.marklogic.xcc.impl.RequestImpl;
import com.marklogic.xcc.impl.StreamingResultSequence;
import com.marklogic.xcc.impl.XAResourceImpl;
import com.marklogic.xcc.impl.handlers.ContentInsertController;
import com.marklogic.xcc.impl.handlers.EvalRequestController;
import com.marklogic.xcc.spi.ConnectionProvider;
import com.marklogic.xcc.spi.SingleHostAddress;
import com.marklogic.xcc.types.XSDecimal;
import com.marklogic.xcc.types.XSInteger;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

public class SessionImpl
implements Session {
    private final Set<StreamingResultSequence> activeResultSeqs;
    private final ContentSource contentSource;
    private final ConnectionProvider provider;
    private final UserCredentials credentials;
    private final String contentBase;
    private XAResourceImpl xaResource = null;
    private Logger logger = null;
    private RequestOptions defaultOptions = new RequestOptions();
    String sessionID = null;
    String txnID = null;
    private Session.TransactionMode txnMode;
    private int timeout = 0;
    private boolean closed = false;
    boolean inXATxn = false;
    private Object userObject = null;
    private String serverVersion = null;
    private Throwable created = new Throwable();
    private boolean compatibleTxnMode = System.getProperty("xcc.txn.compatible", "false").equals("true");
    private boolean txnModeChanged = false;
    private static final boolean envCompactSequencesEnabled = System.getProperty("xcc.compact.sequences", "true").equals("true");
    private boolean compactSequencesEnabled = envCompactSequencesEnabled;
    private static final String agentString = "Java/" + System.getProperty("java.version") + " MarkLogicXCC/" + Version.getVersionMajor() + "." + Version.getVersionMinor() + "-" + Version.getVersionPatch();

    public boolean isCompactSequencesEnabled() {
        return this.compactSequencesEnabled;
    }

    public void setCompactSequencesEnabled(boolean compactSequencesEnabled) {
        this.compactSequencesEnabled = compactSequencesEnabled;
    }

    public SessionImpl(ContentSource contentSource, ConnectionProvider connectionProvider, UserCredentials credentials, String contentBase) {
        this.contentSource = contentSource;
        this.provider = connectionProvider;
        this.credentials = credentials;
        this.contentBase = contentBase;
        this.activeResultSeqs = Collections.synchronizedSet(new HashSet());
    }

    public SessionImpl clone() {
        return new SessionImpl(this.contentSource, this.provider, this.credentials, this.contentBase);
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public UserCredentials getUserCredentials() {
        return this.credentials;
    }

    @Override
    public String getContentBaseName() {
        return this.contentBase;
    }

    @Override
    public ContentSource getContentSource() {
        return this.contentSource;
    }

    @Override
    public XAResource getXAResource() {
        if (this.xaResource == null) {
            this.xaResource = new XAResourceImpl(this);
        }
        return this.xaResource;
    }

    @Override
    public void setTransactionMode(Session.TransactionMode mode) {
        if (this.getTxnID() != null) {
            this.throwIllegalState("Cannot call setTransactionMode() when there is an active transaction");
        }
        this.txnMode = mode;
        this.txnModeChanged = true;
    }

    @Override
    public Session.TransactionMode getTransactionMode() {
        return this.txnMode;
    }

    @Override
    public void setTransactionTimeout(int seconds) throws RequestException {
        if (this.getTxnID() != null) {
            this.submitRequestInternal(new AdhocImpl(this, "xquery version '1.0-ml';\nxdmp:set-transaction-time-limit(" + seconds + ")", null)).close();
        }
        this.timeout = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionTimeout() throws RequestException {
        if (this.getTxnID() != null) {
            ResultSequence rs = this.submitRequestInternal(new AdhocImpl(this, "xquery version '1.0-ml';\nxdmp:host-status(xdmp:host())//*:transaction[*:transaction-id eq xdmp:transaction()]/*:time-limit/string()", null));
            try {
                this.timeout = Integer.parseInt(rs.next().asString());
            }
            finally {
                rs.close();
            }
        }
        return this.timeout;
    }

    public int getCachedTransactionTimeout() {
        return this.timeout;
    }

    @Override
    public void commit() throws RequestException {
        this.assertSessionOpen();
        if (this.getTxnID() == null) {
            this.throwIllegalState("Cannot commit without an active transaction");
        }
        this.submitRequestInternal(new AdhocImpl(this, "xquery version '1.0-ml'; xdmp:commit()", null)).close();
    }

    @Override
    public void rollback() throws RequestException {
        this.assertSessionOpen();
        if (this.getTxnID() != null) {
            this.submitRequestInternal(new AdhocImpl(this, "xquery version '1.0-ml'; xdmp:rollback()", null)).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        boolean doRollback = false;
        Object object = this;
        synchronized (object) {
            doRollback = !this.inXATxn && this.txnID != null;
        }
        if (doRollback) {
            try {
                this.rollback();
            }
            catch (XQueryException e) {
                if (!e.equals("XDMP-NOTXN")) {
                    this.getLogger().log(Level.WARNING, "Exception rolling back during Session.close()", e);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Exception rolling back during Session.close()", e);
            }
        }
        this.closed = true;
        object = this.activeResultSeqs;
        synchronized (object) {
            Iterator<StreamingResultSequence> it = this.activeResultSeqs.iterator();
            while (it.hasNext()) {
                StreamingResultSequence rs = it.next();
                it.remove();
                try {
                    rs.close();
                }
                catch (StreamingResultException e) {
                    this.getLogger().log(Level.WARNING, "Exception closing streaming result sequence.", e);
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void finalize() {
        try {
            if (!this.closed) {
                if (this.getTxnID() != null) {
                    this.getLogger().log(Level.SEVERE, "Destructing Session object with open transaction " + this.getTxnID() + ": ", this.created);
                }
                this.close();
            }
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Exception during SessionImpl.finalize()", t);
        }
    }

    @Override
    public ModuleInvoke newModuleInvoke(String moduleUri, RequestOptions options) {
        this.assertSessionOpen();
        return new ModuleImpl(this, moduleUri, options, false);
    }

    @Override
    public ModuleInvoke newModuleInvoke(String moduleUri) {
        return this.newModuleInvoke(moduleUri, null);
    }

    @Override
    public ModuleSpawn newModuleSpawn(String moduleUri, RequestOptions options) {
        this.assertSessionOpen();
        return new ModuleImpl(this, moduleUri, options, true);
    }

    @Override
    public ModuleSpawn newModuleSpawn(String moduleUri) {
        return this.newModuleSpawn(moduleUri, null);
    }

    @Override
    public AdhocQuery newAdhocQuery(String queryText, RequestOptions options) {
        this.assertSessionOpen();
        return new AdhocImpl(this, queryText, options);
    }

    @Override
    public AdhocQuery newAdhocQuery(String queryText) {
        this.assertSessionOpen();
        return this.newAdhocQuery(queryText, null);
    }

    @Override
    public void insertContent(Content[] contents) throws RequestException {
        this.insertContent(contents, false);
    }

    @Override
    public List<RequestException> insertContentCollectErrors(Content[] contents) throws RequestException {
        return this.insertContent(contents, true);
    }

    public List<RequestException> insertContent(Content[] contents, boolean collectErrors) throws RequestException {
        this.assertSessionOpen();
        AdhocQuery request = this.newAdhocQuery("()");
        RequestOptions sessionOptions = this.getDefaultRequestOptions();
        if (sessionOptions.getMaxAutoRetry() == -1 || sessionOptions.getAutoRetryDelayMillis() == -1) {
            RequestOptions options = new RequestOptions();
            if (sessionOptions.getMaxAutoRetry() == -1) {
                options.setMaxAutoRetry(64);
            }
            if (sessionOptions.getAutoRetryDelayMillis() == -1) {
                options.setAutoRetryDelayMillis(125);
            }
            request.setOptions(options);
        }
        this.assertNoTimeStamp(request);
        this.assertNonEmptyUris(request, contents);
        if (this.compatibleTxnMode) {
            this.createTransaction(request);
        }
        ContentInsertController controller = new ContentInsertController(contents, this.txnMode, collectErrors);
        controller.runRequest(this.provider, request, this.getLogger());
        return controller.getErrors();
    }

    public boolean isInCompatibleMode() {
        return this.compatibleTxnMode;
    }

    public void setCompatibleMode(boolean mode) {
        this.compatibleTxnMode = mode;
    }

    private void createTransaction(Request request) throws RequestException {
        if (this.getTxnID() == null && this.txnMode != null && this.txnMode != Session.TransactionMode.AUTO || this.txnModeChanged) {
            RequestOptions options = new RequestOptions();
            RequestOptions reqOpt = request.getOptions();
            options.setAutoRetryDelayMillis(reqOpt.getAutoRetryDelayMillis());
            options.setMaxAutoRetry(reqOpt.getMaxAutoRetry());
            options.setRequestName(reqOpt.getRequestName());
            options.setRequestTimeLimit(reqOpt.getRequestTimeLimit());
            options.setTimeoutMillis(reqOpt.getTimeoutMillis());
            options.setTimeZone(reqOpt.getTimeZone());
            this.submitRequestInternal(new AdhocImpl(this, "xquery version '1.0-ml';\ndeclare option xdmp:transaction-mode '" + this.serializeTransactionMode(this.txnMode) + "'; " + (this.timeout == 0 || this.getTxnID() != null ? "()" : "xdmp:set-transaction-time-limit(" + this.timeout + ")"), options)).close();
        }
    }

    private String serializeTransactionMode(Session.TransactionMode mode) {
        switch (mode) {
            case AUTO: {
                return "auto";
            }
            case QUERY: {
                return "query";
            }
            case UPDATE: {
                return "update";
            }
            case UPDATE_AUTO_COMMIT: {
                this.throwIllegalArg("Transaction mode UPDATE_AUTO_COMMIT is not supported when xcc.txn.compatible is set to true", this.getLogger());
            }
        }
        this.throwIllegalArg("Unknown transaction mode: should be TransactionMode.AUTO, TransactionMode.QUERY, TransactionMode.UPDATE", this.getLogger());
        return null;
    }

    private void assertNonEmptyUris(Request request, Content[] contents) throws RequestException {
        for (int i = 0; i < contents.length; ++i) {
            String uri = contents[i].getUri();
            if (uri != null && uri.length() != 0) continue;
            throw new RequestException("Content insertion with empty URI is not allowed", request);
        }
    }

    private void assertNoTimeStamp(Request request) throws RequestException {
        RequestOptions options = this.getEffectiveRequestOptions();
        if (options.getEffectivePointInTime() == null) {
            return;
        }
        if (options.getEffectivePointInTime().equals(BigInteger.ZERO)) {
            return;
        }
        throw new RequestException("Content insertion not allowed with non-zero Point-In-Time", request);
    }

    @Override
    public void insertContent(Content content) throws RequestException {
        this.insertContent(new Content[]{content});
    }

    @Override
    public ContentbaseMetaData getContentbaseMetaData() {
        return new CBMetaDataImpl(this);
    }

    @Override
    public void setDefaultRequestOptions(RequestOptions options) {
        this.defaultOptions = options == null ? new RequestOptions() : options;
    }

    @Override
    public RequestOptions getDefaultRequestOptions() {
        return this.defaultOptions;
    }

    @Override
    public Logger getLogger() {
        return this.logger == null ? this.contentSource.getDefaultLogger() : this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ResultSequence submitRequest(Request request) throws RequestException {
        this.assertSessionOpen();
        if (request.getSession() != this || !(request instanceof RequestImpl)) {
            this.throwIllegalArg("Request object was not created by this session", this.getLogger());
        }
        if (this.compatibleTxnMode) {
            this.createTransaction(request);
        }
        return this.submitRequestInternal((RequestImpl)request);
    }

    ResultSequence submitRequestInternal(RequestImpl req) throws RequestException {
        EvalRequestController controller = new EvalRequestController(req.serverPath(), req.encodedQueryString(this.getLogger()));
        return controller.runRequest(this.provider, req, this.getLogger());
    }

    @Override
    public BigInteger getCurrentServerPointInTime() throws RequestException {
        AdhocQuery pitReq = this.newAdhocQuery("xdmp:request-timestamp()");
        ResultSequence rs = this.submitRequest(pitReq);
        ResultItem item = rs.next();
        BigInteger stamp = null;
        stamp = item.getItem() instanceof XSDecimal ? ((XSDecimal)item.getItem()).asBigDecimal().toBigInteger() : ((XSInteger)item.getItem()).asBigInteger();
        rs.close();
        return stamp;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public URI getConnectionUri() {
        if (!(this.provider instanceof SingleHostAddress)) {
            return null;
        }
        InetSocketAddress addr = ((SingleHostAddress)((Object)this.provider)).getAddress();
        try {
            return new URI("xcc", this.getUserCredentials().getUserName() + ":xxxx", addr.getHostName(), addr.getPort(), this.getContentBaseName() == null ? null : "/" + this.getContentBaseName(), null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void registerResultSequence(StreamingResultSequence resultSequence) {
        this.activeResultSeqs.add(resultSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterResultSequence(StreamingResultSequence resultSequence) {
        Set<StreamingResultSequence> set = this.activeResultSeqs;
        synchronized (set) {
            if (this.activeResultSeqs.contains(resultSequence)) {
                this.activeResultSeqs.remove(resultSequence);
            }
        }
    }

    @Override
    public RequestOptions getEffectiveRequestOptions() {
        RequestOptions eff = new RequestOptions();
        RequestOptions ses = this.getDefaultRequestOptions();
        eff.applyEffectiveValues(new RequestOptions[]{ses});
        return eff;
    }

    public ConnectionProvider getProvider() {
        return this.provider;
    }

    public String userAgentString() {
        return agentString;
    }

    public synchronized String getSessionID() {
        return this.sessionID;
    }

    public synchronized String getTxnID() {
        return this.txnID;
    }

    public String getAcceptedContentTypes() {
        if (this.compactSequencesEnabled) {
            return "application/vnd.marklogic.sequence, */*";
        }
        return "*/*";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readCookieValues(HttpChannel http) throws IOException {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            String txn;
            String session = http.getReponseCookieValue("SessionID");
            if (session != null) {
                this.sessionID = session;
            }
            if ((txn = http.getReponseCookieValue("TxnID")) != null) {
                this.txnID = txn.equals("null") ? null : txn;
            }
        }
        String mode = http.getReponseCookieValue("TxnMode");
        Session.TransactionMode newMode = null;
        if (mode != null) {
            newMode = this.parseTransactionMode(mode);
        }
        if (this.txnMode != null && this.txnMode != Session.TransactionMode.AUTO && !this.isTxnCompatible()) {
            this.compatibleTxnMode = true;
            return false;
        }
        if (mode != null) {
            this.txnMode = newMode;
            this.txnModeChanged = false;
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Receiving SessionID: " + this.sessionID + ", TxnID: " + this.txnID + ", TxnMode: " + (Object)((Object)this.txnMode));
        }
        return true;
    }

    private boolean isTxnCompatible() {
        if (this.compatibleTxnMode) {
            return true;
        }
        if (this.serverVersion == null) {
            return true;
        }
        String[] vers = this.serverVersion.split("\\.");
        if (vers.length < 2) {
            return false;
        }
        int majorVer = Integer.parseInt(vers[0]);
        if (majorVer > 8) {
            return true;
        }
        if (majorVer < 8) {
            return false;
        }
        return !this.serverVersion.startsWith("8.0-1");
    }

    private Session.TransactionMode parseTransactionMode(String val) {
        if (val.equals("auto")) {
            return Session.TransactionMode.AUTO;
        }
        if (val.equals("query")) {
            return Session.TransactionMode.QUERY;
        }
        if (val.equals("update")) {
            return Session.TransactionMode.UPDATE;
        }
        if (val.equals("update-auto-commit")) {
            return Session.TransactionMode.UPDATE_AUTO_COMMIT;
        }
        return Session.TransactionMode.AUTO;
    }

    private void assertSessionOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    private void throwIllegalArg(String msg, Logger logger) {
        logger.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    void throwIllegalState(String msg) {
        this.getLogger().severe(msg);
        throw new IllegalStateException(msg);
    }

    public String toString() {
        return this.credentials.toString() + ", cb=" + (this.contentBase == null ? "{default}" : this.contentBase) + " [ContentSource: " + this.contentSource.toString() + "]";
    }

    @Override
    public int getCachedTxnTimeout() {
        return this.timeout;
    }
}

