/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.marklogic;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

class MarkLogicSchemaManager {
    private final SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);

    public Field computeField(String fullName, String element) {
        Field field = this.schemaManager.getField(element);
        if (field == null) {
            Schema schema;
            if (element.indexOf(58) > -1) {
                throw new QueryParseException("No such property: " + fullName);
            }
            Schema[] schemaArray = this.schemaManager.getSchemas();
            int n = schemaArray.length;
            for (int i = 0; !(i >= n || (schema = schemaArray[i]) != null && StringUtils.isBlank((String)schema.getNamespace().prefix) && (field = schema.getField(element)) != null); ++i) {
            }
            if (field == null) {
                throw new QueryParseException("No such property: " + fullName);
            }
        }
        return field;
    }

    public List<String> getDocumentTypes() {
        return Stream.of(this.schemaManager.getDocumentTypes()).map(Type::getName).collect(Collectors.toList());
    }

    public Set<String> getNoPerDocumentQueryFacets() {
        return this.schemaManager.getNoPerDocumentQueryFacets();
    }

    public Set<String> getMixinDocumentTypes(String mixin) {
        Set types = this.schemaManager.getDocumentTypeNamesForFacet(mixin);
        return types == null ? Collections.emptySet() : types;
    }
}

