/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.marklogic;

import com.google.common.base.Strings;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.ModuleInvoke;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.SecurityOptions;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.types.XdmItem;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLContext;
import javax.resource.spi.ConnectionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CursorResult;
import org.nuxeo.ecm.core.api.CursorService;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSStateFlattener;
import org.nuxeo.ecm.core.storage.dbs.DBSTransactionState;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicCursorResult;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicHelper;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicQueryBuilder;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicQuerySimpleBuilder;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicRangeElementIndexDescriptor;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicSchemaManager;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicStateDeserializer;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicStateSerializer;
import org.nuxeo.runtime.api.Framework;

public class MarkLogicRepository
extends DBSRepositoryBase {
    private static final Log log = LogFactory.getLog(MarkLogicRepository.class);
    private static final Function<String, String> ID_FORMATTER = id -> String.format("/%s.xml", id);
    public static final String DB_DEFAULT = "nuxeo";
    protected ContentSource xccContentSource;
    protected long sequenceLastValue;
    protected final List<MarkLogicRangeElementIndexDescriptor> rangeElementIndexes;
    protected final CursorService<ResultSequence, ResultItem> cursorService = new CursorService();
    protected List<String> binaryPaths;

    public MarkLogicRepository(ConnectionManager cm, MarkLogicRepositoryDescriptor descriptor) {
        super(cm, descriptor.name, (DBSRepositoryDescriptor)descriptor);
        this.xccContentSource = MarkLogicRepository.newMarkLogicContentSource(descriptor);
        this.rangeElementIndexes = descriptor.rangeElementIndexes.stream().map(MarkLogicRangeElementIndexDescriptor::new).collect(Collectors.toList());
        this.initRepository();
    }

    public List<DBSRepositoryBase.IdType> getAllowedIdTypes() {
        return Collections.singletonList(DBSRepositoryBase.IdType.varchar);
    }

    public static ContentSource newMarkLogicContentSource(MarkLogicRepositoryDescriptor descriptor) {
        String host = descriptor.host;
        Integer port = descriptor.port;
        if (StringUtils.isBlank((String)host) || port == null) {
            throw new NuxeoException("Missing <host> or <port> in MarkLogic repository descriptor");
        }
        String dbname = StringUtils.defaultIfBlank((String)descriptor.dbname, (String)DB_DEFAULT);
        String user = descriptor.user;
        String password = descriptor.password;
        SecurityOptions securityOptions = descriptor.sslEnabled ? MarkLogicRepository.newTrustOptions() : null;
        return ContentSourceFactory.newContentSource((String)host, (int)port, (String)user, (String)password, (String)dbname, (SecurityOptions)securityOptions);
    }

    protected static SecurityOptions newTrustOptions() {
        try {
            SSLContext sslContext = SSLContext.getDefault();
            return new SecurityOptions(sslContext);
        }
        catch (GeneralSecurityException e) {
            throw new NuxeoException("Unable to initialize Security options for MarkLogic connection.", (Throwable)e);
        }
    }

    protected void initRepository() {
        if (this.readState(this.getRootId()) == null) {
            this.initRoot();
        }
    }

    public String generateNewId() {
        return UUID.randomUUID().toString();
    }

    protected synchronized Long getNextSequenceId() {
        ++this.sequenceLastValue;
        return this.sequenceLastValue;
    }

    public void shutdown() {
        super.shutdown();
        this.cursorService.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public State readState(String id) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: READ " + id));
        }
        try (Session session = this.xccContentSource.newSession();){
            String query = "fn:doc('" + ID_FORMATTER.apply(id) + "')";
            AdhocQuery request = session.newAdhocQuery(query);
            ResultSequence rs = session.submitRequest((Request)request);
            if (rs.hasNext()) {
                State state = MarkLogicStateDeserializer.deserialize(rs.asStrings()[0]);
                return state;
            }
            State state = null;
            return state;
        }
        catch (RequestException e) {
            throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<State> readStates(List<String> ids) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: READ " + ids));
        }
        try (Session session = this.xccContentSource.newSession();){
            String query = ids.stream().map(ID_FORMATTER).map(id -> "'" + id + "'").collect(Collectors.joining(",", "fn:doc((", "))"));
            AdhocQuery request = session.newAdhocQuery(query);
            ResultSequence rs = session.submitRequest((Request)request);
            List<State> list = Arrays.stream(rs.asStrings()).map(MarkLogicStateDeserializer::deserialize).collect(Collectors.toList());
            return list;
        }
        catch (RequestException e) {
            throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
        }
    }

    public void createState(State state) {
        String id = state.get((Object)"ecm:id").toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: CREATE " + id + ": " + state));
        }
        try (Session session = this.xccContentSource.newSession();){
            session.insertContent(this.convert(state));
        }
        catch (RequestException e) {
            throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
        }
    }

    public void createStates(List<State> states) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: CREATE [" + states.stream().map(state -> state.get((Object)"ecm:id").toString()).collect(Collectors.joining(", ")) + "]: " + states));
        }
        try (Session session = this.xccContentSource.newSession();){
            Content[] contents = (Content[])states.stream().map(this::convert).toArray(Content[]::new);
            session.insertContent(contents);
        }
        catch (RequestException e) {
            throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
        }
    }

    private Content convert(State state) {
        String id = state.get((Object)"ecm:id").toString();
        return ContentFactory.newContent((String)ID_FORMATTER.apply(id), (String)MarkLogicStateSerializer.serialize(state), null);
    }

    public void updateState(String id, State.StateDiff diff, DBSTransactionState.ChangeTokenUpdater changeTokenUpdater) {
        String patch = MarkLogicStateSerializer.serialize((State)diff);
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: UPDATE " + id + ": " + patch));
        }
        try (Session session = this.xccContentSource.newSession();){
            ModuleInvoke request = session.newModuleInvoke("/ext/nuxeo/patch.xqy");
            request.setNewStringVariable("uri", ID_FORMATTER.apply(id));
            request.setNewStringVariable("patch-string", patch);
            session.submitRequest((Request)request);
        }
        catch (RequestException e) {
            throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
        }
    }

    public void deleteStates(Set<String> ids) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: DELETE " + ids));
        }
        try (Session session = this.xccContentSource.newSession();){
            String query = ids.stream().map(ID_FORMATTER).map(id -> "'" + id + "'").collect(Collectors.joining(",", "xdmp:document-delete((", "))"));
            AdhocQuery request = session.newAdhocQuery(query);
            session.submitRequest((Request)request);
        }
        catch (RequestException e) {
            throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
        }
    }

    public State readChildState(String parentId, String name, Set<String> ignored) {
        String query = this.getChildQuery(parentId, name, ignored);
        return this.findOne(query);
    }

    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        String query = this.getChildQuery(parentId, name, ignored);
        return this.exist(query);
    }

    private String getChildQuery(String parentId, String name, Set<String> ignored) {
        return new MarkLogicQuerySimpleBuilder(this.rangeElementIndexes).eq("ecm:parentId", parentId).eq("ecm:name", name).notIn("ecm:id", ignored).build();
    }

    public List<State> queryKeyValue(String key, Object value, Set<String> ignored) {
        MarkLogicQuerySimpleBuilder builder = new MarkLogicQuerySimpleBuilder(this.rangeElementIndexes);
        builder.eq(key, value);
        builder.notIn("ecm:id", ignored);
        try (Stream<State> states = this.findAll(builder.build(), new String[0]);){
            List<State> list = states.collect(Collectors.toList());
            return list;
        }
    }

    public List<State> queryKeyValue(String key1, Object value1, String key2, Object value2, Set<String> ignored) {
        MarkLogicQuerySimpleBuilder builder = new MarkLogicQuerySimpleBuilder(this.rangeElementIndexes);
        builder.eq(key1, value1);
        builder.eq(key2, value2);
        builder.notIn("ecm:id", ignored);
        try (Stream<State> states = this.findAll(builder.build(), new String[0]);){
            List<State> list = states.collect(Collectors.toList());
            return list;
        }
    }

    public void queryKeyValueArray(String key, Object value, Set<String> ids, Map<String, String> proxyTargets, Map<String, Object[]> targetProxies) {
        MarkLogicQuerySimpleBuilder builder = new MarkLogicQuerySimpleBuilder(this.rangeElementIndexes);
        builder.eq(key, value);
        try (Stream<State> states = this.findAll(builder.build(), "ecm:id", "ecm:isProxy", "ecm:proxyTargetId", "ecm:proxyIds");){
            states.forEach(state -> {
                Object[] proxyIds;
                String id = (String)((Object)state.get((Object)"ecm:id"));
                ids.add(id);
                if (proxyTargets != null && Boolean.TRUE.equals(state.get((Object)"ecm:isProxy"))) {
                    String targetId = (String)((Object)state.get((Object)"ecm:proxyTargetId"));
                    proxyTargets.put(id, targetId);
                }
                if (targetProxies != null && (proxyIds = (Object[])state.get((Object)"ecm:proxyIds")) != null) {
                    targetProxies.put(id, proxyIds);
                }
            });
        }
    }

    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        MarkLogicQuerySimpleBuilder builder = new MarkLogicQuerySimpleBuilder(this.rangeElementIndexes);
        builder.eq(key, value);
        builder.notIn("ecm:id", ignored);
        return this.exist(builder.build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PartialList<Map<String, Serializable>> queryAndFetch(DBSExpressionEvaluator evaluator, OrderByClause orderByClause, boolean distinctDocuments, int limit, int offset, int countUpTo) {
        MarkLogicQueryBuilder builder = new MarkLogicQueryBuilder(evaluator, orderByClause, distinctDocuments, this.rangeElementIndexes);
        MarkLogicQueryBuilder.MarkLogicQuery query = builder.buildQuery();
        boolean manualProjection = builder.doManualProjection();
        if (manualProjection) {
            evaluator.parse();
        }
        String searchQuery = query.getSearchQuery(limit, offset);
        if (log.isTraceEnabled()) {
            this.logQuery(searchQuery);
        }
        try (Session session = this.xccContentSource.newSession();){
            ResultSequence countRs;
            long totalSize;
            AdhocQuery request = session.newAdhocQuery(searchQuery);
            ResultSequence rs = session.submitRequest((Request)request);
            ArrayList<Map> projections = new ArrayList<Map>(limit);
            for (String rsItem : rs.asStrings()) {
                State state = MarkLogicStateDeserializer.deserialize(rsItem);
                if (manualProjection) {
                    projections.addAll(evaluator.matches(state));
                    continue;
                }
                projections.add(DBSStateFlattener.flatten((State)state));
            }
            if (countUpTo == -1) {
                if (limit == 0) {
                    totalSize = projections.size();
                } else {
                    AdhocQuery countRequest = session.newAdhocQuery(query.getCountQuery());
                    countRs = session.submitRequest((Request)countRequest);
                    totalSize = Long.parseLong(countRs.asStrings()[0]);
                }
            } else if (countUpTo == 0) {
                totalSize = -1L;
            } else {
                if (limit == 0) {
                    totalSize = projections.size();
                } else {
                    AdhocQuery countRequest = session.newAdhocQuery(query.getCountQuery(countUpTo + 1));
                    countRs = session.submitRequest((Request)countRequest);
                    totalSize = Long.parseLong(countRs.asStrings()[0]);
                }
                if (totalSize > (long)countUpTo) {
                    totalSize = -2L;
                }
            }
            if (log.isTraceEnabled() && projections.size() != 0) {
                log.trace((Object)("MarkLogic:    -> " + projections.size()));
            }
            PartialList partialList = new PartialList(projections, totalSize);
            return partialList;
        }
        catch (RequestException e) {
            throw new NuxeoException("An exception happened during xcc call when executing '" + evaluator + "'", (Throwable)e);
        }
    }

    public ScrollResult scroll(DBSExpressionEvaluator evaluator, int batchSize, int keepAliveInSecond) {
        this.cursorService.checkForTimedOutScroll();
        MarkLogicQueryBuilder builder = new MarkLogicQueryBuilder(evaluator, null, false, this.rangeElementIndexes);
        String query = builder.buildQuery().getSearchQuery();
        try {
            Session session = this.xccContentSource.newSession();
            RequestOptions options = new RequestOptions();
            options.setCacheResult(false);
            AdhocQuery request = session.newAdhocQuery(query, options);
            ResultSequence rs = session.submitRequest((Request)request);
            String scrollId = this.cursorService.registerCursorResult((CursorResult)new MarkLogicCursorResult(session, rs, batchSize, keepAliveInSecond));
            return this.scroll(scrollId);
        }
        catch (RequestException e) {
            throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
        }
    }

    public ScrollResult scroll(String scrollId) {
        return this.cursorService.scroll(scrollId, item -> {
            State state = MarkLogicStateDeserializer.deserialize(item.asInputStream());
            return state.get((Object)"ecm:id").toString();
        });
    }

    public Lock getLock(String id) {
        State state = this.readState(id);
        if (state == null) {
            throw new DocumentNotFoundException(id);
        }
        String owner = (String)((Object)state.get((Object)"ecm:lockOwner"));
        if (owner == null) {
            return null;
        }
        Calendar created = (Calendar)state.get((Object)"ecm:lockCreated");
        return new Lock(owner, created);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lock setLock(String id, Lock lock) {
        State state = new State();
        state.put("ecm:lockOwner", (Serializable)((Object)lock.getOwner()));
        state.put("ecm:lockCreated", (Serializable)lock.getCreated());
        String lockString = MarkLogicStateSerializer.serialize(state);
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: SETLOCK " + id + ": " + lockString));
        }
        try (Session session = this.xccContentSource.newSession();){
            ModuleInvoke request = session.newModuleInvoke("/ext/nuxeo/set-lock.xqy");
            request.setNewStringVariable("uri", ID_FORMATTER.apply(id));
            request.setNewStringVariable("lock-string", lockString);
            ResultSequence result = session.submitRequest((Request)request);
            State resultState = MarkLogicStateDeserializer.deserialize(result.asString());
            Lock lock2 = this.extractLock(resultState);
            return lock2;
        }
        catch (RequestException e) {
            if (!"Document not found".equals(e.getMessage())) throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
            throw new DocumentNotFoundException(id, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lock removeLock(String id, String owner) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("MarkLogic: REMOVELOCK " + id + ": " + owner));
        }
        try (Session session = this.xccContentSource.newSession();){
            ModuleInvoke request = session.newModuleInvoke("/ext/nuxeo/remove-lock.xqy");
            request.setNewStringVariable("uri", ID_FORMATTER.apply(id));
            request.setNewStringVariable("owner", Strings.nullToEmpty((String)owner));
            ResultSequence result = session.submitRequest((Request)request);
            State resultState = MarkLogicStateDeserializer.deserialize(result.asString());
            Lock lock = this.extractLock(resultState);
            return lock;
        }
        catch (RequestException e) {
            if (!"Document not found".equals(e.getMessage())) throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
            throw new DocumentNotFoundException(id, (Throwable)e);
        }
    }

    private Lock extractLock(State state) {
        if (state.isEmpty()) {
            return null;
        }
        String owner = (String)((Object)state.get((Object)"ecm:lockOwner"));
        Calendar created = (Calendar)state.get((Object)"ecm:lockCreated");
        Boolean failed = (Boolean)state.get((Object)"failed");
        return new Lock(owner, created, Boolean.TRUE.equals(failed));
    }

    public void closeLockManager() {
    }

    public void clearLockManagerCaches() {
    }

    protected void initBlobsPaths() {
        MarkLogicBlobFinder finder = new MarkLogicBlobFinder();
        finder.visit();
        this.binaryPaths = finder.binaryPaths;
    }

    public void markReferencedBinaries() {
        DocumentBlobManager blobManager = (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
        String query = new MarkLogicQuerySimpleBuilder(this.rangeElementIndexes).build();
        try (Stream<State> states = this.findAll(query, this.binaryPaths.toArray(new String[0]));){
            states.forEach(state -> this.markReferencedBinaries((State)state, blobManager));
        }
    }

    protected void markReferencedBinaries(State state, DocumentBlobManager blobManager) {
        for (Map.Entry entry : state.entrySet()) {
            Serializable value = (Serializable)entry.getValue();
            if (value instanceof List) {
                List list = (List)((Object)value);
                for (Object v : list) {
                    if (v instanceof State) {
                        this.markReferencedBinaries((State)v, blobManager);
                        continue;
                    }
                    this.markReferencedBinary(v, blobManager);
                }
                continue;
            }
            if (value instanceof Object[]) {
                for (Object v : (Object[])value) {
                    this.markReferencedBinary(v, blobManager);
                }
                continue;
            }
            if (value instanceof State) {
                this.markReferencedBinaries((State)value, blobManager);
                continue;
            }
            this.markReferencedBinary(value, blobManager);
        }
    }

    protected void markReferencedBinary(Object value, DocumentBlobManager blobManager) {
        if (!(value instanceof String)) {
            return;
        }
        String key = (String)value;
        blobManager.markReferencedBinary(key, this.repositoryName);
    }

    private void logQuery(String query) {
        log.trace((Object)("MarkLogic: QUERY " + query));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exist(String ctsQuery) {
        String query = "xdmp:exists(" + ctsQuery + ")";
        if (log.isTraceEnabled()) {
            this.logQuery(query);
        }
        try (Session session = this.xccContentSource.newSession();){
            AdhocQuery request = session.newAdhocQuery(query);
            ResultSequence rs = session.submitRequest((Request)request);
            boolean bl = Boolean.parseBoolean(rs.asString());
            return bl;
        }
        catch (RequestException e) {
            throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private State findOne(String ctsQuery) {
        String query = ctsQuery + "[1 to 1]";
        if (log.isTraceEnabled()) {
            this.logQuery(query);
        }
        try (Session session = this.xccContentSource.newSession();){
            AdhocQuery request = session.newAdhocQuery(query);
            ResultSequence rs = session.submitRequest((Request)request);
            if (rs.hasNext()) {
                State state = MarkLogicStateDeserializer.deserialize(rs.asStrings()[0]);
                return state;
            }
            State state = null;
            return state;
        }
        catch (RequestException e) {
            throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Stream<State> findAll(String ctsQuery, String ... selects) {
        String query = ctsQuery;
        if (selects.length > 0) {
            query = "import module namespace extract = 'http://nuxeo.com/extract' at '/ext/nuxeo/extract.xqy';\nlet $paths := (" + Arrays.stream(selects).map(MarkLogicHelper::serializeKey).map(select -> "\"/document/" + select + "\"").collect(Collectors.joining(",\n")) + ")let $namespaces := ()\n" + "for $i in " + query + " return extract:extract-nodes($i, $paths, $namespaces)";
        }
        if (log.isTraceEnabled()) {
            this.logQuery(query);
        }
        boolean completedAbruptly = true;
        Session session = this.xccContentSource.newSession();
        try {
            RequestOptions options = new RequestOptions();
            options.setCacheResult(false);
            AdhocQuery request = session.newAdhocQuery(query, options);
            Supplier<Spliterator> spliteratorSupplier = () -> {
                try {
                    ResultSequence rs = session.submitRequest((Request)request);
                    Iterable items = () -> ((ResultSequence)rs).iterator();
                    return items.spliterator();
                }
                catch (RequestException e) {
                    throw new NuxeoException("An exception happened during xcc call", (Throwable)e);
                }
            };
            Stream<State> stream = ((Stream)StreamSupport.stream(spliteratorSupplier, 0, false).onClose(() -> ((Session)session).close())).map(ResultItem::getItem).map(XdmItem::asInputStream).map(MarkLogicStateDeserializer::deserialize);
            completedAbruptly = false;
            Stream<State> stream2 = stream;
            return stream2;
        }
        finally {
            if (completedAbruptly) {
                session.close();
            }
        }
    }

    protected static class MarkLogicBlobFinder
    extends DBSRepositoryBase.BlobFinder {
        protected List<String> binaryPaths = new ArrayList<String>();

        protected MarkLogicBlobFinder() {
        }

        protected void recordBlobPath() {
            this.path.addLast("data");
            StringBuilder binaryPath = new StringBuilder();
            MarkLogicSchemaManager schemaManager = new MarkLogicSchemaManager();
            Type previousType = null;
            for (String element : this.path) {
                if (binaryPath.length() > 0) {
                    binaryPath.append('/');
                }
                binaryPath.append(element);
                if (previousType == null) {
                    previousType = schemaManager.computeField(String.join((CharSequence)".", this.path), element).getType();
                } else if (previousType.isComplexType()) {
                    if (TypeConstants.isContentType(previousType)) break;
                    previousType = ((ComplexType)previousType).getField(element).getType();
                }
                if (!previousType.isListType()) continue;
                binaryPath.append('/').append(element).append("__item");
                previousType = ((ListType)previousType).getFieldType();
            }
            this.binaryPaths.add(binaryPath.toString());
            this.path.removeLast();
        }
    }
}

