/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.marklogic;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicRangeElementIndexDescriptor;

@XObject(value="repository")
public class MarkLogicRepositoryDescriptor
extends DBSRepositoryDescriptor {
    @XNode(value="host")
    public String host;
    @XNode(value="port")
    public Integer port;
    @XNode(value="user")
    public String user;
    @XNode(value="password")
    public String password;
    @XNode(value="dbname")
    public String dbname;
    @XNode(value="ssl@enabled")
    public boolean sslEnabled;
    @XNodeList(value="range-element-indexes/range-element-index", type=ArrayList.class, componentType=MarkLogicRangeElementIndexDescriptor.class)
    public List<MarkLogicRangeElementIndexDescriptor> rangeElementIndexes = new ArrayList<MarkLogicRangeElementIndexDescriptor>(0);

    public MarkLogicRepositoryDescriptor clone() {
        MarkLogicRepositoryDescriptor clone = (MarkLogicRepositoryDescriptor)super.clone();
        clone.rangeElementIndexes = this.rangeElementIndexes.stream().map(MarkLogicRangeElementIndexDescriptor::new).collect(Collectors.toList());
        return clone;
    }

    public void merge(MarkLogicRepositoryDescriptor other) {
        super.merge((DBSRepositoryDescriptor)other);
        if (other.host != null) {
            this.host = other.host;
        }
        if (other.port != null) {
            this.port = other.port;
        }
        if (other.password != null) {
            this.password = other.password;
        }
        if (other.dbname != null) {
            this.dbname = other.dbname;
        }
        for (MarkLogicRangeElementIndexDescriptor regi : other.rangeElementIndexes) {
            this.rangeElementIndexes.add(new MarkLogicRangeElementIndexDescriptor(regi));
        }
    }
}

