/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.marklogic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicHelper;

final class MarkLogicStateDeserializer {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    private MarkLogicStateDeserializer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static State deserialize(String s) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));){
            State state = MarkLogicStateDeserializer.deserialize(is);
            return state;
        }
        catch (IOException ioe) {
            throw new NuxeoException("Error during deserialization", (Throwable)ioe);
        }
    }

    public static State deserialize(InputStream is) {
        XMLEventReader xmler = null;
        try {
            xmler = xmlInputFactory.createXMLEventReader(is);
            while (xmler.hasNext()) {
                XMLEvent event = xmler.nextEvent();
                if (!event.isStartElement()) continue;
                State state = MarkLogicStateDeserializer.deserializeState(xmler);
                return state;
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (xmler != null) {
                try {
                    xmler.close();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new NuxeoException("An error occurred during xml deserialization.");
    }

    private static State deserializeState(XMLEventReader xmler) throws XMLStreamException {
        State state = new State();
        while (xmler.hasNext()) {
            XMLEvent event = xmler.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                state.put(MarkLogicHelper.deserializeKey(startElement.getName().getLocalPart()), MarkLogicStateDeserializer.deserializeValue(xmler, startElement));
                continue;
            }
            if (!event.isEndElement()) continue;
            break;
        }
        return state;
    }

    private static Serializable deserializeValue(XMLEventReader xmler, StartElement element) throws XMLStreamException {
        Object result;
        Optional<MarkLogicHelper.ElementType> typeOpt = MarkLogicStateDeserializer.getElementType(element);
        if (typeOpt.isPresent()) {
            String text = xmler.peek().isEndElement() ? "" : xmler.nextEvent().asCharacters().getData();
            switch (typeOpt.get()) {
                case BOOLEAN: {
                    result = Boolean.parseBoolean(text);
                    break;
                }
                case DOUBLE: {
                    if (text.contains(".")) {
                        result = Double.parseDouble(text);
                        break;
                    }
                    result = Long.parseLong(text);
                    break;
                }
                case LONG: {
                    result = Long.parseLong(text);
                    break;
                }
                case CALENDAR: {
                    result = MarkLogicHelper.deserializeCalendar(text);
                    break;
                }
                default: {
                    result = text;
                }
            }
            XMLEvent event = xmler.nextEvent();
            if (event.isCharacters() && event.asCharacters().isIgnorableWhiteSpace()) {
                xmler.nextEvent();
            }
        } else {
            XMLEvent event;
            if (xmler.peek().isCharacters() && xmler.peek().asCharacters().isWhiteSpace()) {
                xmler.nextEvent();
            }
            if ((event = xmler.peek()).isEndElement()) {
                result = null;
                xmler.nextEvent();
            } else {
                result = event.asStartElement().getName().getLocalPart().endsWith("__item") ? MarkLogicStateDeserializer.deserializeList(xmler) : MarkLogicStateDeserializer.deserializeState(xmler);
            }
        }
        return result;
    }

    private static Serializable deserializeList(XMLEventReader xmler) throws XMLStreamException {
        Object[] result;
        Optional<MarkLogicHelper.ElementType> type = MarkLogicStateDeserializer.getElementType(xmler.peek().asStartElement());
        if (type.isPresent()) {
            ArrayList<Serializable> l = new ArrayList<Serializable>();
            while (xmler.hasNext()) {
                XMLEvent event = xmler.nextEvent();
                if (event.isStartElement()) {
                    l.add(MarkLogicStateDeserializer.deserializeValue(xmler, event.asStartElement()));
                    continue;
                }
                if (!event.isEndElement()) continue;
                break;
            }
            Class<?> scalarType = MarkLogicStateDeserializer.scalarTypeToSerializableClass(type.get(), l.get(0).toString());
            result = l.toArray((Object[])Array.newInstance(scalarType, l.size()));
        } else {
            Object[] l = new ArrayList();
            while (xmler.hasNext()) {
                XMLEvent event = xmler.nextEvent();
                if (event.isStartElement()) {
                    l.add(MarkLogicStateDeserializer.deserializeState(xmler));
                    continue;
                }
                if (!event.isEndElement()) continue;
                break;
            }
            result = l;
        }
        return result;
    }

    private static Optional<MarkLogicHelper.ElementType> getElementType(StartElement element) {
        return Optional.ofNullable(element.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"))).map(Attribute::getValue).map(MarkLogicHelper.ElementType::of);
    }

    private static Class<?> scalarTypeToSerializableClass(MarkLogicHelper.ElementType type, String content) {
        Class result;
        switch (type) {
            case BOOLEAN: {
                result = Boolean.class;
                break;
            }
            case DOUBLE: {
                if (content.contains(".")) {
                    result = Double.class;
                    break;
                }
                result = Long.class;
                break;
            }
            case LONG: {
                result = Long.class;
                break;
            }
            case CALENDAR: {
                result = Calendar.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
    }
}

